/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.module;

import com.sun.security.auth.UnixNumericGroupPrincipal;
import com.sun.security.auth.UnixNumericUserPrincipal;
import com.sun.security.auth.UnixPrincipal;
import com.sun.security.auth.module.UnixSystem;
import java.util.LinkedList;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnixLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = true;
    private UnixSystem ss;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private UnixPrincipal userPrincipal;
    private UnixNumericUserPrincipal UIDPrincipal;
    private UnixNumericGroupPrincipal GIDPrincipal;
    private LinkedList supplementaryGroups = new LinkedList();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> map, Map<String, ?> map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
    }

    @Override
    public boolean login() throws LoginException {
        int n;
        long[] lArray = null;
        this.ss = new UnixSystem();
        if (this.ss == null) {
            this.succeeded = false;
            throw new FailedLoginException("Failed in attempt to import the underlying system identity information");
        }
        this.userPrincipal = new UnixPrincipal(this.ss.getUsername());
        this.UIDPrincipal = new UnixNumericUserPrincipal(this.ss.getUid());
        this.GIDPrincipal = new UnixNumericGroupPrincipal(this.ss.getGid(), true);
        if (this.ss.getGroups() != null && this.ss.getGroups().length > 0) {
            lArray = this.ss.getGroups();
        }
        for (n = 0; n < lArray.length; ++n) {
            UnixNumericGroupPrincipal unixNumericGroupPrincipal = new UnixNumericGroupPrincipal(lArray[n], false);
            if (unixNumericGroupPrincipal.getName().equals(this.GIDPrincipal.getName())) continue;
            this.supplementaryGroups.add(unixNumericGroupPrincipal);
        }
        if (this.debug) {
            System.out.println("\t\t[UnixLoginModule]: succeeded importing info: ");
            System.out.println("\t\t\tuid = " + this.ss.getUid());
            System.out.println("\t\t\tgid = " + this.ss.getGid());
            lArray = this.ss.getGroups();
            for (n = 0; n < lArray.length; ++n) {
                System.out.println("\t\t\tsupp gid = " + lArray[n]);
            }
        }
        this.succeeded = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            if (this.debug) {
                System.out.println("\t\t[UnixLoginModule]: did not add any Principals to Subject because own authentication failed.");
            }
            return false;
        }
        if (this.subject.isReadOnly()) {
            throw new LoginException("commit Failed: Subject is Readonly");
        }
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        if (!this.subject.getPrincipals().contains(this.UIDPrincipal)) {
            this.subject.getPrincipals().add(this.UIDPrincipal);
        }
        if (!this.subject.getPrincipals().contains(this.GIDPrincipal)) {
            this.subject.getPrincipals().add(this.GIDPrincipal);
        }
        for (int i = 0; i < this.supplementaryGroups.size(); ++i) {
            if (this.subject.getPrincipals().contains((UnixNumericGroupPrincipal)this.supplementaryGroups.get(i))) continue;
            this.subject.getPrincipals().add((UnixNumericGroupPrincipal)this.supplementaryGroups.get(i));
        }
        if (this.debug) {
            System.out.println("\t\t[UnixLoginModule]: added UnixPrincipal,");
            System.out.println("\t\t\t\tUnixNumericUserPrincipal,");
            System.out.println("\t\t\t\tUnixNumericGroupPrincipal(s),");
            System.out.println("\t\t\t to Subject");
        }
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[UnixLoginModule]: aborted authentication attempt");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.ss = null;
            this.userPrincipal = null;
            this.UIDPrincipal = null;
            this.GIDPrincipal = null;
            this.supplementaryGroups = new LinkedList();
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            throw new LoginException("logout Failed: Subject is Readonly");
        }
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.subject.getPrincipals().remove(this.UIDPrincipal);
        this.subject.getPrincipals().remove(this.GIDPrincipal);
        for (int i = 0; i < this.supplementaryGroups.size(); ++i) {
            this.subject.getPrincipals().remove((UnixNumericGroupPrincipal)this.supplementaryGroups.get(i));
        }
        this.ss = null;
        this.succeeded = false;
        this.commitSucceeded = false;
        this.userPrincipal = null;
        this.UIDPrincipal = null;
        this.GIDPrincipal = null;
        this.supplementaryGroups = new LinkedList();
        if (this.debug) {
            System.out.println("\t\t[UnixLoginModule]: logged out Subject");
        }
        return true;
    }
}

