/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelayQueue<E extends Delayed>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final transient ReentrantLock lock = new ReentrantLock();
    private final transient Condition available = this.lock.newCondition();
    private final PriorityQueue<E> q = new PriorityQueue();

    public DelayQueue() {
    }

    public DelayQueue(Collection<? extends E> collection) {
        this.addAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Delayed delayed = (Delayed)this.q.peek();
            this.q.offer(e);
            if (delayed == null || e.compareTo((Delayed)delayed) < 0) {
                this.available.signalAll();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public void put(E e) {
        this.offer(e);
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) {
        return this.offer(e);
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public E take() throws InterruptedException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (true) {
                Delayed delayed;
                if ((delayed = (Delayed)this.q.peek()) == null) {
                    this.available.await();
                    continue;
                }
                long l = delayed.getDelay(TimeUnit.NANOSECONDS);
                if (l > 0L) {
                    long l2 = this.available.awaitNanos(l);
                    continue;
                }
                Delayed delayed2 = (Delayed)this.q.poll();
                assert (delayed2 != null);
                if (this.q.size() != 0) {
                    this.available.signalAll();
                }
                Delayed delayed3 = delayed2;
                return (E)delayed3;
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        long l2 = timeUnit.toNanos(l);
        try {
            while (true) {
                Delayed delayed;
                if ((delayed = (Delayed)this.q.peek()) == null) {
                    if (l2 <= 0L) {
                        E e = null;
                        return e;
                    }
                    l2 = this.available.awaitNanos(l2);
                    continue;
                }
                long l3 = delayed.getDelay(TimeUnit.NANOSECONDS);
                if (l3 > 0L) {
                    if (l2 <= 0L) {
                        E e = null;
                        return e;
                    }
                    if (l3 > l2) {
                        l3 = l2;
                    }
                    long l4 = this.available.awaitNanos(l3);
                    l2 -= l3 - l4;
                    continue;
                }
                Delayed delayed2 = (Delayed)this.q.poll();
                assert (delayed2 != null);
                if (this.q.size() != 0) {
                    this.available.signalAll();
                }
                Delayed delayed3 = delayed2;
                return (E)delayed3;
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Delayed delayed = (Delayed)this.q.peek();
            if (delayed == null || delayed.getDelay(TimeUnit.NANOSECONDS) > 0L) {
                E e = null;
                return e;
            }
            Delayed delayed2 = (Delayed)this.q.poll();
            assert (delayed2 != null);
            if (this.q.size() != 0) {
                this.available.signalAll();
            }
            Delayed delayed3 = delayed2;
            return (E)delayed3;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Delayed delayed = (Delayed)this.q.peek();
            return (E)delayed;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.q.size();
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Delayed delayed;
            int n = 0;
            while ((delayed = (Delayed)this.q.peek()) != null && delayed.getDelay(TimeUnit.NANOSECONDS) <= 0L) {
                collection.add(this.q.poll());
                ++n;
            }
            if (n > 0) {
                this.available.signalAll();
            }
            int n2 = n;
            return n2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        if (n <= 0) {
            return 0;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Delayed delayed;
            int n2;
            for (n2 = 0; n2 < n && (delayed = (Delayed)this.q.peek()) != null && delayed.getDelay(TimeUnit.NANOSECONDS) <= 0L; ++n2) {
                collection.add(this.q.poll());
            }
            if (n2 > 0) {
                this.available.signalAll();
            }
            int n3 = n2;
            return n3;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            this.q.clear();
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = this.q.toArray();
            return objectArray;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] TArray) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            T[] TArray2 = this.q.toArray(TArray);
            return TArray2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = this.q.remove(object);
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Itr<E> itr = new Itr<E>(this.q.iterator());
            return itr;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr<E>
    implements Iterator<E> {
        private final Iterator<E> iter;

        Itr(Iterator<E> iterator) {
            this.iter = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            ReentrantLock reentrantLock = DelayQueue.this.lock;
            reentrantLock.lock();
            try {
                E e = this.iter.next();
                return e;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ReentrantLock reentrantLock = DelayQueue.this.lock;
            reentrantLock.lock();
            try {
                this.iter.remove();
            }
            finally {
                reentrantLock.unlock();
            }
        }
    }
}

