/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.CounterMonitorMBean;
import javax.management.monitor.Monitor;

public class CounterMonitor
extends Monitor
implements CounterMonitorMBean {
    private static final Integer INTEGER_ZERO = new Integer(0);
    private Number[] threshold = new Number[16];
    private Number modulus = INTEGER_ZERO;
    private Number offset = INTEGER_ZERO;
    private boolean notify = false;
    private boolean differenceMode = false;
    private Number initThreshold = INTEGER_ZERO;
    private Number[] derivedGauge = new Number[16];
    private long[] derivedGaugeTimestamp = new long[16];
    private Number[] previousScanCounter = new Number[16];
    private boolean[] modulusExceeded = new boolean[16];
    private Number[] derivedGaugeExceeded = new Number[16];
    private boolean[] eventAlreadyNotified = new boolean[16];
    private int[] type = new int[16];
    private static final int INTEGER = 0;
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int LONG = 3;
    private static final int THRESHOLD_ERROR_NOTIFIED = 16;
    private Timer timer = null;

    String makeDebugTag() {
        return "CounterMonitor";
    }

    public CounterMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDeregister() throws Exception {
        super.preDeregister();
        if (CounterMonitor.isTraceOn()) {
            this.trace("preDeregister", "reset the threshold values");
        }
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            for (int i = 0; i < this.elementCount; ++i) {
                this.threshold[i] = this.initThreshold;
            }
        }
    }

    public synchronized void start() {
        if (CounterMonitor.isTraceOn()) {
            this.trace("start", "start the counter monitor");
        }
        if (this.isActive()) {
            if (CounterMonitor.isTraceOn()) {
                this.trace("start", "the counter monitor is already activated");
            }
            return;
        }
        this.isActive = true;
        for (int i = 0; i < this.elementCount; ++i) {
            this.threshold[i] = this.initThreshold;
            this.modulusExceeded[i] = false;
            this.eventAlreadyNotified[i] = false;
            this.previousScanCounter[i] = null;
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new CounterAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
    }

    public synchronized void stop() {
        if (CounterMonitor.isTraceOn()) {
            this.trace("stop", "stop the counter monitor");
        }
        if (CounterMonitor.isTraceOn()) {
            this.trace("stop", "the counter monitor is not started");
            return;
        }
        this.isActive = false;
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public synchronized void setGranularityPeriod(long l) throws IllegalArgumentException {
        super.setGranularityPeriod(l);
        if (this.isActive()) {
            this.timer.cancel();
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new CounterAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        }
    }

    public synchronized Number getDerivedGauge(ObjectName objectName) {
        int n = this.indexOf(objectName);
        if (n != -1) {
            return this.derivedGauge[n];
        }
        return null;
    }

    public synchronized long getDerivedGaugeTimeStamp(ObjectName objectName) {
        int n = this.indexOf(objectName);
        if (n != -1) {
            return this.derivedGaugeTimestamp[n];
        }
        return 0L;
    }

    public synchronized Number getThreshold(ObjectName objectName) {
        int n = this.indexOf(objectName);
        if (n != -1) {
            return this.threshold[n];
        }
        return null;
    }

    public synchronized Number getInitThreshold() {
        return this.initThreshold;
    }

    public synchronized void setInitThreshold(Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("Null threshold");
        }
        if (number.longValue() < 0L) {
            throw new IllegalArgumentException("Negative threshold");
        }
        this.initThreshold = number;
        for (int i = 0; i < this.elementCount; ++i) {
            this.threshold[i] = number;
            this.resetAlreadyNotified(i, 16);
            this.modulusExceeded[i] = false;
            this.eventAlreadyNotified[i] = false;
        }
    }

    @Deprecated
    public synchronized Number getDerivedGauge() {
        return this.derivedGauge[0];
    }

    @Deprecated
    public synchronized long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    @Deprecated
    public synchronized Number getThreshold() {
        return this.threshold[0];
    }

    @Deprecated
    public synchronized void setThreshold(Number number) throws IllegalArgumentException {
        this.setInitThreshold(number);
    }

    public synchronized Number getOffset() {
        return this.offset;
    }

    public synchronized void setOffset(Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("Null offset");
        }
        if (number.longValue() < 0L) {
            throw new IllegalArgumentException("Negative offset");
        }
        this.offset = number;
        for (int i = 0; i < this.elementCount; ++i) {
            this.resetAlreadyNotified(i, 16);
        }
    }

    public synchronized Number getModulus() {
        return this.modulus;
    }

    public synchronized void setModulus(Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("Null modulus");
        }
        if (number.longValue() < 0L) {
            throw new IllegalArgumentException("Negative modulus");
        }
        this.modulus = number;
        for (int i = 0; i < this.elementCount; ++i) {
            this.resetAlreadyNotified(i, 16);
            this.modulusExceeded[i] = false;
        }
    }

    public synchronized boolean getNotify() {
        return this.notify;
    }

    public synchronized void setNotify(boolean bl) {
        this.notify = bl;
    }

    public synchronized boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public synchronized void setDifferenceMode(boolean bl) {
        this.differenceMode = bl;
        for (int i = 0; i < this.elementCount; ++i) {
            this.threshold[i] = this.initThreshold;
            this.modulusExceeded[i] = false;
            this.eventAlreadyNotified[i] = false;
            this.previousScanCounter[i] = null;
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.threshold", "jmx.monitor.counter.threshold"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, "javax.management.monitor.MonitorNotification", "Notifications sent by the CounterMonitor MBean")};
        return mBeanNotificationInfoArray;
    }

    private synchronized boolean updateDerivedGauge(Object object, int n) {
        boolean bl;
        this.derivedGaugeTimestamp[n] = System.currentTimeMillis();
        if (this.differenceMode) {
            if (this.previousScanCounter[n] != null) {
                this.setDerivedGaugeWithDifference((Number)object, null, n);
                if (this.derivedGauge[n].longValue() < 0L) {
                    if (this.modulus.longValue() > 0L) {
                        this.setDerivedGaugeWithDifference((Number)object, this.modulus, n);
                    }
                    this.threshold[n] = this.initThreshold;
                    this.eventAlreadyNotified[n] = false;
                }
                bl = true;
            } else {
                bl = false;
            }
            this.previousScanCounter[n] = (Number)object;
        } else {
            this.derivedGauge[n] = (Number)object;
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotifications(int n) {
        boolean bl = false;
        String string = null;
        long l = 0L;
        String string2 = null;
        Number number = null;
        Number number2 = null;
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            if (!this.eventAlreadyNotified[n]) {
                if (this.derivedGauge[n].longValue() >= this.threshold[n].longValue()) {
                    if (this.notify) {
                        bl = true;
                        string = "jmx.monitor.counter.threshold";
                        l = this.derivedGaugeTimestamp[n];
                        string2 = "";
                        number = this.derivedGauge[n];
                        number2 = this.threshold[n];
                    }
                    if (!this.differenceMode) {
                        this.eventAlreadyNotified[n] = true;
                    }
                }
            } else if (CounterMonitor.isTraceOn()) {
                this.trace("updateNotifications", "the notification:\n\tNotification observed object = " + this.getObservedObject(n) + "\n\tNotification observed attribute = " + this.getObservedAttribute() + "\n\tNotification derived gauge = " + this.derivedGauge[n] + "\nhas already been sent");
            }
        }
        if (bl) {
            this.sendNotification(string, l, string2, number, number2, n);
        }
    }

    private synchronized void updateThreshold(int n) {
        if (this.derivedGauge[n].longValue() >= this.threshold[n].longValue()) {
            if (this.offset.longValue() > 0L) {
                long l;
                for (l = this.threshold[n].longValue(); this.derivedGauge[n].longValue() >= l; l += this.offset.longValue()) {
                }
                switch (this.type[n]) {
                    case 0: {
                        this.threshold[n] = new Integer((int)l);
                        break;
                    }
                    case 1: {
                        this.threshold[n] = new Byte((byte)l);
                        break;
                    }
                    case 2: {
                        this.threshold[n] = new Short((short)l);
                        break;
                    }
                    case 3: {
                        this.threshold[n] = new Long(l);
                        break;
                    }
                    default: {
                        if (!CounterMonitor.isDebugOn()) break;
                        this.debug("updateThreshold", "the threshold type is invalid");
                    }
                }
                if (!this.differenceMode && this.modulus.longValue() > 0L && this.threshold[n].longValue() > this.modulus.longValue()) {
                    this.modulusExceeded[n] = true;
                    this.derivedGaugeExceeded[n] = this.derivedGauge[n];
                }
                this.eventAlreadyNotified[n] = false;
            } else {
                this.modulusExceeded[n] = true;
                this.derivedGaugeExceeded[n] = this.derivedGauge[n];
            }
        }
    }

    private synchronized boolean isThresholdTypeValid(int n) {
        switch (this.type[n]) {
            case 0: {
                return !(!(this.threshold[n] instanceof Integer) || this.offset != INTEGER_ZERO && !(this.offset instanceof Integer) || this.modulus != INTEGER_ZERO && !(this.modulus instanceof Integer));
            }
            case 1: {
                return !(!(this.threshold[n] instanceof Byte) || this.offset != INTEGER_ZERO && !(this.offset instanceof Byte) || this.modulus != INTEGER_ZERO && !(this.modulus instanceof Byte));
            }
            case 2: {
                return !(!(this.threshold[n] instanceof Short) || this.offset != INTEGER_ZERO && !(this.offset instanceof Short) || this.modulus != INTEGER_ZERO && !(this.modulus instanceof Short));
            }
            case 3: {
                return !(!(this.threshold[n] instanceof Long) || this.offset != INTEGER_ZERO && !(this.offset instanceof Long) || this.modulus != INTEGER_ZERO && !(this.modulus instanceof Long));
            }
        }
        if (CounterMonitor.isDebugOn()) {
            this.debug("isThresholdTypeValid", "The threshold type is invalid");
        }
        return false;
    }

    private synchronized void setDerivedGaugeWithDifference(Number number, Number number2, int n) {
        long l = number.longValue() - this.previousScanCounter[n].longValue();
        if (number2 != null) {
            l += this.modulus.longValue();
        }
        switch (this.type[n]) {
            case 0: {
                this.derivedGauge[n] = new Integer((int)l);
                break;
            }
            case 1: {
                this.derivedGauge[n] = new Byte((byte)l);
                break;
            }
            case 2: {
                this.derivedGauge[n] = new Short((short)l);
                break;
            }
            case 3: {
                this.derivedGauge[n] = new Long(l);
                break;
            }
            default: {
                if (!CounterMonitor.isDebugOn()) break;
                this.debug("setDerivedGaugeWithDifference", "the threshold type is invalid");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAlarmClock(int n) {
        long l = 0L;
        String string = null;
        Number number = null;
        Object object = null;
        String string2 = null;
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            if (!this.isActive()) {
                return;
            }
            if (this.getObservedObject(n) == null || this.getObservedAttribute() == null) {
                return;
            }
            try {
                object = this.server.getAttribute(this.getObservedObject(n), this.getObservedAttribute());
                if (object == null) {
                    return;
                }
            }
            catch (NullPointerException nullPointerException) {
                if (this.alreadyNotified(n, 8)) {
                    return;
                }
                string2 = "jmx.monitor.error.runtime";
                this.setAlreadyNotified(n, 8);
                string = "The counter monitor must be registered in the MBean server.";
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (this.alreadyNotified(n, 1)) {
                    return;
                }
                string2 = "jmx.monitor.error.mbean";
                this.setAlreadyNotified(n, 1);
                string = "The observed object must be registered in the MBean server.";
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                if (this.alreadyNotified(n, 2)) {
                    return;
                }
                string2 = "jmx.monitor.error.attribute";
                this.setAlreadyNotified(n, 2);
                string = "The observed attribute must be accessible in the observed object.";
            }
            catch (MBeanException mBeanException) {
                if (this.alreadyNotified(n, 8)) {
                    return;
                }
                string2 = "jmx.monitor.error.runtime";
                this.setAlreadyNotified(n, 8);
                string = mBeanException.getMessage();
            }
            catch (ReflectionException reflectionException) {
                if (this.alreadyNotified(n, 2)) {
                    return;
                }
                string2 = "jmx.monitor.error.attribute";
                this.setAlreadyNotified(n, 2);
                string = reflectionException.getMessage();
            }
            if (string == null) {
                if (object instanceof Integer) {
                    this.type[n] = 0;
                } else if (object instanceof Byte) {
                    this.type[n] = 1;
                } else if (object instanceof Short) {
                    this.type[n] = 2;
                } else if (object instanceof Long) {
                    this.type[n] = 3;
                } else {
                    if (this.alreadyNotified(n, 4)) {
                        return;
                    }
                    string2 = "jmx.monitor.error.type";
                    this.setAlreadyNotified(n, 4);
                    string = "The observed attribute type must be an integer type.";
                }
            }
            if (string == null && !this.isThresholdTypeValid(n)) {
                if (this.alreadyNotified(n, 16)) {
                    return;
                }
                string2 = "jmx.monitor.error.threshold";
                this.setAlreadyNotified(n, 16);
                string = "The threshold, offset and modulus must be of the same type as the counter.";
            }
            if (string == null) {
                boolean bl;
                this.resetAllAlreadyNotified(n);
                if (this.modulusExceeded[n] && this.derivedGauge[n].longValue() < this.derivedGaugeExceeded[n].longValue()) {
                    this.threshold[n] = this.initThreshold;
                    this.modulusExceeded[n] = false;
                    this.eventAlreadyNotified[n] = false;
                }
                if (bl = this.updateDerivedGauge(object, n)) {
                    this.updateNotifications(n);
                    this.updateThreshold(n);
                }
            } else {
                l = this.derivedGaugeTimestamp[n];
                number = this.derivedGauge[n];
                this.modulusExceeded[n] = false;
                this.eventAlreadyNotified[n] = false;
                this.previousScanCounter[n] = null;
            }
        }
        if (string != null) {
            this.sendNotification(string2, l, string, number, null, n);
        }
    }

    synchronized void insertSpecificElementAt(int n) {
        if (n != this.elementCount) {
            throw new Error("Internal error: index != elementCount");
        }
        if (this.elementCount >= this.threshold.length) {
            this.threshold = this.expandArray(this.threshold);
            this.derivedGauge = this.expandArray(this.derivedGauge);
            this.previousScanCounter = this.expandArray(this.previousScanCounter);
            this.derivedGaugeExceeded = this.expandArray(this.derivedGaugeExceeded);
            this.derivedGaugeTimestamp = this.expandArray(this.derivedGaugeTimestamp);
            this.modulusExceeded = this.expandArray(this.modulusExceeded);
            this.eventAlreadyNotified = this.expandArray(this.eventAlreadyNotified);
            this.type = this.expandArray(this.type);
        }
        this.threshold[n] = INTEGER_ZERO;
        this.derivedGauge[n] = INTEGER_ZERO;
        this.previousScanCounter[n] = null;
        this.derivedGaugeExceeded[n] = null;
        this.derivedGaugeTimestamp[n] = System.currentTimeMillis();
        this.modulusExceeded[n] = false;
        this.eventAlreadyNotified[n] = false;
        this.type[n] = 0;
    }

    synchronized void removeSpecificElementAt(int n) {
        this.removeElementAt(this.threshold, n);
        this.removeElementAt(this.derivedGauge, n);
        this.removeElementAt(this.previousScanCounter, n);
        this.removeElementAt(this.derivedGaugeExceeded, n);
        this.removeElementAt(this.derivedGaugeTimestamp, n);
        this.removeElementAt(this.modulusExceeded, n);
        this.removeElementAt(this.eventAlreadyNotified, n);
        this.removeElementAt(this.type, n);
    }

    private static class CounterAlarmClock
    extends TimerTask {
        CounterMonitor listener = null;

        public CounterAlarmClock(CounterMonitor counterMonitor) {
            this.listener = counterMonitor;
        }

        public void run() {
            if (this.listener.isActive()) {
                for (int i = 0; i < this.listener.elementCount; ++i) {
                    this.listener.notifyAlarmClock(i);
                }
            }
        }
    }
}

