/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import sun.io.ByteToCharConverter;
import sun.io.CompoundTextSupport;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class ByteToCharCOMPOUND_TEXT
extends ByteToCharConverter {
    private static final int NORMAL_BYTES = 0;
    private static final int NONSTANDARD_BYTES = 1;
    private static final int VERSION_SEQUENCE_V = 2;
    private static final int VERSION_SEQUENCE_TERM = 3;
    private static final int ESCAPE_SEQUENCE = 4;
    private static final int CHARSET_NGIIF = 5;
    private static final int CHARSET_NLIIF = 6;
    private static final int CHARSET_NLIF = 7;
    private static final int CHARSET_NRIIF = 8;
    private static final int CHARSET_NRIF = 9;
    private static final int CHARSET_NONSTANDARD_FOML = 10;
    private static final int CHARSET_NONSTANDARD_OML = 11;
    private static final int CHARSET_NONSTANDARD_ML = 12;
    private static final int CHARSET_NONSTANDARD_L = 13;
    private static final int CHARSET_NONSTANDARD = 14;
    private static final int CHARSET_LIIF = 15;
    private static final int CHARSET_LIF = 16;
    private static final int CHARSET_RIIF = 17;
    private static final int CHARSET_RIF = 18;
    private static final int CONTROL_SEQUENCE_PIF = 19;
    private static final int CONTROL_SEQUENCE_IF = 20;
    private static final int EXTENSION_ML = 21;
    private static final int EXTENSION_L = 22;
    private static final int EXTENSION = 23;
    private static final int ESCAPE_SEQUENCE_OTHER = 24;
    private static final String ERR_LATIN1 = "ISO8859_1 unsupported";
    private static final String ERR_ILLSTATE = "Illegal state";
    private static final String ERR_ESCBYTE = "Illegal byte in 0x1B escape sequence";
    private static final String ERR_ENCODINGBYTE = "Illegal byte in non-standard character set name";
    private static final String ERR_CTRLBYTE = "Illegal byte in 0x9B control sequence";
    private static final String ERR_CTRLPI = "P following I in 0x9B control sequence";
    private static final String ERR_VERSTART = "Versioning escape sequence can only appear at start of byte stream";
    private static final String ERR_VERMANDATORY = "Cannot parse mandatory extensions";
    private static final String ERR_ENCODING = "Unknown encoding: ";
    private static final String ERR_FLUSH = "Escape sequence, control sequence, or ML extension not terminated";
    private int state = 0;
    private int ext_count;
    private int ext_offset;
    private boolean versionSequenceAllowed = true;
    private byte[] byteBuf = new byte[1];
    private ByteArrayOutputStream queue = new ByteArrayOutputStream();
    private ByteArrayOutputStream encodingQueue = new ByteArrayOutputStream();
    private ByteToCharConverter glConverter;
    private ByteToCharConverter grConverter;
    private ByteToCharConverter nonStandardConverter;
    private ByteToCharConverter lastConverter;
    private boolean glHigh = false;
    private boolean grHigh = true;

    public ByteToCharCOMPOUND_TEXT() {
        try {
            this.glConverter = ByteToCharConverter.getConverter("ASCII");
            this.grConverter = ByteToCharConverter.getConverter("ISO8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.error(ERR_LATIN1);
        }
        this.initConverter(this.glConverter);
        this.initConverter(this.grConverter);
    }

    public String getCharacterEncoding() {
        return "COMPOUND_TEXT";
    }

    public int convert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        int n5 = n3;
        this.byteOff = n;
        this.charOff = n3;
        if (n >= n2) {
            return 0;
        }
        while (this.byteOff < n2) {
            this.handleByte((short)(byArray[this.byteOff] & 0xFF), cArray, n4);
            ++this.byteOff;
        }
        return this.charOff - n5;
    }

    private void handleByte(short s, char[] cArray, int n) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        switch (this.state) {
            case 0: {
                this.normalBytes(s, cArray, n);
                break;
            }
            case 1: {
                this.nonStandardBytes(s, cArray, n);
                break;
            }
            case 2: 
            case 3: {
                this.versionSequence(s);
                break;
            }
            case 4: {
                this.escapeSequence(s);
                break;
            }
            case 5: {
                this.charset94N(s);
                break;
            }
            case 6: 
            case 7: {
                this.charset94NL(s, cArray, n);
                break;
            }
            case 8: 
            case 9: {
                this.charset94NR(s, cArray, n);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.charsetNonStandard(s, cArray, n);
                break;
            }
            case 15: 
            case 16: {
                this.charset9496L(s, cArray, n);
                break;
            }
            case 17: 
            case 18: {
                this.charset9496R(s, cArray, n);
                break;
            }
            case 19: 
            case 20: {
                this.controlSequence(s);
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                this.extension(s);
                break;
            }
            case 24: {
                this.escapeSequenceOther(s);
                break;
            }
            default: {
                this.error(ERR_ILLSTATE);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void normalBytes(short s, char[] cArray, int n) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        if (s >= 0 && s <= 31 || s >= 128 && s <= 159) {
            int n2;
            switch (s) {
                case 27: {
                    this.state = 4;
                    this.queue.write(s);
                    return;
                }
                case 155: {
                    this.state = 19;
                    this.versionSequenceAllowed = false;
                    this.queue.write(s);
                    return;
                }
                case 9: {
                    this.versionSequenceAllowed = false;
                    n2 = 9;
                    break;
                }
                case 10: {
                    this.versionSequenceAllowed = false;
                    n2 = 10;
                    break;
                }
                default: {
                    this.versionSequenceAllowed = false;
                    return;
                }
            }
            if (this.charOff >= n) throw new ConversionBufferFullException();
            cArray[this.charOff++] = n2;
            return;
        } else {
            boolean bl;
            ByteToCharConverter byteToCharConverter;
            this.versionSequenceAllowed = false;
            if (s >= 32 && s <= 127) {
                byteToCharConverter = this.glConverter;
                bl = this.glHigh;
            } else {
                byteToCharConverter = this.grConverter;
                bl = this.grHigh;
            }
            if (this.lastConverter != null && byteToCharConverter != this.lastConverter) {
                this.flushConverter(this.lastConverter, cArray, n);
            }
            this.lastConverter = byteToCharConverter;
            if (byteToCharConverter != null) {
                this.byteBuf[0] = (byte)s;
                this.byteBuf[0] = bl ? (byte)(this.byteBuf[0] | 0x80) : (byte)(this.byteBuf[0] & 0x7F);
                try {
                    this.charOff += byteToCharConverter.convert(this.byteBuf, 0, 1, cArray, this.charOff, n);
                    return;
                }
                catch (MalformedInputException malformedInputException) {
                    this.badInputLength = byteToCharConverter.getBadInputLength();
                    throw malformedInputException;
                }
            } else {
                if (this.charOff >= n) throw new ConversionBufferFullException();
                cArray[this.charOff++] = this.subChars.length > 0 ? this.subChars[0] : (char)'\u0000';
            }
        }
    }

    private void nonStandardBytes(short s, char[] cArray, int n) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        if (this.nonStandardConverter != null) {
            this.byteBuf[0] = (byte)s;
            try {
                this.charOff += this.nonStandardConverter.convert(this.byteBuf, 0, 1, cArray, this.charOff, n);
            }
            catch (MalformedInputException malformedInputException) {
                this.badInputLength = this.nonStandardConverter.getBadInputLength();
                throw malformedInputException;
            }
        } else if (this.charOff < n) {
            cArray[this.charOff++] = this.subChars.length > 0 ? this.subChars[0] : (char)'\u0000';
        } else {
            throw new ConversionBufferFullException();
        }
        ++this.ext_offset;
        if (this.ext_offset >= this.ext_count) {
            this.ext_count = 0;
            this.ext_offset = 0;
            this.state = 0;
            this.flushConverter(this.nonStandardConverter, cArray, n);
            this.nonStandardConverter = null;
        }
    }

    private void escapeSequence(short s) throws MalformedInputException {
        switch (s) {
            case 35: {
                this.state = 2;
                break;
            }
            case 36: {
                this.state = 5;
                this.versionSequenceAllowed = false;
                break;
            }
            case 37: {
                this.state = 10;
                this.versionSequenceAllowed = false;
                break;
            }
            case 40: {
                this.state = 15;
                this.versionSequenceAllowed = false;
                break;
            }
            case 41: 
            case 45: {
                this.state = 17;
                this.versionSequenceAllowed = false;
                break;
            }
            default: {
                this.escapeSequenceOther(s);
                return;
            }
        }
        this.queue.write(s);
    }

    private void escapeSequenceOther(short s) throws MalformedInputException {
        if (s >= 32 && s <= 47) {
            this.state = 24;
            this.versionSequenceAllowed = false;
            this.queue.write(s);
        } else if (s >= 48 && s <= 126) {
            this.state = 0;
            this.versionSequenceAllowed = false;
            this.queue.reset();
        } else {
            this.malformedInput(ERR_ESCBYTE);
        }
    }

    private void controlSequence(short s) throws MalformedInputException {
        if (s >= 48 && s <= 63) {
            if (this.state == 20) {
                this.malformedInput(ERR_CTRLPI);
            }
            this.queue.write(s);
        } else if (s >= 32 && s <= 47) {
            this.state = 20;
            this.queue.write(s);
        } else if (s >= 64 && s <= 126) {
            this.state = 0;
            this.queue.reset();
        } else {
            this.malformedInput(ERR_CTRLBYTE);
        }
    }

    private void versionSequence(short s) throws MalformedInputException {
        if (this.state == 2) {
            if (s >= 32 && s <= 47) {
                this.state = 3;
                this.queue.write(s);
            } else {
                this.escapeSequenceOther(s);
            }
        } else {
            switch (s) {
                case 48: {
                    if (!this.versionSequenceAllowed) {
                        this.malformedInput(ERR_VERSTART);
                    }
                    this.versionSequenceAllowed = false;
                    this.state = 0;
                    this.queue.reset();
                    break;
                }
                case 49: {
                    this.malformedInput(this.versionSequenceAllowed ? ERR_VERMANDATORY : ERR_VERSTART);
                }
                default: {
                    this.escapeSequenceOther(s);
                }
            }
        }
    }

    private void charset94N(short s) throws MalformedInputException {
        switch (s) {
            case 40: {
                this.state = 6;
                break;
            }
            case 41: {
                this.state = 8;
                break;
            }
            default: {
                this.escapeSequenceOther(s);
                return;
            }
        }
        this.queue.write(s);
    }

    private void charset94NL(short s, char[] cArray, int n) throws ConversionBufferFullException, MalformedInputException, UnknownCharacterException {
        if (s >= 33 && s <= (this.state == 6 ? (short)35 : 47)) {
            this.state = 7;
            this.queue.write(s);
        } else if (s >= 64 && s <= 126) {
            this.switchConverter(s, cArray, n);
        } else {
            this.escapeSequenceOther(s);
        }
    }

    private void charset94NR(short s, char[] cArray, int n) throws ConversionBufferFullException, MalformedInputException, UnknownCharacterException {
        if (s >= 33 && s <= (this.state == 8 ? (short)35 : 47)) {
            this.state = 9;
            this.queue.write(s);
        } else if (s >= 64 && s <= 126) {
            this.switchConverter(s, cArray, n);
        } else {
            this.escapeSequenceOther(s);
        }
    }

    private void charset9496L(short s, char[] cArray, int n) throws ConversionBufferFullException, MalformedInputException, UnknownCharacterException {
        if (s >= 33 && s <= (this.state == 15 ? (short)35 : 47)) {
            this.state = 16;
            this.queue.write(s);
        } else if (s >= 64 && s <= 126) {
            this.switchConverter(s, cArray, n);
        } else {
            this.escapeSequenceOther(s);
        }
    }

    private void charset9496R(short s, char[] cArray, int n) throws ConversionBufferFullException, MalformedInputException, UnknownCharacterException {
        if (s >= 33 && s <= (this.state == 17 ? (short)35 : 47)) {
            this.state = 18;
            this.queue.write(s);
        } else if (s >= 64 && s <= 126) {
            this.switchConverter(s, cArray, n);
        } else {
            this.escapeSequenceOther(s);
        }
    }

    private void charsetNonStandard(short s, char[] cArray, int n) throws ConversionBufferFullException, MalformedInputException, UnknownCharacterException {
        switch (this.state) {
            case 10: {
                if (s == 47) {
                    this.state = 11;
                    this.queue.write(s);
                    break;
                }
                this.escapeSequenceOther(s);
                break;
            }
            case 11: {
                if (s >= 48 && s <= 52) {
                    this.state = 12;
                    this.queue.write(s);
                    break;
                }
                if (s >= 53 && s <= 63) {
                    this.state = 21;
                    this.queue.write(s);
                    break;
                }
                this.escapeSequenceOther(s);
                break;
            }
            case 12: {
                this.ext_count = (s & 0x7F) * 128;
                this.state = 13;
                break;
            }
            case 13: {
                this.ext_count += s & 0x7F;
                this.state = this.ext_count > 0 ? 14 : 0;
                break;
            }
            case 14: {
                if (s == 63 || s == 42) {
                    this.queue.reset();
                    this.malformedInput(ERR_ENCODINGBYTE);
                }
                ++this.ext_offset;
                if (this.ext_offset >= this.ext_count) {
                    this.ext_count = 0;
                    this.ext_offset = 0;
                    this.state = 0;
                    this.queue.reset();
                    this.encodingQueue.reset();
                    break;
                }
                if (s == 2) {
                    this.switchConverter((short)0, cArray, n);
                    break;
                }
                this.encodingQueue.write(s);
                break;
            }
            default: {
                this.error(ERR_ILLSTATE);
            }
        }
    }

    private void extension(short s) {
        switch (this.state) {
            case 21: {
                this.ext_count = (s & 0x7F) * 128;
                this.state = 22;
                break;
            }
            case 22: {
                this.ext_count += s & 0x7F;
                this.state = this.ext_count > 0 ? 23 : 0;
                break;
            }
            case 23: {
                ++this.ext_offset;
                if (this.ext_offset < this.ext_count) break;
                this.ext_count = 0;
                this.ext_offset = 0;
                this.state = 0;
                this.queue.reset();
                break;
            }
            default: {
                this.error(ERR_ILLSTATE);
            }
        }
    }

    private void switchConverter(short s, char[] cArray, int n) throws ConversionBufferFullException, MalformedInputException, UnknownCharacterException {
        ByteToCharConverter byteToCharConverter = null;
        boolean bl = false;
        byte[] byArray = null;
        if (s != 0) {
            this.queue.write(s);
        }
        byte[] byArray2 = this.queue.toByteArray();
        this.queue.reset();
        if (this.state == 14) {
            byArray = this.encodingQueue.toByteArray();
            this.encodingQueue.reset();
            byteToCharConverter = CompoundTextSupport.getNonStandardConverter(byArray2, byArray);
        } else {
            byteToCharConverter = CompoundTextSupport.getStandardConverter(byArray2);
            bl = CompoundTextSupport.getHighBit(byArray2);
        }
        if (byteToCharConverter != null) {
            this.initConverter(byteToCharConverter);
        } else if (!this.subMode) {
            String string = "";
            if (byArray != null) {
                try {
                    string = new String(byArray, "ISO-8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.error(ERR_LATIN1);
                }
            } else if (byArray2.length > 0) {
                char[] cArray2 = new char[byArray2.length * 3 - 1];
                int n2 = 0;
                int n3 = 0;
                while (true) {
                    byte by = byArray2[n2++];
                    int n4 = by >> 4 & 0xF;
                    int n5 = by & 0xF;
                    cArray2[n3++] = n4 < 10 ? (char)(48 + n4) : (char)(65 + n4 - 10);
                    char c = cArray2[n3++] = n5 < 10 ? (char)(48 + n5) : (char)(65 + n5 - 10);
                    if (n2 >= byArray2.length) break;
                    cArray2[n3++] = 32;
                }
                string = new String(cArray2);
            }
            throw new UnknownCharacterException(ERR_ENCODING + string);
        }
        if (this.state == 6 || this.state == 7 || this.state == 15 || this.state == 16) {
            if (this.lastConverter == this.glConverter) {
                this.flushConverter(this.glConverter, cArray, n);
            }
            this.glConverter = this.lastConverter = byteToCharConverter;
            this.glHigh = bl;
            this.state = 0;
        } else if (this.state == 8 || this.state == 9 || this.state == 17 || this.state == 18) {
            if (this.lastConverter == this.grConverter) {
                this.flushConverter(this.grConverter, cArray, n);
            }
            this.grConverter = this.lastConverter = byteToCharConverter;
            this.grHigh = bl;
            this.state = 0;
        } else if (this.state == 14) {
            if (this.lastConverter != null) {
                this.flushConverter(this.lastConverter, cArray, n);
                this.lastConverter = null;
            }
            this.nonStandardConverter = byteToCharConverter;
            this.state = 1;
        } else {
            this.error(ERR_ILLSTATE);
        }
    }

    private void flushConverter(ByteToCharConverter byteToCharConverter, char[] cArray, int n) throws ConversionBufferFullException, MalformedInputException {
        try {
            this.charOff += byteToCharConverter.flush(cArray, this.charOff, n);
        }
        catch (MalformedInputException malformedInputException) {
            this.badInputLength = byteToCharConverter.getBadInputLength();
            throw malformedInputException;
        }
    }

    private void malformedInput(String string) throws MalformedInputException {
        this.badInputLength = this.queue.size() + 1;
        this.queue.reset();
        throw new MalformedInputException(string);
    }

    private void error(String string) {
        throw new InternalError(string);
    }

    public int flush(char[] cArray, int n, int n2) throws ConversionBufferFullException, MalformedInputException {
        try {
            int n3;
            int n4 = n3 = this.lastConverter != null ? this.lastConverter.flush(cArray, n, n2) : 0;
            if (this.state != 0) {
                throw new MalformedInputException(ERR_FLUSH);
            }
            this.reset();
            return n3;
        }
        catch (MalformedInputException malformedInputException) {
            this.reset();
            throw malformedInputException;
        }
    }

    public void reset() {
        this.state = 0;
        this.ext_offset = 0;
        this.ext_count = 0;
        this.badInputLength = 0;
        this.charOff = 0;
        this.byteOff = 0;
        this.versionSequenceAllowed = true;
        this.queue.reset();
        this.encodingQueue.reset();
        this.lastConverter = null;
        this.nonStandardConverter = null;
        this.glHigh = false;
        this.grHigh = true;
        try {
            this.glConverter = ByteToCharConverter.getConverter("ASCII");
            this.grConverter = ByteToCharConverter.getConverter("ISO8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.error(ERR_LATIN1);
        }
        this.initConverter(this.glConverter);
        this.initConverter(this.grConverter);
    }

    public void setSubstitutionMode(boolean bl) {
        super.setSubstitutionMode(bl);
        if (this.glConverter != null) {
            this.glConverter.setSubstitutionMode(bl);
        }
        if (this.grConverter != null) {
            this.grConverter.setSubstitutionMode(bl);
        }
        if (this.nonStandardConverter != null) {
            this.nonStandardConverter.setSubstitutionMode(bl);
        }
    }

    public void setSubstitutionChars(char[] cArray) throws IllegalArgumentException {
        super.setSubstitutionChars(cArray);
        if (this.glConverter != null) {
            this.glConverter.setSubstitutionChars(cArray);
        }
        if (this.grConverter != null) {
            this.grConverter.setSubstitutionChars(cArray);
        }
        if (this.nonStandardConverter != null) {
            this.nonStandardConverter.setSubstitutionChars(cArray);
        }
    }

    private void initConverter(ByteToCharConverter byteToCharConverter) {
        byteToCharConverter.setSubstitutionMode(this.subMode);
        byteToCharConverter.setSubstitutionChars(this.subChars);
    }
}

