/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.DNSName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.IPAddressName;

public class URIName
implements GeneralNameInterface {
    private URI uri;
    private String host;
    private DNSName hostDNS;
    private IPAddressName hostIP;

    public URIName(DerValue derValue) throws IOException {
        this(derValue.getIA5String());
    }

    public URIName(String string) throws IOException {
        try {
            this.uri = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (IOException)new IOException(uRISyntaxException.toString()).initCause(uRISyntaxException);
        }
        if (this.uri.getScheme() == null) {
            this.host = this.uri.getSchemeSpecificPart();
            try {
                if (this.host.charAt(0) == '.') {
                    this.hostDNS = new DNSName(this.host.substring(1));
                }
                this.hostDNS = new DNSName(this.host);
            }
            catch (IOException iOException) {
                throw (IOException)new IOException("URI name must include scheme").initCause(iOException);
            }
        } else {
            if (!this.uri.isAbsolute()) {
                throw new IOException("URI name must not be relative");
            }
            this.host = this.uri.getHost();
            if (this.host == null) {
                throw new IOException("URI name must include host");
            }
            if (this.host.charAt(0) == '[') {
                String string2 = this.host.substring(1, this.host.length() - 1);
                try {
                    this.hostIP = new IPAddressName(string2);
                }
                catch (IOException iOException) {
                    throw new IOException("Host portion is not a valid IPv6 address: " + iOException.getMessage());
                }
            }
            try {
                this.hostDNS = new DNSName(this.host);
            }
            catch (IOException iOException) {
                try {
                    this.hostIP = new IPAddressName(this.host);
                }
                catch (Exception exception) {
                    throw new IOException("Host portion is not a valid DNS name, IPv4 address, or IPv6 address");
                }
            }
        }
    }

    public int getType() {
        return 6;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putIA5String(this.uri.toASCIIString());
    }

    public String toString() {
        return "URIName: " + this.uri.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof URIName)) {
            return false;
        }
        URIName uRIName = (URIName)object;
        return this.uri.equals(uRIName.getURI());
    }

    public URI getURI() {
        return this.uri;
    }

    public String getName() {
        return this.uri.toString();
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public String getHost() {
        return this.host;
    }

    public Object getHostObject() {
        if (this.hostIP != null) {
            return this.hostIP;
        }
        return this.hostDNS;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n;
        if (generalNameInterface == null) {
            n = -1;
        } else if (generalNameInterface.getType() != 6) {
            n = -1;
        } else {
            String string = ((URIName)generalNameInterface).getHost();
            if (string.equalsIgnoreCase(this.host)) {
                n = 0;
            } else {
                Object object = ((URIName)generalNameInterface).getHostObject();
                if (this.hostDNS == null || !(object instanceof DNSName)) {
                    n = 3;
                } else {
                    boolean bl = this.host.charAt(0) == '.';
                    boolean bl2 = string.charAt(0) == '.';
                    DNSName dNSName = (DNSName)object;
                    n = this.hostDNS.constrains(dNSName);
                    if (!(bl || bl2 || n != 2 && n != 1)) {
                        n = 3;
                    }
                    if (bl != bl2 && n == 0) {
                        n = bl ? 2 : 1;
                    }
                }
            }
        }
        return n;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        DNSName dNSName = null;
        try {
            dNSName = new DNSName(this.host);
        }
        catch (IOException iOException) {
            throw new UnsupportedOperationException(iOException.getMessage());
        }
        return dNSName.subtreeDepth();
    }
}

