/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.interpreter.BytecodeWithKlass;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodeInstanceOf
extends BytecodeWithKlass {
    BytecodeInstanceOf(Method method, int bci) {
        super(method, bci);
    }

    public InstanceKlass getInstanceOfKlass() {
        return (InstanceKlass)this.getKlass();
    }

    public void verify() {
        Assert.that(this.isValid(), "check instanceof");
    }

    public boolean isValid() {
        return this.javaCode() == 193;
    }

    public static BytecodeInstanceOf at(Method method, int bci) {
        BytecodeInstanceOf b = new BytecodeInstanceOf(method, bci);
        b.verify();
        return b;
    }

    public static BytecodeInstanceOf atCheck(Method method, int bci) {
        BytecodeInstanceOf b = new BytecodeInstanceOf(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeInstanceOf at(BytecodeStream bcs) {
        return new BytecodeInstanceOf(bcs.method(), bcs.bci());
    }
}

