/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

class SAJDIClassLoader
extends URLClassLoader {
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.jdi.SAJDIClassLoader.DEBUG") != null;
    private ClassLoader parent;
    private boolean classPathSet;

    SAJDIClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        this.parent = parent;
    }

    SAJDIClassLoader(ClassLoader parent, String classPath) {
        this(parent);
        this.classPathSet = true;
        try {
            this.addURL(new File(classPath).toURL());
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue);
        }
    }

    public synchronized Class loadClass(String name) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            if (name.startsWith("sun.jvm.hotspot.") && !name.startsWith("sun.jvm.hotspot.debugger.")) {
                return this.findClass(name);
            }
            c = this.parent != null ? this.parent.loadClass(name) : this.findSystemClass(name);
        }
        return c;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (DEBUG) {
            System.out.println("SA/JDI loader: about to load " + name);
        }
        if (this.classPathSet) {
            return super.findClass(name);
        }
        byte[] b = null;
        try {
            byte[] tmp;
            InputStream in = this.getResourceAsStream(name.replace('.', '/') + ".class");
            b = new byte[1024];
            int total = 0;
            int len = 0;
            while ((len = in.read(b, total, b.length - total)) != -1) {
                if ((total += len) < b.length) continue;
                tmp = new byte[total * 2];
                System.arraycopy(b, 0, tmp, 0, total);
                b = tmp;
            }
            if (total != b.length) {
                tmp = new byte[total];
                System.arraycopy(b, 0, tmp, 0, total);
                b = tmp;
            }
        }
        catch (Exception exp) {
            throw (ClassNotFoundException)new ClassNotFoundException().initCause(exp);
        }
        return this.defineClass(name, b, 0, b.length);
    }
}

