/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.CarTableDesc;
import sun.jvm.hotspot.memory.OffsetTableContigSpace;
import sun.jvm.hotspot.memory.Train;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.JIntField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class CarSpace
extends OffsetTableContigSpace {
    private static CIntegerField carSizeField;
    private static CIntegerField carSizeInWordsField;
    private static AddressField nextCarField;
    private static AddressField descField;
    private static JIntField markedField;
    private static CIntegerField blocksField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("CarSpace");
        carSizeField = type.getCIntegerField("_car_size");
        carSizeInWordsField = type.getCIntegerField("_car_size_in_words");
        nextCarField = type.getAddressField("_next_car");
        descField = type.getAddressField("_desc");
        markedField = type.getJIntField("_marked");
        blocksField = type.getCIntegerField("_blocks");
    }

    public CarSpace(Address addr) {
        super(addr);
    }

    public static long carSize() {
        return carSizeField.getValue();
    }

    public static long carSizeInOops() {
        return carSizeInWordsField.getValue();
    }

    public CarSpace nextCar() {
        return (CarSpace)VMObjectFactory.newObject(CarSpace.class, nextCarField.getValue(this.addr));
    }

    public CarTableDesc desc() {
        return (CarTableDesc)VMObjectFactory.newObject(CarTableDesc.class, descField.getValue(this.addr));
    }

    public long blocks() {
        return blocksField.getValue(this.addr);
    }

    public boolean marked() {
        return markedField.getValue() != 0;
    }

    public Train train() {
        return this.desc().train();
    }

    public long carNumber() {
        return this.desc().carNumber();
    }

    public long trainNumber() {
        return this.desc().trainNumber();
    }

    public void printOn(PrintStream tty) {
        tty.print(" car (");
        tty.print(this.trainNumber());
        tty.print(", ");
        tty.print(this.carNumber());
        tty.print(")");
        super.printOn(tty);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                CarSpace.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

