/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.Array;
import sun.jvm.hotspot.oops.ConstantPoolCache;
import sun.jvm.hotspot.oops.DoubleField;
import sun.jvm.hotspot.oops.Field;
import sun.jvm.hotspot.oops.FloatField;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.LongField;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.NamedFieldIdentifier;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.runtime.ClassConstants;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.ConstantTag;

public class ConstantPool
extends Array
implements ClassConstants {
    private static final boolean DEBUG = false;
    private static OopField tags;
    private static OopField cache;
    private static OopField poolHolder;
    private static long headerSize;
    private static long elementSize;
    private static final String[] nameForTag;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("constantPoolOopDesc");
        tags = new OopField(type.getOopField("_tags"), 0L);
        cache = new OopField(type.getOopField("_cache"), 0L);
        poolHolder = new OopField(type.getOopField("_pool_holder"), 0L);
        headerSize = type.getSize();
        elementSize = db.getOopSize();
    }

    ConstantPool(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    public boolean isConstantPool() {
        return true;
    }

    public TypeArray getTags() {
        return (TypeArray)tags.getValue(this);
    }

    public ConstantPoolCache getCache() {
        return (ConstantPoolCache)cache.getValue(this);
    }

    public Klass getPoolHolder() {
        return (Klass)poolHolder.getValue(this);
    }

    private long indexOffset(long index) {
        Assert.that(index > 0L && index < this.getLength(), "invalid cp index");
        return index * elementSize + headerSize;
    }

    public ConstantTag getTagAt(long index) {
        return new ConstantTag(this.getTags().getByteAt((int)index));
    }

    public Oop getObjAt(long index) {
        return this.getHeap().newOop(this.getHandle().getOopHandleAt(this.indexOffset(index)));
    }

    public Symbol getSymbolAt(long index) {
        return (Symbol)this.getObjAt(index);
    }

    public int getIntAt(long index) {
        return this.getHandle().getJIntAt(this.indexOffset(index));
    }

    public float getFloatAt(long index) {
        return this.getHandle().getJFloatAt(this.indexOffset(index));
    }

    public long getLongAt(long index) {
        int oneHalf = this.getHandle().getJIntAt(this.indexOffset(index + 1L));
        int otherHalf = this.getHandle().getJIntAt(this.indexOffset(index));
        return VM.getVM().buildLongFromIntsPD(oneHalf, otherHalf);
    }

    public double getDoubleAt(long index) {
        return Double.longBitsToDouble(this.getLongAt(index));
    }

    public int getFieldOrMethodAt(int which) {
        int i = -1;
        ConstantPoolCache cache = this.getCache();
        i = cache == null ? which : cache.getEntryAt(0xFFFF & VM.getVM().getBytes().swapShort((short)which)).getConstantPoolIndex();
        Assert.that(this.getTagAt(i).isFieldOrMethod(), "Corrupted constant pool");
        int res = this.getIntAt(i);
        return res;
    }

    public int getNameAndTypeAt(int which) {
        Assert.that(this.getTagAt(which).isNameAndType(), "Corrupted constant pool");
        int i = this.getIntAt(which);
        return i;
    }

    public Symbol getNameRefAt(int which) {
        int refIndex = this.getNameAndTypeAt(this.getNameAndTypeRefIndexAt(which));
        int nameIndex = ConstantPool.extractLowShortFromInt(refIndex);
        return this.getSymbolAt(nameIndex);
    }

    public Symbol getSignatureRefAt(int which) {
        int refIndex = this.getNameAndTypeAt(this.getNameAndTypeRefIndexAt(which));
        int sigIndex = ConstantPool.extractHighShortFromInt(refIndex);
        return this.getSymbolAt(sigIndex);
    }

    public Klass getKlassRefAt(int which) {
        if (!this.getTagAt(which).isKlass()) {
            return null;
        }
        return (Klass)this.getObjAt(which);
    }

    public InstanceKlass getFieldOrMethodKlassRefAt(int which) {
        int refIndex = this.getFieldOrMethodAt(which);
        int klassIndex = ConstantPool.extractLowShortFromInt(refIndex);
        return (InstanceKlass)this.getKlassRefAt(klassIndex);
    }

    public Method getMethodRefAt(int which) {
        InstanceKlass klass = this.getFieldOrMethodKlassRefAt(which);
        if (klass == null) {
            return null;
        }
        Symbol name = this.getNameRefAt(which);
        Symbol sig = this.getSignatureRefAt(which);
        return klass.findMethod(name, sig);
    }

    public Field getFieldRefAt(int which) {
        InstanceKlass klass = this.getFieldOrMethodKlassRefAt(which);
        if (klass == null) {
            return null;
        }
        Symbol name = this.getNameRefAt(which);
        Symbol sig = this.getSignatureRefAt(which);
        return klass.findField(name, sig);
    }

    public int getNameAndTypeRefIndexAt(int index) {
        int refIndex = this.getFieldOrMethodAt(index);
        int i = ConstantPool.extractHighShortFromInt(refIndex);
        return i;
    }

    public int getNameRefIndexAt(int index) {
        int refIndex = this.getNameAndTypeAt(index);
        int i = ConstantPool.extractLowShortFromInt(refIndex);
        return i;
    }

    public int getSignatureRefIndexAt(int index) {
        int refIndex = this.getNameAndTypeAt(index);
        int i = ConstantPool.extractHighShortFromInt(refIndex);
        return i;
    }

    private String nameForTag(int tag) {
        switch (tag) {
            case 1: {
                return "JVM_CONSTANT_Utf8";
            }
            case 2: {
                return "JVM_CONSTANT_Unicode";
            }
            case 3: {
                return "JVM_CONSTANT_Integer";
            }
            case 4: {
                return "JVM_CONSTANT_Float";
            }
            case 5: {
                return "JVM_CONSTANT_Long";
            }
            case 6: {
                return "JVM_CONSTANT_Double";
            }
            case 7: {
                return "JVM_CONSTANT_Class";
            }
            case 8: {
                return "JVM_CONSTANT_String";
            }
            case 9: {
                return "JVM_CONSTANT_Fieldref";
            }
            case 10: {
                return "JVM_CONSTANT_Methodref";
            }
            case 11: {
                return "JVM_CONSTANT_InterfaceMethodref";
            }
            case 12: {
                return "JVM_CONSTANT_NameAndType";
            }
            case 0: {
                return "JVM_CONSTANT_Invalid";
            }
            case 100: {
                return "JVM_CONSTANT_UnresolvedClass";
            }
            case 101: {
                return "JVM_CONSTANT_ClassIndex";
            }
            case 102: {
                return "JVM_CONSTANT_UnresolvedString";
            }
            case 103: {
                return "JVM_CONSTANT_StringIndex";
            }
        }
        throw new InternalError("unknown tag");
    }

    public void iterateFields(OopVisitor visitor, boolean doVMFields) {
        super.iterateFields(visitor, doVMFields);
        if (doVMFields) {
            visitor.doOop(tags, true);
            visitor.doOop(cache, true);
            visitor.doOop(poolHolder, true);
            int length = (int)this.getLength();
            block8: for (int index = 1; index < length; ++index) {
                byte ctag = this.getTags().getByteAt(index);
                switch (ctag) {
                    case 3: 
                    case 101: 
                    case 103: {
                        visitor.doInt(new IntField(new NamedFieldIdentifier(this.nameForTag(ctag)), this.indexOffset(index), true), true);
                        continue block8;
                    }
                    case 4: {
                        visitor.doFloat(new FloatField(new NamedFieldIdentifier(this.nameForTag(ctag)), this.indexOffset(index), true), true);
                        continue block8;
                    }
                    case 5: {
                        visitor.doLong(new LongField(new NamedFieldIdentifier(this.nameForTag(ctag)), this.indexOffset(index), true), true);
                        ++index;
                        continue block8;
                    }
                    case 6: {
                        visitor.doDouble(new DoubleField(new NamedFieldIdentifier(this.nameForTag(ctag)), this.indexOffset(index), true), true);
                        ++index;
                        continue block8;
                    }
                    case 1: 
                    case 7: 
                    case 100: 
                    case 102: {
                        visitor.doOop(new OopField(new NamedFieldIdentifier(this.nameForTag(ctag)), this.indexOffset(index), true), true);
                        continue block8;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        visitor.doInt(new IntField(new NamedFieldIdentifier(this.nameForTag(ctag)), this.indexOffset(index), true), true);
                    }
                }
            }
        }
    }

    public void printValueOn(PrintStream tty) {
        tty.print("ConstantPool for " + this.getPoolHolder().getName().asString());
    }

    public long getObjectSize() {
        return ConstantPool.alignObjectSize(headerSize + this.getLength() * elementSize);
    }

    private static int extractHighShortFromInt(int val) {
        return val >> 16 & 0xFFFF;
    }

    private static int extractLowShortFromInt(int val) {
        return val & 0xFFFF;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                ConstantPool.initialize(VM.getVM().getTypeDataBase());
            }
        });
        nameForTag = new String[0];
    }
}

