/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.CStringUtilities;

public class Arguments {
    private static AddressField jvmFlagsField;
    private static AddressField jvmArgsField;
    private static AddressField javaCommandField;

    public static String getJVMFlags() {
        return Arguments.getString(jvmFlagsField);
    }

    public static String getJVMArgs() {
        return Arguments.getString(jvmArgsField);
    }

    public static String getJavaCommand() {
        return Arguments.getString(javaCommandField);
    }

    private static synchronized void initialize(TypeDataBase db) {
        Type argumentsType = db.lookupType("Arguments");
        jvmFlagsField = argumentsType.getAddressField("_jvm_flags");
        jvmArgsField = argumentsType.getAddressField("_jvm_args");
        javaCommandField = argumentsType.getAddressField("_java_command");
    }

    private static String getString(AddressField field) {
        Address addr = field.getAddress();
        return CStringUtilities.getString(addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                Arguments.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

