/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.compiler.OopMapSet;
import sun.jvm.hotspot.compiler.OopMapVisitor;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.interpreter.BytecodeInvoke;
import sun.jvm.hotspot.interpreter.OopMapCacheEntry;
import sun.jvm.hotspot.interpreter.SharedInfo;
import sun.jvm.hotspot.oops.ConstMethod;
import sun.jvm.hotspot.oops.ConstantPoolCache;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.AddressVisitor;
import sun.jvm.hotspot.runtime.ArgumentOopFinder;
import sun.jvm.hotspot.runtime.BasicObjectLock;
import sun.jvm.hotspot.runtime.InterpreterFrameClosure;
import sun.jvm.hotspot.runtime.JavaCallWrapper;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMReg;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;

public abstract class Frame
implements Cloneable {
    protected Address raw_sp;
    protected Address pc;
    private static long constMethodOopDescSize;

    private static synchronized void initialize(TypeDataBase db) {
        Type constMethodOopType = db.lookupType("constMethodOopDesc");
        constMethodOopDescSize = constMethodOopType.getSize();
    }

    protected int bcpToBci(Address bcp, ConstMethod cm) {
        if (bcp == null) {
            return 0;
        }
        long bci = bcp.minus(null);
        if (bci >= 0L && bci < cm.getCodeSize()) {
            return (int)bci;
        }
        return (int)(bcp.minus(cm.getHandle()) - constMethodOopDescSize);
    }

    protected int bcpToBci(Address bcp, Method m) {
        return this.bcpToBci(bcp, m.getConstMethod());
    }

    public abstract Object clone();

    public Address getPC() {
        return this.pc;
    }

    public void setPC(Address newpc) {
        this.pc = newpc;
    }

    public abstract Address getSP();

    public abstract Address getID();

    public abstract Address getFP();

    public abstract boolean equals(Object var1);

    public boolean isInterpretedFrame() {
        return VM.getVM().getInterpreter().contains(this.getPC());
    }

    public boolean isJavaFrame() {
        if (this.isInterpretedFrame()) {
            return true;
        }
        return !VM.getVM().isCore() && this.isCompiledFrame();
    }

    public boolean isEntryFrame() {
        return VM.getVM().getStubRoutines().returnsToCallStub(this.getPC());
    }

    public boolean isNativeFrame() {
        if (!VM.getVM().isCore()) {
            CodeBlob cb = VM.getVM().getCodeCache().findBlob(this.getPC());
            return cb != null && cb.isNativeMethod();
        }
        return false;
    }

    public boolean isCompiledFrame() {
        Assert.that(!VM.getVM().isCore(), "noncore builds only");
        CodeBlob cb = VM.getVM().getCodeCache().findBlob(this.getPC());
        return cb != null && cb.isJavaMethod();
    }

    public boolean isOSRAdapterFrame() {
        Assert.that(!VM.getVM().isCore(), "noncore builds only");
        CodeBlob cb = VM.getVM().getCodeCache().findBlob(this.getPC());
        return cb != null && cb.isOSRAdapter();
    }

    public boolean isGlueFrame() {
        Assert.that(!VM.getVM().isCore(), "noncore builds only");
        CodeBlob cb = VM.getVM().getCodeCache().findBlob(this.getPC());
        if (cb == null) {
            return false;
        }
        if (cb.isI2CAdapter()) {
            return true;
        }
        if (cb.isC2IAdapter()) {
            return true;
        }
        return cb.isRuntimeStub();
    }

    public boolean isFirstFrame() {
        return this.isEntryFrame() && this.entryFrameIsFirst() || !this.isJavaFrame() && !this.hasSenderPD();
    }

    public boolean isFirstJavaFrame() {
        throw new RuntimeException("not yet implemented");
    }

    public abstract boolean isSignalHandlerFrameDbg();

    public abstract int getSignalNumberDbg();

    public abstract String getSignalNameDbg();

    public abstract boolean isInterpretedFrameValid();

    public boolean shouldBeDeoptimized() {
        throw new RuntimeException("not yet implemented");
    }

    public boolean canBeDeoptimized() {
        throw new RuntimeException("not yet implemented");
    }

    public abstract Frame sender(RegisterMap var1, CodeBlob var2);

    public Frame sender(RegisterMap map) {
        return this.sender(map, null);
    }

    public Frame realSender(RegisterMap map) {
        if (!VM.getVM().isCore()) {
            Frame result = this.sender(map);
            while (result.isGlueFrame()) {
                result = result.sender(map);
            }
            return result;
        }
        return this.sender(map);
    }

    protected abstract boolean hasSenderPD();

    public Address addressOfStackSlot(int slot) {
        return this.getFP().addOffsetTo((long)slot * VM.getVM().getAddressSize());
    }

    public OopHandle getOopHandleAt(int slot) {
        return this.addressOfStackSlot(slot).getOopHandleAt(0L);
    }

    public int getIntAt(int slot) {
        return this.addressOfStackSlot(slot).getJIntAt(0L);
    }

    public abstract long frameSize();

    public abstract Address getLink();

    public abstract Address getSenderPC();

    public abstract Address getUnextendedSP();

    public abstract Address getSenderSP();

    public abstract Address addressOfInterpreterFrameLocals();

    public Address addressOfInterpreterFrameLocal(int slot) {
        return this.addressOfInterpreterFrameLocals().getAddressAt(0L).addOffsetTo((long)(-slot) * VM.getVM().getAddressSize());
    }

    public abstract int getInterpreterFrameBCI();

    public abstract Address addressOfInterpreterFrameExpressionStack();

    public abstract int getInterpreterFrameExpressionStackDirection();

    public Address addressOfInterpreterFrameExpressionStackSlot(int slot) {
        return this.addressOfInterpreterFrameExpressionStack().addOffsetTo((long)(-slot) * VM.getVM().getAddressSize());
    }

    public abstract Address addressOfInterpreterFrameTOS();

    public abstract Address addressOfInterpreterFrameTOSAt(int var1);

    public int getInterpreterFrameExpressionStackSize() {
        return (int)(1L + (long)this.getInterpreterFrameExpressionStackDirection() * this.addressOfInterpreterFrameTOS().minus(this.addressOfInterpreterFrameExpressionStack()));
    }

    public abstract Address getInterpreterFrameSenderSP();

    public abstract BasicObjectLock interpreterFrameMonitorBegin();

    public abstract BasicObjectLock interpreterFrameMonitorEnd();

    public abstract int interpreterFrameMonitorSize();

    public BasicObjectLock nextMonitorInInterpreterFrame(BasicObjectLock cur) {
        return new BasicObjectLock(cur.address().addOffsetTo(this.interpreterFrameMonitorSize()));
    }

    public BasicObjectLock previousMonitorInInterpreterFrame(BasicObjectLock cur) {
        return new BasicObjectLock(cur.address().addOffsetTo(-1 * this.interpreterFrameMonitorSize()));
    }

    public abstract Address addressOfInterpreterFrameMethod();

    public Method getInterpreterFrameMethod() {
        return (Method)VM.getVM().getObjectHeap().newOop(this.addressOfInterpreterFrameMethod().getOopHandleAt(0L));
    }

    public abstract Address addressOfInterpreterFrameCPCache();

    public ConstantPoolCache getInterpreterFrameCPCache() {
        return (ConstantPoolCache)VM.getVM().getObjectHeap().newOop(this.addressOfInterpreterFrameCPCache().getOopHandleAt(0L));
    }

    public abstract JavaCallWrapper getEntryFrameCallWrapper();

    public boolean entryFrameIsFirst() {
        return this.getEntryFrameCallWrapper().getLastJavaSP() == null;
    }

    protected abstract Address addressOfSavedOopResult();

    protected abstract Address addressOfSavedReceiver();

    public OopHandle getSavedOopResult() {
        return this.addressOfSavedOopResult().getOopHandleAt(0L);
    }

    public OopHandle getSavedReceiver() {
        return this.addressOfSavedReceiver().getOopHandleAt(0L);
    }

    public void oopsInterpretedArgumentsDo(Symbol signature, boolean isStatic, AddressVisitor f) {
        ArgumentOopFinder finder = new ArgumentOopFinder(signature, isStatic, this, f);
        finder.oopsDo();
    }

    public Address oopMapRegToLocation(VMReg reg, RegisterMap regMap) {
        VM.getVM().getSharedInfo();
        VMReg stack0 = SharedInfo.getStack0();
        if (reg.lessThan(stack0)) {
            return regMap.getLocation(reg);
        }
        long spOffset = VM.getVM().getAddressSize() * (long)reg.minus(stack0) + this.getOopMapOffsetAdjustmentPD();
        return this.getSP().addOffsetTo(spOffset);
    }

    protected abstract long getOopMapOffsetAdjustmentPD();

    public void oopsDo(AddressVisitor oopVisitor, RegisterMap map) {
        if (this.isInterpretedFrame()) {
            this.oopsInterpretedDo(oopVisitor, map);
        } else if (this.isEntryFrame()) {
            this.oopsEntryDo(oopVisitor, map);
        } else if (VM.getVM().getCodeCache().contains(this.getPC())) {
            this.oopsCodeBlobDo(oopVisitor, map);
        } else {
            Assert.that(false, "should not reach here");
        }
    }

    public void printValue() {
        this.printValueOn(System.out);
    }

    public void printValueOn(PrintStream tty) {
    }

    public void print() {
        this.printOn(System.out);
    }

    public void printOn(PrintStream tty) {
    }

    public void interpreterFramePrintOn(PrintStream tty) {
    }

    private void oopsInterpretedDo(AddressVisitor oopVisitor, RegisterMap map) {
        BytecodeInvoke call;
        Assert.that(map != null, "map must be set");
        Method m = this.getInterpreterFrameMethod();
        int bci = this.getInterpreterFrameBCI();
        if (VM.getVM().isDebugging() && (bci < 0 || (long)bci >= m.getCodeSize())) {
            return;
        }
        Assert.that(m.isNative() && bci == 0 || bci >= 0 && (long)bci < m.getCodeSize(), "invalid bci value");
        oopVisitor.visitAddress(this.addressOfInterpreterFrameMethod());
        oopVisitor.visitAddress(this.addressOfInterpreterFrameCPCache());
        int maxLocals = (int)(m.isNative() ? m.getSizeOfParameters() : m.getMaxLocals());
        InterpreterFrameClosure blk = new InterpreterFrameClosure(this, maxLocals, (int)m.getMaxStack(), oopVisitor);
        OopMapCacheEntry mask = m.getMaskFor(bci);
        mask.iterateOop(blk);
        if (map.getIncludeArgumentOops() && !m.isNative() && (call = BytecodeInvoke.atCheck(m, bci)) != null && this.getInterpreterFrameExpressionStackSize() > 0) {
            this.oopsInterpretedArgumentsDo(call.signature(), call.isInvokestatic(), oopVisitor);
        }
    }

    private void oopsEntryDo(AddressVisitor oopVisitor, RegisterMap regMap) {
    }

    private void oopsCodeBlobDo(AddressVisitor oopVisitor, RegisterMap regMap) {
        CodeBlob cb = VM.getVM().getCodeCache().findBlob(this.getPC());
        Assert.that(cb != null, "sanity check");
        if (cb.getOopMaps() != null) {
            OopMapSet.oopsDo(this, cb, regMap, oopVisitor, VM.getVM().isDebugging());
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                Frame.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }

    private static class InterpVisitor
    implements OopMapVisitor {
        private AddressVisitor addressVisitor;

        public InterpVisitor(AddressVisitor oopVisitor) {
            this.setAddressVisitor(oopVisitor);
        }

        public void setAddressVisitor(AddressVisitor addressVisitor) {
            this.addressVisitor = addressVisitor;
        }

        public void visitOopLocation(Address oopAddr) {
            this.addressVisitor.visitAddress(oopAddr);
        }

        public void visitDerivedOopLocation(Address baseOopAddr, Address derivedOopAddr) {
            if (VM.getVM().isClientCompiler()) {
                Assert.that(false, "should not reach here");
            } else if (VM.getVM().isServerCompiler() && VM.getVM().useDerivedPointerTable()) {
                Assert.that(false, "FIXME: add derived pointer table");
            }
        }

        public void visitValueLocation(Address valueAddr) {
        }

        public void visitDeadLocation(Address deadAddr) {
        }
    }
}

