/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.soap.server;

import com.sun.xml.internal.ws.encoding.soap.SOAP12Constants;
import com.sun.xml.internal.ws.encoding.soap.internal.HeaderBlock;
import com.sun.xml.internal.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.internal.ws.encoding.soap.internal.SOAP12NotUnderstoodHeaderBlock;
import com.sun.xml.internal.ws.encoding.soap.server.SOAPXMLDecoder;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.util.MessageInfoUtil;
import com.sun.xml.internal.ws.util.SOAPUtil;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPFault;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAP12XMLDecoder
extends SOAPXMLDecoder {
    private static final Set<String> requiredRoles = new HashSet<String>();

    public SOAP12XMLDecoder() {
        requiredRoles.add("http://www.w3.org/2003/05/soap-envelope/role/next");
        requiredRoles.add("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver");
    }

    @Override
    protected void decodeHeader(XMLStreamReader xMLStreamReader, MessageInfo messageInfo, InternalMessage internalMessage) {
        super.decodeHeader(xMLStreamReader, messageInfo, internalMessage);
    }

    @Override
    protected QName getBodyTag() {
        return SOAP12Constants.QNAME_SOAP_BODY;
    }

    @Override
    protected QName getEnvelopeTag() {
        return SOAP12Constants.QNAME_SOAP_ENVELOPE;
    }

    @Override
    protected QName getHeaderTag() {
        return SOAP12Constants.QNAME_SOAP_HEADER;
    }

    @Override
    protected QName getMUAttrQName() {
        return SOAP12Constants.QNAME_MUSTUNDERSTAND;
    }

    @Override
    protected QName getRoleAttrQName() {
        return SOAP12Constants.QNAME_ROLE;
    }

    @Override
    public Set<String> getRequiredRoles() {
        return requiredRoles;
    }

    @Override
    protected void checkHeadersAgainstKnown(XMLStreamReader xMLStreamReader, Set<String> set, Set<QName> set2, MessageInfo messageInfo) {
        Object object;
        Object object2;
        HashSet<Object> hashSet = new HashSet<Object>();
        while (xMLStreamReader.getEventType() == 1) {
            Object object3;
            object2 = xMLStreamReader.getName();
            object = xMLStreamReader.getAttributeValue(this.getMUAttrQName().getNamespaceURI(), this.getMUAttrQName().getLocalPart());
            if (object != null && (((String)object).equals("1") || ((String)object).equalsIgnoreCase("true")) && (object3 = xMLStreamReader.getAttributeValue(this.getRoleAttrQName().getNamespaceURI(), this.getRoleAttrQName().getLocalPart())) != null && set.contains(object3)) {
                logger.finest("Element=" + object2 + " targeted at=" + (String)object3);
                if (set2 == null || !set2.contains(object2)) {
                    logger.finest("Element not understood=" + object2);
                    hashSet.add(object2);
                }
            }
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        }
        if (hashSet.isEmpty()) {
            return;
        }
        object2 = SOAPUtil.createSOAPFault("SOAP must understand error", SOAP12Constants.FAULT_CODE_MUST_UNDERSTAND, null, null, "http://www.w3.org/2003/05/soap/bindings/HTTP/");
        object = new HashSet();
        for (QName qName : hashSet) {
            object.add(new SOAP12NotUnderstoodHeaderBlock(qName));
        }
        MessageInfoUtil.setNotUnderstoodHeaders(messageInfo, (Set<HeaderBlock>)object);
        throw new SOAPFaultException((SOAPFault)object2);
    }

    @Override
    public String getBindingId() {
        return "http://www.w3.org/2003/05/soap/bindings/HTTP/";
    }

    @Override
    protected QName getSenderFaultCode() {
        return SOAP12Constants.FAULT_CODE_CLIENT;
    }

    @Override
    protected QName getReceiverFaultCode() {
        return SOAP12Constants.FAULT_CODE_SERVER;
    }

    @Override
    protected QName getVersionMismatchFaultCode() {
        return SOAP12Constants.FAULT_CODE_VERSION_MISMATCH;
    }
}

