/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.xml;

import com.sun.xml.internal.messaging.saaj.packaging.mime.MessagingException;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.InternetHeaders;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeBodyPart;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeMultipart;
import com.sun.xml.internal.messaging.saaj.soap.AttachmentPartImpl;
import com.sun.xml.internal.messaging.saaj.util.ByteInputStream;
import com.sun.xml.internal.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.internal.ws.encoding.jaxb.JAXBTypeSerializer;
import com.sun.xml.internal.ws.protocol.xml.XMLMessageException;
import com.sun.xml.internal.ws.streaming.XMLStreamWriterFactory;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.util.FastInfosetReflection;
import com.sun.xml.internal.ws.util.FastInfosetUtil;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.soap.MimeHeaders;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.http.HTTPException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLMessage {
    private static final Logger log = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.protocol.xml");
    private static final int PLAIN_XML_FLAG = 1;
    private static final int MIME_MULTIPART_FLAG = 2;
    private static final int FI_ENCODED_FLAG = 16;
    private final DataRepresentation data;
    protected boolean useFastInfoset = false;

    public XMLMessage(MimeHeaders mimeHeaders, InputStream inputStream) {
        String string = null;
        if (mimeHeaders != null) {
            string = XMLMessage.getContentType(mimeHeaders);
        }
        this.data = this.getData(string, inputStream);
    }

    private InputStream hasSomeData(InputStream inputStream) throws IOException {
        if (inputStream != null && inputStream.available() < 1) {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            inputStream.mark(1);
            if (inputStream.read() != -1) {
                inputStream.reset();
            } else {
                inputStream = null;
            }
        }
        return inputStream;
    }

    private DataRepresentation getData(String string, InputStream inputStream) {
        DataRepresentation dataRepresentation;
        try {
            inputStream = this.hasSomeData(inputStream);
            if (inputStream == null) {
                return new NullContent();
            }
            if (string != null) {
                boolean bl;
                ContentType contentType = new ContentType(string);
                int n = XMLMessage.identifyContentType(contentType);
                boolean bl2 = bl = (n & 0x10) > 0;
                dataRepresentation = (n & 2) != 0 ? new XMLMultiPart(string, inputStream, bl) : ((n & 1) != 0 || (n & 0x10) != 0 ? new XMLSource(inputStream, bl) : new UnknownContent(string, inputStream));
            } else {
                dataRepresentation = new NullContent();
            }
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
        return dataRepresentation;
    }

    public XMLMessage(Source source, boolean bl) {
        this.data = source == null ? new NullContent() : new XMLSource(source);
        this.useFastInfoset = bl;
        this.data.getMimeHeaders().addHeader("Content-Type", bl ? "application/fastinfoset" : "text/xml");
    }

    public XMLMessage(Exception exception, boolean bl) {
        this.data = new XMLErr(exception);
        this.useFastInfoset = bl;
        this.data.getMimeHeaders().addHeader("Content-Type", bl ? "application/fastinfoset" : "text/xml");
    }

    public XMLMessage(DataSource dataSource, boolean bl) {
        this.useFastInfoset = bl;
        try {
            this.data = dataSource == null ? new NullContent() : this.getData(dataSource.getContentType(), dataSource.getInputStream());
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
        String string = dataSource != null ? dataSource.getContentType() : null;
        string = string == null ? (string = "text/xml") : string;
        this.data.getMimeHeaders().addHeader("Content-Type", !bl ? string : string.replaceFirst("text/xml", "application/fastinfoset"));
    }

    public XMLMessage(Object object, JAXBContext jAXBContext, boolean bl) {
        this.data = object == null ? new NullContent() : new XMLJaxb(object, jAXBContext);
        this.useFastInfoset = bl;
        this.data.getMimeHeaders().addHeader("Content-Type", bl ? "application/fastinfoset" : "text/xml");
    }

    public XMLMessage(Source source, Map<String, DataHandler> map, boolean bl) {
        this.data = map == null ? (source == null ? new NullContent() : new XMLSource(source)) : (source == null ? new UnknownContent(map) : new XMLMultiPart(source, map, bl));
        this.useFastInfoset = bl;
        this.data.getMimeHeaders().addHeader("Content-Type", bl ? "application/fastinfoset" : "text/xml");
    }

    public XMLMessage(Object object, JAXBContext jAXBContext, Map<String, DataHandler> map, boolean bl) {
        this.data = map == null ? (object == null ? new NullContent() : new XMLJaxb(object, jAXBContext)) : (object == null ? new UnknownContent(map) : new XMLMultiPart(JAXBTypeSerializer.serialize(object, jAXBContext), map, bl));
        this.useFastInfoset = bl;
        this.data.getMimeHeaders().addHeader("Content-Type", bl ? "application/fastinfoset" : "text/xml");
    }

    public boolean isFastInfoset() {
        return this.data.isFastInfoset();
    }

    public boolean useFastInfoset() {
        return this.useFastInfoset;
    }

    public boolean acceptFastInfoset() {
        return FastInfosetUtil.isFastInfosetAccepted(this.getMimeHeaders().getHeader("Accept"));
    }

    public Source getSource() {
        return this.data.getSource();
    }

    public DataSource getDataSource() {
        return this.data.getDataSource();
    }

    private static int identifyContentType(ContentType contentType) {
        String string = contentType.getPrimaryType();
        String string2 = contentType.getSubType();
        if (string.equalsIgnoreCase("multipart") && string2.equalsIgnoreCase("related")) {
            String string3 = contentType.getParameter("type");
            if (string3 != null) {
                if (XMLMessage.isXMLType(string3)) {
                    return 3;
                }
                if (XMLMessage.isFastInfosetType(string3)) {
                    return 18;
                }
            }
            return 0;
        }
        if (XMLMessage.isXMLType(string, string2)) {
            return 1;
        }
        if (XMLMessage.isFastInfosetType(string, string2)) {
            return 16;
        }
        return 0;
    }

    protected static boolean isXMLType(String string, String string2) {
        return (string.equalsIgnoreCase("text") || string.equalsIgnoreCase("application")) && string2.equalsIgnoreCase("xml");
    }

    protected static boolean isXMLType(String string) {
        return string.toLowerCase().startsWith("text/xml") || string.toLowerCase().startsWith("application/xml");
    }

    protected static boolean isFastInfosetType(String string, String string2) {
        return string.equalsIgnoreCase("application") && string2.equalsIgnoreCase("fastinfoset");
    }

    protected static boolean isFastInfosetType(String string) {
        return string.toLowerCase().startsWith("application/fastinfoset");
    }

    public MimeHeaders getMimeHeaders() {
        return this.data.getMimeHeaders();
    }

    private static String getContentType(MimeHeaders mimeHeaders) {
        String[] stringArray = mimeHeaders.getHeader("Content-Type");
        return stringArray == null ? null : stringArray[0];
    }

    public int getStatus() {
        return this.data.getStatus();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.data.writeTo(outputStream, this.useFastInfoset);
    }

    public Source getPayload() {
        return this.data.getPayload();
    }

    public Map<String, DataHandler> getAttachments() {
        return this.data.getAttachments();
    }

    public Object getPayload(JAXBContext jAXBContext) {
        return JAXBTypeSerializer.deserialize(this.getPayload(), jAXBContext);
    }

    static {
        new AttachmentPartImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class DataRepresentation {
        private DataRepresentation() {
        }

        abstract Source getPayload();

        abstract void writeTo(OutputStream var1, boolean var2) throws IOException;

        abstract boolean isFastInfoset();

        abstract Source getSource();

        abstract DataSource getDataSource();

        abstract Map<String, DataHandler> getAttachments();

        abstract MimeHeaders getMimeHeaders();

        int getStatus() {
            return 200;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NullContent
    extends DataRepresentation {
        private final MimeHeaders headers = new MimeHeaders();

        private NullContent() {
        }

        @Override
        public Source getPayload() {
            return null;
        }

        @Override
        public Map<String, DataHandler> getAttachments() {
            return null;
        }

        @Override
        public void writeTo(OutputStream outputStream, boolean bl) throws IOException {
        }

        @Override
        boolean isFastInfoset() {
            return false;
        }

        @Override
        Source getSource() {
            return null;
        }

        @Override
        DataSource getDataSource() {
            return null;
        }

        @Override
        MimeHeaders getMimeHeaders() {
            return this.headers;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnknownContent
    extends DataRepresentation {
        private final String ct;
        private final InputStream in;
        private final MimeMultipart multipart;
        private final MimeHeaders headers = new MimeHeaders();

        public UnknownContent(String string, InputStream inputStream) {
            this.ct = string;
            this.in = inputStream;
            this.multipart = null;
        }

        public UnknownContent(Map<String, DataHandler> map) {
            this.in = null;
            this.multipart = new MimeMultipart("mixed");
            for (Map.Entry<String, DataHandler> entry : map.entrySet()) {
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setDataHandler(entry.getValue());
                this.multipart.addBodyPart(mimeBodyPart);
            }
            this.ct = this.multipart.getContentType().toString();
        }

        @Override
        public void writeTo(OutputStream outputStream, boolean bl) {
            try {
                int n;
                if (this.multipart != null) {
                    this.multipart.writeTo(outputStream);
                }
                byte[] byArray = new byte[1024];
                while ((n = this.in.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
            }
            catch (Exception exception) {
                throw new WebServiceException(exception);
            }
        }

        @Override
        boolean isFastInfoset() {
            return false;
        }

        @Override
        public Source getSource() {
            return null;
        }

        @Override
        DataSource getDataSource() {
            return new DataSource(){

                public InputStream getInputStream() {
                    if (UnknownContent.this.multipart != null) {
                        try {
                            ByteOutputStream byteOutputStream = new ByteOutputStream();
                            UnknownContent.this.multipart.writeTo(byteOutputStream);
                            return byteOutputStream.newInputStream();
                        }
                        catch (Exception exception) {
                            throw new WebServiceException(exception);
                        }
                    }
                    return UnknownContent.this.in;
                }

                public OutputStream getOutputStream() {
                    return null;
                }

                public String getContentType() {
                    assert (UnknownContent.this.ct != null);
                    return UnknownContent.this.ct;
                }

                public String getName() {
                    return "";
                }
            };
        }

        @Override
        public Source getPayload() {
            return null;
        }

        @Override
        public Map<String, DataHandler> getAttachments() {
            return null;
        }

        @Override
        MimeHeaders getMimeHeaders() {
            this.headers.removeHeader("Content-Type");
            this.headers.addHeader("Content-Type", this.ct);
            return this.headers;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class XMLErr
    extends DataRepresentation {
        private final Exception err;
        private final MimeHeaders headers = new MimeHeaders();

        XMLErr(Exception exception) {
            this.err = exception;
        }

        @Override
        public Source getPayload() {
            return null;
        }

        @Override
        public Map<String, DataHandler> getAttachments() {
            return null;
        }

        @Override
        public void writeTo(OutputStream outputStream, boolean bl) throws IOException {
            String string = this.err.getMessage();
            if (string == null) {
                string = this.err.toString();
            }
            string = "<err>" + string + "</err>";
            if (bl) {
                FastInfosetUtil.transcodeXMLStringToFI(string, outputStream);
            } else {
                outputStream.write(string.getBytes());
            }
        }

        @Override
        boolean isFastInfoset() {
            return false;
        }

        @Override
        Source getSource() {
            return null;
        }

        @Override
        DataSource getDataSource() {
            return null;
        }

        @Override
        int getStatus() {
            if (this.err instanceof HTTPException) {
                return ((HTTPException)this.err).getStatusCode();
            }
            return 500;
        }

        @Override
        MimeHeaders getMimeHeaders() {
            return this.headers;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XMLJaxb
    extends DataRepresentation {
        private final Object object;
        private final JAXBContext jaxbContext;
        private final MimeHeaders headers = new MimeHeaders();

        public XMLJaxb(Object object, JAXBContext jAXBContext) {
            this.object = object;
            this.jaxbContext = jAXBContext;
        }

        @Override
        public void writeTo(OutputStream outputStream, boolean bl) {
            if (bl) {
                JAXBTypeSerializer.serializeDocument(this.object, XMLStreamWriterFactory.createFIStreamWriter(outputStream), this.jaxbContext);
            } else {
                JAXBTypeSerializer.serialize(this.object, outputStream, this.jaxbContext);
            }
        }

        @Override
        boolean isFastInfoset() {
            return false;
        }

        @Override
        public Source getSource() {
            return JAXBTypeSerializer.serialize(this.object, this.jaxbContext);
        }

        @Override
        DataSource getDataSource() {
            return new DataSource(){

                public InputStream getInputStream() {
                    ByteOutputStream byteOutputStream = new ByteOutputStream();
                    JAXBTypeSerializer.serialize(XMLJaxb.this.object, byteOutputStream, XMLJaxb.this.jaxbContext);
                    return byteOutputStream.newInputStream();
                }

                public OutputStream getOutputStream() {
                    return null;
                }

                public String getContentType() {
                    return XMLJaxb.this.isFastInfoset() ? "application/fastinfoset" : "text/xml";
                }

                public String getName() {
                    return "";
                }
            };
        }

        @Override
        public Source getPayload() {
            return this.getSource();
        }

        @Override
        public Map<String, DataHandler> getAttachments() {
            return null;
        }

        @Override
        MimeHeaders getMimeHeaders() {
            return this.headers;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class XMLMultiPart
    extends DataRepresentation {
        private DataSource dataSource;
        private MimeMultipart multipart;
        private XMLSource xmlSource;
        private boolean isFastInfoset;
        private final MimeHeaders headers = new MimeHeaders();

        public XMLMultiPart(final String string, final InputStream inputStream, boolean bl) {
            this.isFastInfoset = bl;
            this.dataSource = new DataSource(){

                public InputStream getInputStream() {
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    return null;
                }

                public String getContentType() {
                    return string;
                }

                public String getName() {
                    return "";
                }
            };
        }

        public XMLMultiPart(Source source, Map<String, DataHandler> map, boolean bl) {
            this.isFastInfoset = bl;
            this.multipart = new MimeMultipart("related");
            this.multipart.getContentType().setParameter("type", "text/xml");
            ByteOutputStream byteOutputStream = new ByteOutputStream();
            new XMLSource(source).writeTo(byteOutputStream, bl);
            InternetHeaders internetHeaders = new InternetHeaders();
            internetHeaders.addHeader("Content-Type", bl ? "application/fastinfoset" : "text/xml");
            MimeBodyPart mimeBodyPart = new MimeBodyPart(internetHeaders, byteOutputStream.getBytes(), byteOutputStream.getCount());
            this.multipart.addBodyPart(mimeBodyPart, 0);
            for (Map.Entry<String, DataHandler> entry : map.entrySet()) {
                MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
                mimeBodyPart2.setDataHandler(entry.getValue());
                this.multipart.addBodyPart(mimeBodyPart2);
            }
        }

        public XMLMultiPart(DataSource dataSource, boolean bl) {
            this.dataSource = dataSource;
            this.isFastInfoset = bl;
        }

        @Override
        public boolean isFastInfoset() {
            return this.isFastInfoset;
        }

        @Override
        public DataSource getDataSource() {
            if (this.dataSource != null) {
                return this.dataSource;
            }
            if (this.multipart != null) {
                return new DataSource(){

                    public InputStream getInputStream() {
                        try {
                            if (XMLMultiPart.this.xmlSource != null) {
                                XMLMultiPart.this.replaceRootPart(false);
                            }
                            ByteOutputStream byteOutputStream = new ByteOutputStream();
                            XMLMultiPart.this.multipart.writeTo(byteOutputStream);
                            return byteOutputStream.newInputStream();
                        }
                        catch (MessagingException messagingException) {
                            throw new XMLMessageException("xml.get.ds.err", new Object[]{messagingException});
                        }
                        catch (IOException iOException) {
                            throw new XMLMessageException("xml.get.ds.err", new Object[]{iOException});
                        }
                    }

                    public OutputStream getOutputStream() {
                        return null;
                    }

                    public String getContentType() {
                        return XMLMultiPart.this.multipart.getContentType().toString();
                    }

                    public String getName() {
                        return "";
                    }
                };
            }
            return null;
        }

        private MimeBodyPart getRootPart() {
            try {
                this.convertToMultipart();
                ContentType contentType = this.multipart.getContentType();
                String string = contentType.getParameter("start");
                MimeBodyPart mimeBodyPart = string == null ? this.multipart.getBodyPart(0) : this.multipart.getBodyPart(string);
                return mimeBodyPart;
            }
            catch (MessagingException messagingException) {
                throw new XMLMessageException("xml.get.source.err", new Object[]{messagingException});
            }
        }

        private void replaceRootPart(boolean bl) {
            if (this.xmlSource == null) {
                return;
            }
            try {
                MimeBodyPart mimeBodyPart = this.getRootPart();
                String string = mimeBodyPart.getContentType();
                this.multipart.removeBodyPart(mimeBodyPart);
                ByteOutputStream byteOutputStream = new ByteOutputStream();
                this.xmlSource.writeTo(byteOutputStream, bl);
                InternetHeaders internetHeaders = new InternetHeaders();
                internetHeaders.addHeader("Content-Type", bl ? "application/fastinfoset" : string);
                mimeBodyPart = new MimeBodyPart(internetHeaders, byteOutputStream.getBytes(), byteOutputStream.getCount());
                this.multipart.addBodyPart(mimeBodyPart, 0);
            }
            catch (MessagingException messagingException) {
                throw new XMLMessageException("xml.get.source.err", new Object[]{messagingException});
            }
        }

        private void convertToMultipart() {
            if (this.dataSource != null) {
                try {
                    this.multipart = new MimeMultipart(this.dataSource, null);
                    this.dataSource = null;
                }
                catch (MessagingException messagingException) {
                    throw new XMLMessageException("xml.get.source.err", new Object[]{messagingException});
                }
            }
        }

        @Override
        public Source getSource() {
            try {
                if (this.xmlSource != null) {
                    return this.xmlSource.getPayload();
                }
                this.convertToMultipart();
                MimeBodyPart mimeBodyPart = this.getRootPart();
                ContentType contentType = new ContentType(mimeBodyPart.getContentType());
                String string = contentType.getBaseType();
                if (XMLMessage.isXMLType(string)) {
                    return new StreamSource(mimeBodyPart.getInputStream());
                }
                if (XMLMessage.isFastInfosetType(string)) {
                    return FastInfosetReflection.FastInfosetSource_new(mimeBodyPart.getInputStream());
                }
                throw new XMLMessageException("xml.root.part.invalid.Content-Type", string);
            }
            catch (MessagingException messagingException) {
                throw new XMLMessageException("xml.get.source.err", new Object[]{messagingException});
            }
            catch (Exception exception) {
                throw new XMLMessageException("xml.get.source.err", new Object[]{exception});
            }
        }

        @Override
        public Source getPayload() {
            return this.getSource();
        }

        @Override
        public void writeTo(OutputStream outputStream, boolean bl) {
            try {
                if (this.xmlSource != null) {
                    this.convertToMultipart();
                }
                if (this.dataSource != null) {
                    if (this.isFastInfoset == bl) {
                        int n;
                        InputStream inputStream = this.dataSource.getInputStream();
                        byte[] byArray = new byte[1024];
                        while ((n = inputStream.read(byArray)) != -1) {
                            outputStream.write(byArray, 0, n);
                        }
                        return;
                    }
                    this.xmlSource = new XMLSource(this.getSource());
                }
                this.replaceRootPart(bl);
                this.multipart.writeTo(outputStream);
            }
            catch (Exception exception) {
                throw new WebServiceException(exception);
            }
        }

        @Override
        public Map<String, DataHandler> getAttachments() {
            if (this.xmlSource != null) {
                this.convertToMultipart();
            }
            try {
                MimeBodyPart mimeBodyPart = this.getRootPart();
                HashMap<String, DataHandler> hashMap = new HashMap<String, DataHandler>();
                int n = this.multipart.getCount();
                for (int i = 0; i < n; ++i) {
                    MimeBodyPart mimeBodyPart2 = this.multipart.getBodyPart(i);
                    if (mimeBodyPart2 == mimeBodyPart) continue;
                    hashMap.put(mimeBodyPart2.getContentID(), mimeBodyPart2.getDataHandler());
                }
                return hashMap;
            }
            catch (MessagingException messagingException) {
                throw new XMLMessageException("xml.get.source.err", new Object[]{messagingException});
            }
        }

        @Override
        MimeHeaders getMimeHeaders() {
            this.headers.removeHeader("Content-Type");
            if (this.dataSource != null) {
                this.headers.addHeader("Content-Type", this.dataSource.getContentType());
            } else if (this.multipart != null) {
                this.headers.addHeader("Content-Type", this.multipart.getContentType().toString());
            }
            return this.headers;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XMLSource
    extends DataRepresentation {
        private Source source;
        private boolean isFastInfoset;
        private final MimeHeaders headers = new MimeHeaders();

        public XMLSource(InputStream inputStream, boolean bl) throws Exception {
            this.source = bl ? FastInfosetReflection.FastInfosetSource_new(inputStream) : new StreamSource(inputStream);
            this.isFastInfoset = bl;
        }

        public XMLSource(Source source) {
            this.source = source;
            this.isFastInfoset = source != null ? source.getClass() == FastInfosetReflection.fiFastInfosetSource : false;
        }

        @Override
        public boolean isFastInfoset() {
            return this.isFastInfoset;
        }

        @Override
        public void writeTo(OutputStream outputStream, boolean bl) {
            try {
                InputStream inputStream = null;
                boolean bl2 = false;
                if (this.source instanceof StreamSource) {
                    inputStream = ((StreamSource)this.source).getInputStream();
                    bl2 = !bl;
                } else if (this.source.getClass() == FastInfosetReflection.fiFastInfosetSource) {
                    inputStream = FastInfosetReflection.FastInfosetSource_getInputStream(this.source);
                    bl2 = bl;
                }
                if (bl2 && inputStream != null && inputStream instanceof ByteInputStream) {
                    ByteInputStream byteInputStream = (ByteInputStream)inputStream;
                    byte[] byArray = byteInputStream.getBytes();
                    outputStream.write(byArray);
                    byteInputStream.close();
                    return;
                }
                Transformer transformer = XmlUtil.newTransformer();
                transformer.transform(this.source, bl ? FastInfosetReflection.FastInfosetResult_new(outputStream) : new StreamResult(outputStream));
            }
            catch (Exception exception) {
                throw new WebServiceException(exception);
            }
        }

        @Override
        public Source getSource() {
            return this.source;
        }

        @Override
        DataSource getDataSource() {
            return new DataSource(){

                public InputStream getInputStream() {
                    try {
                        InputStream inputStream = null;
                        if (XMLSource.this.source instanceof StreamSource) {
                            inputStream = ((StreamSource)XMLSource.this.source).getInputStream();
                        } else if (XMLSource.this.source.getClass() == FastInfosetReflection.fiFastInfosetSource) {
                            inputStream = FastInfosetReflection.FastInfosetSource_getInputStream(XMLSource.this.source);
                        }
                        if (inputStream != null) {
                            return inputStream;
                        }
                        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
                        Transformer transformer = XmlUtil.newTransformer();
                        transformer.transform(XMLSource.this.source, XMLSource.this.isFastInfoset() ? FastInfosetReflection.FastInfosetResult_new(byteArrayBuffer) : new StreamResult(byteArrayBuffer));
                        byteArrayBuffer.close();
                        return byteArrayBuffer.newInputStream();
                    }
                    catch (Exception exception) {
                        throw new WebServiceException(exception);
                    }
                }

                public OutputStream getOutputStream() {
                    return null;
                }

                public String getContentType() {
                    return XMLSource.this.isFastInfoset() ? "application/fastinfoset" : "text/xml";
                }

                public String getName() {
                    return "";
                }
            };
        }

        @Override
        public Source getPayload() {
            try {
                if (this.source instanceof DOMSource) {
                    return this.source;
                }
                InputStream inputStream = null;
                if (this.source instanceof StreamSource) {
                    inputStream = ((StreamSource)this.source).getInputStream();
                } else if (this.source.getClass() == FastInfosetReflection.fiFastInfosetSource) {
                    inputStream = FastInfosetReflection.FastInfosetSource_getInputStream(this.source);
                }
                if (inputStream != null && inputStream instanceof ByteInputStream) {
                    ByteInputStream byteInputStream = (ByteInputStream)inputStream;
                    byte[] byArray = byteInputStream.getBytes();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    byteInputStream.close();
                    return this.isFastInfoset ? FastInfosetReflection.FastInfosetSource_new(inputStream) : new StreamSource(byteArrayInputStream);
                }
                ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
                Transformer transformer = XmlUtil.newTransformer();
                Properties properties = new Properties();
                properties.put("omit-xml-declaration", "yes");
                transformer.setOutputProperties(properties);
                transformer.transform(this.source, this.isFastInfoset ? FastInfosetReflection.FastInfosetResult_new(byteArrayBuffer) : new StreamResult(byteArrayBuffer));
                byteArrayBuffer.close();
                InputStream inputStream2 = byteArrayBuffer.size() == 0 ? null : byteArrayBuffer.newInputStream();
                this.source = this.isFastInfoset ? FastInfosetReflection.FastInfosetSource_new(inputStream2) : new StreamSource(inputStream2);
                inputStream2 = byteArrayBuffer.newInputStream();
                return this.isFastInfoset ? FastInfosetReflection.FastInfosetSource_new(inputStream2) : new StreamSource(inputStream2);
            }
            catch (Exception exception) {
                throw new WebServiceException(exception);
            }
        }

        @Override
        public Map<String, DataHandler> getAttachments() {
            return null;
        }

        @Override
        MimeHeaders getMimeHeaders() {
            return this.headers;
        }
    }
}

