/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.collections;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayMap<K, V>
implements Map<K, V> {
    private K[] keys;
    private V[] values;
    private int size;
    private int modCount;

    public ArrayMap() {
        this(0);
    }

    public ArrayMap(int initialCapacity) {
        this.keys = new Object[initialCapacity];
        this.values = new Object[initialCapacity];
        this.size = 0;
        this.modCount = 0;
    }

    public ArrayMap(Map<? extends K, ? extends V> map) {
        this.size = map.size();
        this.keys = new Object[this.size];
        this.values = new Object[this.size];
        Iterator<Map.Entry<K, V>> entries = map.entrySet().iterator();
        for (int i = 0; i < this.size; ++i) {
            Map.Entry<K, V> entry = entries.next();
            this.keys[i] = entry.getKey();
            this.values[i] = entry.getValue();
        }
        this.modCount = 0;
    }

    @Override
    public void clear() {
        this.keys = new Object[0];
        this.values = new Object[0];
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indexOf(key, this.keys, this.size) != -1;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.indexOf(value, this.values, this.size) != -1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return ArrayMap.this.size;
            }

            @Override
            public boolean contains(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    int pos = ArrayMap.this.indexOf(entry.getKey(), ArrayMap.this.keys, ArrayMap.this.size);
                    return pos != -1 && ArrayMap.this.values[pos] == entry.getValue();
                }
                return false;
            }

            @Override
            public boolean remove(Object object) {
                Map.Entry entry;
                int pos;
                if (object instanceof Map.Entry && (pos = ArrayMap.this.indexOf((entry = (Map.Entry)object).getKey(), ArrayMap.this.keys, ArrayMap.this.size)) != -1 && ArrayMap.this.values[pos] == entry.getValue()) {
                    this.remove(pos);
                    return true;
                }
                return false;
            }

            @Override
            public void clear() {
                ArrayMap.this.clear();
            }
        };
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Map) {
            Map otherMap = (Map)object;
            return ((Object)this.entrySet()).equals(otherMap.entrySet());
        }
        return false;
    }

    @Override
    public V get(Object key) {
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] != key) continue;
            return this.values[i];
        }
        return null;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.size; ++i) {
            K key = this.keys[i];
            V value = this.values[i];
            int keyCode = key == null ? 0 : key.hashCode();
            int valueCode = value == null ? 0 : value.hashCode();
            hashCode = (int)((double)hashCode + Math.pow(keyCode, valueCode));
        }
        return hashCode;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new KeyIterator();
            }

            @Override
            public int size() {
                return ArrayMap.this.size;
            }

            @Override
            public boolean contains(Object object) {
                return ArrayMap.this.containsKey(object);
            }

            @Override
            public boolean remove(Object object) {
                int oldSize = ArrayMap.this.size;
                ArrayMap.this.remove(object);
                return ArrayMap.this.size != oldSize;
            }

            @Override
            public void clear() {
                ArrayMap.this.clear();
            }
        };
    }

    @Override
    public V put(K key, V value) {
        V result = null;
        int index = this.indexOf(key, this.keys, this.size);
        if (index == -1) {
            if (this.keys.length == this.size) {
                this.keys = this.toLargerArray(this.keys);
                this.values = this.toLargerArray(this.values);
            }
            this.keys[this.size] = key;
            this.values[this.size] = value;
            ++this.size;
        } else {
            result = this.values[index];
            this.values[index] = value;
        }
        ++this.modCount;
        return result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        int index = this.indexOf(key, this.keys, this.size);
        if (index == -1) {
            return null;
        }
        V oldValue = this.values[index];
        this.remove(index);
        return oldValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new ValueIterator();
            }

            @Override
            public int size() {
                return ArrayMap.this.size;
            }

            @Override
            public boolean contains(Object object) {
                for (int i = 0; i < ArrayMap.this.size; ++i) {
                    if (ArrayMap.this.values[i] != object) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean remove(Object object) {
                int index = ArrayMap.this.indexOf(object, ArrayMap.this.values, ArrayMap.this.size);
                if (index == -1) {
                    return false;
                }
                this.remove(index);
                return true;
            }

            @Override
            public void clear() {
                ArrayMap.this.clear();
            }
        };
    }

    public K getKey(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("invalid index");
        }
        return this.keys[index];
    }

    public V getValue(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("invalid index");
        }
        return this.values[index];
    }

    private <T> T[] toLargerArray(T[] array) {
        int oldSize = array.length;
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), oldSize + 1);
        System.arraycopy(array, 0, result, 0, oldSize);
        return result;
    }

    private int indexOf(Object object, Object[] array, int length) {
        for (int i = 0; i < length; ++i) {
            if (array[i] != object) continue;
            return i;
        }
        return -1;
    }

    private void remove(int index) {
        int nextIndex = index + 1;
        int remainingLength = this.size - nextIndex;
        System.arraycopy(this.keys, nextIndex, this.keys, index, remainingLength);
        System.arraycopy(this.values, nextIndex, this.values, index, remainingLength);
        --this.size;
        this.keys[this.size] = null;
        this.values[this.size] = null;
        ++this.modCount;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            if (key == this) {
                buffer.append("(this Map)");
            } else {
                buffer.append(key);
            }
            buffer.append('=');
            V value = e.getValue();
            if (value == this) {
                buffer.append("(this Map)");
            } else {
                buffer.append(value);
            }
            if (!(hasNext = i.hasNext())) continue;
            buffer.append(", ");
        }
        buffer.append('}');
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends ArrayIterator<V> {
        public ValueIterator() {
            super(ArrayMap.this.values, ArrayMap.this.size);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends ArrayIterator<K> {
        public KeyIterator() {
            super(ArrayMap.this.keys, ArrayMap.this.size);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArrayIterator<T>
    implements Iterator<T> {
        private T[] array;
        private int length;
        private int index;
        private int expectedModCount;

        public ArrayIterator(T[] array, int length) {
            this.array = array;
            this.length = length;
            this.index = 0;
            this.expectedModCount = ArrayMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.length;
        }

        @Override
        public T next() {
            if (this.index >= this.length) {
                throw new NoSuchElementException();
            }
            if (ArrayMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            T result = this.array[this.index];
            ++this.index;
            return result;
        }

        @Override
        public void remove() {
            if (this.index == 0) {
                throw new IllegalStateException();
            }
            if (ArrayMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            ArrayMap.this.remove(this.index - 1);
            --this.length;
            ++this.expectedModCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private int index = 0;
        private int expectedModCount;

        public EntryIterator() {
            this.expectedModCount = ArrayMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.index < ArrayMap.this.size;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.index >= ArrayMap.this.size) {
                throw new NoSuchElementException();
            }
            if (ArrayMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry result = new Entry(this.index);
            ++this.index;
            return result;
        }

        @Override
        public void remove() {
            if (this.index == 0) {
                throw new IllegalStateException();
            }
            if (ArrayMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            ArrayMap.this.remove(this.index - 1);
            ++this.expectedModCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Entry
    implements Map.Entry<K, V> {
        private int index;

        public Entry(int index) {
            this.index = index;
        }

        @Override
        public K getKey() {
            return ArrayMap.this.keys[this.index];
        }

        @Override
        public V getValue() {
            return ArrayMap.this.values[this.index];
        }

        @Override
        public V setValue(V object) {
            Object oldValue = ArrayMap.this.values[this.index];
            ((ArrayMap)ArrayMap.this).values[this.index] = object;
            return oldValue;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                boolean keyOK;
                Map.Entry entry = (Map.Entry)object;
                boolean bl = ArrayMap.this.keys[this.index] == null ? entry.getKey() == null : (keyOK = ArrayMap.this.keys[this.index] == entry.getKey());
                boolean valueOK = ArrayMap.this.values[this.index] == null ? entry.getValue() == null : ArrayMap.this.values[this.index] == entry.getValue();
                return keyOK && valueOK;
            }
            return false;
        }

        @Override
        public int hashCode() {
            Object key = ArrayMap.this.keys[this.index];
            Object value = ArrayMap.this.values[this.index];
            int keyCode = key == null ? 0 : key.hashCode();
            int valueCode = value == null ? 0 : value.hashCode();
            return (int)Math.pow(keyCode, valueCode);
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(50);
            buffer.append('[');
            buffer.append(ArrayMap.this.keys[this.index].toString());
            buffer.append(',');
            buffer.append(ArrayMap.this.values[this.index].toString());
            buffer.append(']');
            return buffer.toString();
        }
    }
}

