/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CPGPDiskApplication.cp,v 1.39.8.1 1999/07/09 00:02:36 heller Exp $
____________________________________________________________________________*/

#include <Sound.h>
#include <string.h>

#include <LDialogBox.h>
#include <LEditText.h>
#include <LGrowZone.h>
#include <LMenu.h>
#include <LMenuBar.h>
#include <UAppleEventsMgr.h>
#include <UDesktop.h>
#include <UDrawingState.h>
#include <UDrawingUtils.h>
#include <UEnvironment.h>
#include <UMemoryMgr.h>
#include <URegistrar.h>

#include "MacDialogs.h"
#include "MacDebugPatches.h"
#include "MacEnvirons.h"
#include "MacEvents.h"
#include "MacErrors.h"
#include "MacFiles.h"
#include "MacInternet.h"
#include "MacDriverUtils.h"
#include "pgpMacMemory.h"
#include "MacResources.h"
#include "MacSecureMemory.h"
#include "MacStrings.h"
#include "MacTraps.h"

#include "pflPrefTypes.h"
#include "pgpAdminPrefs.h"
#include "pgpClientPrefs.h"
#include "pgpKeys.h"
#include "pgpSDKPrefs.h"
#include "pgpUserInterface.h"
#include "pgpUtilities.h"
#include "PGPOpenPrefs.h"
#include "Beta.h"

#include "PGPDisk.h"
#include "PGPDiskPreferences.h"
#include "PGPDiskResources.h"
#include "PGPDiskUtils.h"

#include <LGADialog.h>
#include <LIconPane.h>
#include <LScroller.h>
#include <LTabGroup.h>
#include <UModalDialogs.h>
#include <UWindows.h>

#include <LBevelButton.h>
#include <LCheckBox.h>
#include <LCmdBevelButton.h>
#include <LEditText.h>
#include <LIconControl.h>
#include <LPopupButton.h>
#include <LProgressBar.h>
#include <LPushButton.h>
#include <LRadioButton.h>
#include <LRadioGroupView.h>
#include <LSeparatorLine.h>
#include <LStaticText.h>
#include <LTextGroupBox.h>

#include <LAMControlImp.h>
#include <LAMControlViewImp.h>
#include <LAMEditTextImp.h>
#include <LAMPopupButtonImp.h>
#include <LAMPushButtonImp.h>
#include <LAMStaticTextImp.h>

#include "CNewDiskWizardDialog.h"
#include "CSetPassphraseDialog.h"
#include "CDiskTestsTable.h"
#include "CDiskTestsWindow.h"
#include "CEditDiskTestDialog.h"
#include "CGetPassphraseDialog.h"
#include "CMainWindow.h"
#include "CPassphraseEdit.h"
#include "CPGPAMEditTextImp.h"
#include "CPGPActiveScroller.h"
#include "CPGPStDialogHandler.h"
#include "CPGPDiskDialog.h"
#include "CPGPDiskWindow.h"
#include "CPGPDiskApplication.h"
#include "CPicture.h"
#include "CPreferencesDialog.h"
#include "CVersionCaption.h"
#include "CWarningAlert.h"
#include "PowerPlantLeaks.h"
#include "CLog.h"
#include "SleepAlert.h"
#include "PGPDiskFile.h"
#include "pgpCLientLib.h"

const short		kMainWindowResID			= 3000;
const short		kNewDiskWizardResID			= 8000;
const short		kAboutDialogResID			= 9000;

const short		kMinSystemVersionAlertResID			= 2100;
const short		kCastSBoxesInvalidAlertResID		= 2103;
const short		kFoundLaterDriverAlertResID			= 2104;
const short		kDiskExpressIncompatibleAlertResID	= 2105;
const short		kBetaExpiredAlertResID				= 2106;
const short		kRAMDoublerIncompatibleAlertResID	= 2107;

const CommandT	cmd_NewPGPDisk			= 2000;
const CommandT	cmd_MountPGPDisk		= 2001;

const CommandT	cmd_AddPassphrase		= 2100;
const CommandT	cmd_ChangePassphrase	= 2101;
const CommandT	cmd_RemovePassphrase	= 2102;

const CommandT	cmd_AddRemovePublicKeys	= 2200;

static CMainWindow		*sMainWindowObj;

#if PGP_DEBUG // [
const short		kDiskTestsWindowResID		= 21000;
const short		kDebugMenuResID				= 20000;

const CommandT	cmd_DebugDiskTestsWindow	= 20001;
const CommandT	cmd_DebugMountUnmountTest	= 20002;

const CommandT	cmd_DebugUnmountAllPGPDisks	= 20101;
const CommandT	cmd_DebugFragmentFile		= 20102;

const CommandT	cmd_DebugTemp1	= 20201;
const CommandT	cmd_DebugTemp2	= 20202;
const CommandT	cmd_DebugTemp3	= 20203;

static CDiskTestsWindow		*sDiskTestsWindowObj;

#endif // ]

static Boolean	sHaveOAPPEvent = FALSE;
static Boolean	sHaveODOCEvent = FALSE;
static Boolean	sRemoveAlternatePassphrases	= FALSE;

CPGPDiskApplication	*CPGPDiskApplication::mApplication = NULL;

class CAboutCaption : public LCaption
{
public:
	enum { class_ID = 'cApt' };
						CAboutCaption( LStream * inStream)
							: LCaption( inStream )
							{ }

protected:
	virtual void		DrawSelf( void );
};



	static void
RealMain( void  )
{
	LGrowZone	*myGrowZoneObj;
	
	MacLeaks_Suspend();	
	
	myGrowZoneObj = new LGrowZone(20000);
	CPGPDiskApplication theApp;
	
	MacLeaks_Resume();
	
	theApp.Run();
	
	// PP LGrowZone assumes zone is set correctly when deleting the object.
	SetZone( ApplicationZone() );
	
	if( myGrowZoneObj != nil )
		delete( myGrowZoneObj );
}


	static Boolean
FindItemInFolder(
	short		vRefNum,
	long		dirID,
	OSType		fileCreator,
	OSType		fileType,
	FSSpec *	outSpec)
{
	Boolean		foundIt;
	CInfoPBRec	cpb;
	Str255		itemName;
	UInt32		dirIndex;
	
	foundIt 	= false;
	dirIndex	= 1;
	
	pgpClearMemory( &cpb, sizeof( cpb ) );
	
	cpb.hFileInfo.ioVRefNum	= vRefNum;
	cpb.hFileInfo.ioNamePtr	= itemName;
	
	while( ! foundIt )
	{
		cpb.hFileInfo.ioDirID	 	= dirID;
		cpb.hFileInfo.ioFDirIndex 	= dirIndex;
	
		if( IsErr( PBGetCatInfoSync( &cpb ) ) )
			break;
		
		// allow wildcarding with '****'
		if( cpbIsFile( &cpb ) &&
			( cpbFileType( &cpb ) == fileType ||
					cpbFileType( &cpb ) == '****' ) &&
			( cpbFileCreator( &cpb ) == fileCreator ||
					cpbFileCreator( &cpb ) == '****' ) )
		{
			foundIt = TRUE;
			if ( IsntNull( outSpec ) )
			{
				outSpec->vRefNum	= vRefNum;
				outSpec->parID		= dirID;
				CopyPString( itemName, outSpec->name );
			}
		}
		
		++dirIndex;
	}

	return( foundIt );
}


	static Boolean
FindDiskExpressInFolder(short vRefNum, long dirID)
{
	return( FindItemInFolder( vRefNum, dirID, 'DExp', 'cdev', nil ) );
}


	static Boolean
DiskExpressIsRunning()
{
	// PGPdisk is not currently compatible with DiskExpressII because it may
	// move our mounted disks files and the driver does not check for this
	// case. Alsoft is sending more info to dynamically detect this case. 
	// For now, we do not run.
	short	vRefNum;
	long	dirID;
	Boolean	foundDiskExpress;

	foundDiskExpress = FALSE;
	
	if( IsntErr( FindFolder( kOnSystemDisk, kControlPanelFolderType,
					kDontCreateFolder, &vRefNum, &dirID ) ) )
	{
		foundDiskExpress = FindDiskExpressInFolder( vRefNum, dirID );
	}
	
	if( ! foundDiskExpress )
	{
		if( IsntErr( FindFolder( kOnSystemDisk, kExtensionFolderType,
						kDontCreateFolder, &vRefNum, &dirID ) ) )
		{
			foundDiskExpress = FindDiskExpressInFolder( vRefNum, dirID );
		}
	}

	if( ! foundDiskExpress )
	{
		if( IsntErr( FindFolder( kOnSystemDisk, kSystemFolderType,
						kDontCreateFolder, &vRefNum, &dirID ) ) )
		{
			foundDiskExpress = FindDiskExpressInFolder( vRefNum, dirID );
		}
	}
	return( foundDiskExpress );
}


	static Boolean
IncompatibleRAMDoublerIsRunning()
{
	short	vRefNum;
	long	dirID;
	Boolean	foundProblem	= false;

	if ( VirtualMemoryIsOn() )
	{
		if( IsntErr( FindFolder( kOnSystemDisk, kControlPanelFolderType,
						kDontCreateFolder, &vRefNum, &dirID ) ) )
		{
			const OSType	kRAMDoubler2Creator	= 'RaM2';	// type 'cdev'
			FSSpec			spec;
			
			foundProblem = FindItemInFolder( vRefNum, dirID,
									kRAMDoubler2Creator, 'cdev', &spec );
			if ( foundProblem )
			{
				ushort	version;
				OSErr	err;
				
				// check the version number
				err	= FSpGetFileVersion( &spec, &version );
				foundProblem	= IsntErr( err ) && version < 0x0201;
			}
		}
		else if ( IsntErr( FindFolder( kOnSystemDisk, kExtensionFolderType,
						kDontCreateFolder, &vRefNum, &dirID ) ) )
		{
			const OSType	kRAMDoubler1Creator	= 'RaM2';	// type 'INIT'
			
			foundProblem = FindItemInFolder( vRefNum, dirID,
									kRAMDoubler1Creator, 'INIT', nil );
		}
	}
	
	return( foundProblem );
}

	static Boolean
VerifyEnvironment(void)
{
	if ( ! VerifyCastSBoxesValid() )
	{
		StopAlert( kCastSBoxesInvalidAlertResID, nil);
		return( false );
	}
	
	// Check to make sure that 	there are not later version of the driver
	// active. If so, refuse to run. It is assumed that the user has access
	// to the later version of the active application.
	
	{
		const ushort	kMaxDrivers	= 200;
		short			driverRefNums[ kMaxDrivers ];
		ushort			numDrivers;
		Boolean			foundLaterDriver = FALSE;
			
		GetAllPGPDiskDrivers( driverRefNums, kMaxDrivers, &numDrivers );
		
		for( ushort driverIndex = 0; driverIndex < numDrivers; ++driverIndex )
		{
			PGPDriverInfoStruct	info;

			if ( IsntErr( GetPGPDiskDriverInfo( driverRefNums[ driverIndex ],
								&info ) ) )
			{
				if( info.versionOut > kPGPDiskDriverVersion )
				{
					foundLaterDriver = TRUE;
					break;
				}
			}
			else
			{
				foundLaterDriver = TRUE;
				break;
			}
		}
	
		if( foundLaterDriver )
		{
			StopAlert( kFoundLaterDriverAlertResID, nil);
			return( FALSE );		
		}
	}

	if( DiskExpressIsRunning() )
	{
		StopAlert( kDiskExpressIncompatibleAlertResID, nil);
		return( FALSE );		
	}

	if( IncompatibleRAMDoublerIsRunning() )
	{
		StopAlert( kRAMDoublerIncompatibleAlertResID, nil);
		return( FALSE );		
	}
	
	if( ! PGPClientVerifyEnvironment() )
	{
		return( FALSE );
	}
	
#if BETA
	if ( BetaExpired() )
	{
		NoteAlert( kBetaExpiredAlertResID, nil );
		// keep going
	}
#endif

	return( TRUE );
}

	static Handle
AllocLargeHandle(void)
{
	Handle	theHandle	= nil;
	UInt32	attemptSize = 128UL * 1024UL;
	
	while ( attemptSize >= 4 )
	{
		theHandle = NewHandle( attemptSize );
		if ( IsntNull( theHandle ) )
			break;
		
		attemptSize	/= 2;
	}
	
	return( theHandle );
}

	static void
ClearAllFreeMemory()
{
	typedef struct ListItem
	{
		struct ListItem **	next;
	} ListItem, **ListItemHandle;
	
	ListItemHandle	nextHandle;
	ListItemHandle	listHead	= nil;
	
	pgpAssert( GetZone() == ApplicationZone() );
	SetZone( ApplicationZone() );
	
	// allocate all free space and link it into a singly linked list
	while ( ( nextHandle = (ListItemHandle)AllocLargeHandle() ) != nil )
	{
		// safety check: could a Handle ever be less than the size of our
		// link?
		if ( GetHandleSize( (Handle)nextHandle ) < sizeof( **nextHandle ) )
		{
			DisposeHandle( (Handle)nextHandle );
			break;
		}
			
		(**nextHandle).next	= listHead;
		listHead			= nextHandle;
	}

	// we've now allocated all the space in the heap
	// clear all the bytes and free the space
	while ( IsntNull( listHead ) )
	{
		nextHandle	= (**listHead).next;
		
		pgpClearMemory( *listHead, GetHandleSize( (Handle)listHead ) );
		DisposeHandle( (Handle)listHead );
		
		listHead = nextHandle;
	}
}

	void
main(void)
{
	SetDebugThrow_( debugAction_LowLevelDebugger );
	SetDebugSignal_( debugAction_LowLevelDebugger );
	
	InitializeHeap(3);
	UQDGlobals::InitializeToolbox(&qd);
	UnloadScrap();
	
	DebugPatches_PatchDisposeTraps();

	if( VerifyEnvironment() )
	{
		#if USE_MAC_DEBUG_LEAKS
		{ CForceInitLPeriodical	temp; }
		#endif
		
		pgpLeaksBeginSession( "main" );
			RealMain();
		pgpLeaksEndSession( );
	}
	
	ClearAllFreeMemory();
}

CPGPDiskApplication::CPGPDiskApplication()
{
	PGPError	err;
	
	gApplicationResFile = CurResFile();
	mApplication		= this;
	mContext			= kInvalidPGPContextRef;
	
	err = PGPNewContext( kPGPsdkAPIVersion, &mContext );
	if( IsntPGPError( err ) )
	{
		err = PGPsdkLoadDefaultPrefs( mContext );
	}

	pgpAssertNoErr( err );
	
	UEnvironment::InitEnvironment();

	// Standard PowerPlant Classes
	RegisterClass_( LCaption );
	RegisterClass_( LDialogBox );
	RegisterClass_( LGADialog );
	RegisterClass_( LIconPane );
	RegisterClass_( LPane );
	RegisterClass_( LPicture );
	RegisterClass_( LTabGroup );
	RegisterClass_( LView );
	RegisterClass_( LWindow );

	// PowerPlant Grayscale Classes

	RegisterClass_( LBevelButton );
	RegisterClass_( LCheckBox );
	RegisterClass_( LCmdBevelButton );
	RegisterClass_( LEditText );
	RegisterClass_( LIconControl );
	RegisterClass_( LProgressBar );
	RegisterClass_( LPushButton );
	RegisterClass_( LRadioButton );
	RegisterClass_( LRadioGroupView );
	RegisterClass_( LSeparatorLine );
	RegisterClass_( LStaticText );
	RegisterClass_( LTextGroupBox );
	
	// Register Appearance Manager implementations

	(void) RegisterAppearanceClient();
	
	RegisterClassID_( LAMControlImp,		LBevelButton::imp_class_ID);
	RegisterClassID_( LAMControlImp, 		LCheckBox::imp_class_ID);
	RegisterClassID_( LAMControlImp, 		LIconControl::imp_class_ID);
	RegisterClassID_( LAMControlImp, 		LProgressBar::imp_class_ID);
	RegisterClassID_( LAMControlImp,		LRadioButton::imp_class_ID);
	RegisterClassID_( LAMControlImp,		LSeparatorLine::imp_class_ID );
	RegisterClassID_( LAMControlViewImp, 	LTextGroupBox::imp_class_ID);
	RegisterClassID_( CPGPAMEditTextImp,	LEditText::imp_class_ID);
	RegisterClassID_( LAMPushButtonImp,		LPushButton::imp_class_ID);
	RegisterClassID_( LAMStaticTextImp,		LStaticText::imp_class_ID);

	// Custom classes 
	RegisterClass_( CAboutCaption );
	RegisterClass_( CMainWindow );
	RegisterClass_( CPGPDiskDialog );
	RegisterClass_( CPGPDiskWindow );
	RegisterClass_( CPicture );
	RegisterClass_( CSetPassphraseDialog );
	RegisterClass_( CGetPassphraseDialog );
	RegisterClass_( CPreferencesDialog );
	RegisterClass_( CPassphraseEdit );
	RegisterClass_( CVersionCaption );
	RegisterClass_( CWarningAlert );
	RegisterClass_( CNewDiskWizardDialog );


#if PGP_DEBUG
	
	RegisterClass_( LPopupButton );

	RegisterClass_( CPGPActiveScroller );
	RegisterClass_( CDiskTestsWindow );
	RegisterClass_( CDiskTestsTable );
	RegisterClass_( CEditDiskTestDialog );
	
#endif	// PGP_DEBUG

	ReadPreferences( &gPGPDiskPrefs );
	// Write out preferences to make sure sleep alert resources get copied
	// to the preferences file.
	WritePreferences( &gPGPDiskPrefs );
}

CPGPDiskApplication::~CPGPDiskApplication()
{
	WritePreferences( &gPGPDiskPrefs );
	
	if( PGPContextRefIsValid( mContext ) )
	{
		PGPFreeContext( mContext );
		mContext = kInvalidPGPContextRef;
	}
}

	void
CPGPDiskApplication::Run()
{
	LApplication::Run();
	
	if( sMainWindowObj != nil )
	{
		Rect	contentRect;
		
		contentRect = UWindows::GetWindowContentRect(
							sMainWindowObj->GetMacPort() );
		
		gPGPDiskPrefs.mainWindowLocation.v = contentRect.top;
		gPGPDiskPrefs.mainWindowLocation.h = contentRect.left;
		
		sMainWindowObj->ProcessCommand( cmd_Close, nil );
	}
		
#if PGP_DEBUG
	if( sDiskTestsWindowObj != nil )
	{
		sDiskTestsWindowObj->ProcessCommand( cmd_Close, nil );
		
		delete( sDiskTestsWindowObj );
		sDiskTestsWindowObj = nil;
	}
#endif
}

	void
CPGPDiskApplication::Initialize()
{
	// we need to suspend leaks checking for the duration of these things
	// because PowerPlant will never release certain items

	MacLeaks_Suspend();
		LApplication::Initialize();
	MacLeaks_Resume();

	sMainWindowObj = (CMainWindow *) CMainWindow::CreateWindow(
											kMainWindowResID, this );
	pgpAssertAddrValid( sMainWindowObj, CMainWindow );

	if( sMainWindowObj != nil )
	{
		sMainWindowObj->DoSetPosition( gPGPDiskPrefs.mainWindowLocation );
	}

	StartRepeating();
	
#if PGP_DEBUG
	InstallDebugMenu();
#endif
}


	void
CAboutCaption::DrawSelf()
{
	Rect		paneRect;
	ResIDT		saveTxtrID	= mTxtrID;
	
	CalcLocalFrameRect( paneRect );

	StDeviceLoop			devLoop( paneRect );		
	SInt16					depth;
	RGBColor				saveBackColor;
	static const RGBColor	sRGBWhiteColor = {0xFFFF, 0xFFFF, 0xFFFF};

	GetBackColor( &saveBackColor );
	RGBBackColor( &sRGBWhiteColor );
	
	while( devLoop.NextDepth( depth ) )
	{
		const ResIDT	kTextTraitsForSolidBackbround	= 133;
		const ResIDT	kTextTraitsForWhiteBackbround	= 134;
		
		if( depth >= 4 )
		{
			mTxtrID = kTextTraitsForSolidBackbround;
		}
		else
		{
			mTxtrID = kTextTraitsForWhiteBackbround;
		}

		LCaption::DrawSelf();
	}

	RGBBackColor( &saveBackColor );
	
	mTxtrID	= saveTxtrID;
}


	static void
MakeLicenseStr(StringPtr persStr)
{
	PGPError		err;
	PGPMemoryMgrRef	memoryMgr;
	
	persStr[0] = 0;

	err = PGPNewMemoryMgr( 0, &memoryMgr );
	if( IsntPGPError( err ) ) 
	{
		PGPPrefRef		clientPrefsRef	= kInvalidPGPPrefRef;
		
	#if PGP_BUSINESS_SECURITY
		PGPPrefRef		adminPrefsRef	= kInvalidPGPPrefRef;	
	#endif

		err = PGPOpenClientPrefs( memoryMgr, &clientPrefsRef );

	#if PGP_BUSINESS_SECURITY
		if( IsntPGPError( err ) ) 
		{
			err = PGPOpenAdminPrefs( memoryMgr, &adminPrefsRef );
		}
	#endif

		if( IsntPGPError( err ) )
		{
			char		companyStr[128];
			char		nameStr[128];
			char		str[256];
			
			companyStr[0] = 0;
			
		#if PGP_BUSINESS_SECURITY
			err = PGPGetPrefStringBuffer( adminPrefsRef, kPGPPrefAdminCompanyName,
										sizeof( companyStr ) - 1, companyStr );
			pgpAssertNoErr( err );
		#endif
			if( companyStr[0] == 0 )
			{
				err = PGPGetPrefStringBuffer( clientPrefsRef, kPGPPrefCompanyName,
										sizeof( companyStr ) - 1, companyStr );
				pgpAssertNoErr( err );
			}
			
			err = PGPGetPrefStringBuffer( clientPrefsRef, kPGPPrefOwnerName,
										sizeof( companyStr ) - 1, nameStr );
			pgpAssertNoErr( err );
			
			strcpy( str, nameStr );
			strcat( str, "\r" );
			strcat( str, companyStr );
			CToPString( str, persStr );
		}
		
		if( PGPPrefRefIsValid( clientPrefsRef ) )
			PGPClosePrefFile( clientPrefsRef );

	#if PGP_BUSINESS_SECURITY
		if( PGPPrefRefIsValid( adminPrefsRef ) )
			PGPClosePrefFile( adminPrefsRef );
	#endif
	
		PGPFreeMemoryMgr( memoryMgr );
	}
}

	void
CPGPDiskApplication::ShowAboutBox()
{
	Boolean		didShowDialog = FALSE;
	FSSpec		libraryFileSpec;
	
	// Open the libarary resource file at the top of the resource chain so
	// we get our pictures.
	if( IsntErr( PGPGetClientLibFSSpec( &libraryFileSpec ) ) )
	{
		short	saveResFile;
		short	libFileRefNum;
		
		saveResFile = CurResFile();
		
		libFileRefNum = FSpOpenResFile( &libraryFileSpec, fsRdPerm );
		if( libFileRefNum > 0 )
		{
			UseResFile( libFileRefNum );
			
			{
				CPGPStDialogHandler	aboutDialog(kAboutDialogResID, this);
				LWindow				*theDialog;
				MessageT			message;
				Boolean				credits = FALSE;
				Str255				licenseStr;
				
				const MessageT		kPGPButtonMessage		= 'bPGP';
				const MessageT		kCreditsButtonMessage	= 'bCre';
				const MessageT		kOKButtonMessage		= 'bOK ';
				
				const PaneIDT		kCreditsButtonPaneID	= 'bCre';
				const PaneIDT		kAboutPicturePaneID		= 'APIC';
				const PaneIDT		kCreditsPicturePaneID	= 'CPIC';
				const PaneIDT		kBSAFEPicturePaneID		= 'RPIC';
				const PaneIDT		kLicenseCaptionID		= 'cLic';

				theDialog = aboutDialog.GetDialog();
				
				didShowDialog = true;
				
				MakeLicenseStr( licenseStr );
				((LCaption *)theDialog->FindPaneByID(kLicenseCaptionID))->
						SetDescriptor( licenseStr );

				while( (message = aboutDialog.DoDialog()) != kOKButtonMessage)
				{
					if(message == kPGPButtonMessage )
					{
						Str255		url;
						
						GetIndString( url, kMiscStringsListResID,
									kPGPWebSiteURLStrIndex );
						
						if( OpenURL( url, kPGPDiskFileCreator ) != noErr )
						{
							SysBeep( 1 );
						}
					}
					else if(message == kCreditsButtonPaneID)
					{
						Str255	buttonTitle;
						
						if( credits )
						{
							theDialog->FindPaneByID( kAboutPicturePaneID )->
										Show();
							theDialog->FindPaneByID( kCreditsPicturePaneID )->
										Hide();
					#if CREDIT_RSA_BSAFE
							theDialog->FindPaneByID( kBSAFEPicturePaneID )->
								Hide();
					#endif
							
							GetIndString( buttonTitle,
										kMiscStringsListResID,
										kAboutCreditsButtonTitleStrIndex );
						}
						else
						{
							theDialog->FindPaneByID( kCreditsPicturePaneID )->
										Show();
					#if CREDIT_RSA_BSAFE
							theDialog->FindPaneByID( kBSAFEPicturePaneID )->
								Show();
					#endif
							theDialog->FindPaneByID( kAboutPicturePaneID )->
										Hide();
							
							GetIndString( buttonTitle,
										kMiscStringsListResID,
										kAboutInfoButtonTitleStrIndex );
						}
						
						((LPushButton *)theDialog->FindPaneByID(
									kCreditsButtonPaneID))->SetDescriptor(
									buttonTitle );

						credits = ! credits;
					}
				}
			}
			
			CloseResFile( libFileRefNum );
			UseResFile( saveResFile );
		}
	}
	
	if( ! didShowDialog )
		SysBeep( 1 );
}

	Boolean
CPGPDiskApplication::ObeyCommand(CommandT inCommand, void *ioParam)
{
	Boolean	cmdHandled = TRUE;

	switch (inCommand)
	{
		case cmd_NewPGPDisk:
			HandleNewPGPDisk();
			break;
			
		case cmd_MountPGPDisk:
			(void) HandleMountPGPDisk( NULL );
			break;
	
		case cmd_AddPassphrase:
			HandleAddPassphrase();
			break;
			
		case cmd_ChangePassphrase:
			HandleChangePassphrase();
			break;
				
		case cmd_RemovePassphrase:
		{
			if( sRemoveAlternatePassphrases )
			{
				HandleRemoveAltPassphrases();
			}
			else
			{
				HandleRemovePassphrase();
			}
			break;
		}

		case cmd_Preferences:
			DoPreferencesDialog();
			break;

		case cmd_AddRemovePublicKeys:
			(void) HandleAddRemovePublicKeys();
			break;

#if PGP_DEBUG
		case cmd_DebugDiskTestsWindow:
		{
			if( sDiskTestsWindowObj == nil )
			{
				MacLeaks_Suspend();
				
				sDiskTestsWindowObj =
						(CDiskTestsWindow *) CDiskTestsWindow::CreateWindow(
							kDiskTestsWindowResID, this );
				pgpAssertAddrValid( sDiskTestsWindowObj, CDiskTestsWindow );

				MacLeaks_Resume();	
			}
			
			if( sDiskTestsWindowObj != nil )
			{
				sDiskTestsWindowObj->Select();

				if( ! sDiskTestsWindowObj->IsVisible() )
					sDiskTestsWindowObj->Show();
			}
				
			break;
		}
		
		case cmd_DebugMountUnmountTest:
			DebugMountUnmountTest();
			break;
			
		case cmd_DebugUnmountAllPGPDisks:
			DebugUnmountAllPGPDisks();
			break;
			
		case cmd_DebugFragmentFile:
			DebugFragmentFile();
			break;

		case cmd_DebugTemp1:
			DebugTemp1();
			break;

		case cmd_DebugTemp2:
			DebugTemp2();
			break;

		case cmd_DebugTemp3:
			DebugTemp3();
			break;
#endif

		default:
			cmdHandled = LApplication::ObeyCommand(inCommand, ioParam);
			break;
	}

	return cmdHandled;
}

	void
CPGPDiskApplication::FindCommandStatus(
	CommandT	inCommand,
	Boolean		&outEnabled,
	Boolean		&outUsesMark,
	Char16		&outMark,
	Str255		outName)
{
	outUsesMark = false;
	
	switch(inCommand)
	{
		case cmd_About:
		case cmd_Quit:
		case cmd_MountPGPDisk:
		case cmd_Preferences:
			outEnabled	= ! UDesktop::FrontWindowIsModal();
			break;

		case cmd_NewPGPDisk:
		case cmd_AddPassphrase:
		case cmd_ChangePassphrase:
		case cmd_RemovePassphrase:
		{
			outEnabled	= ! UDesktop::FrontWindowIsModal();
	#if BETA
			if ( BetaExpired() )
			{
				outEnabled	= false;
			}
	#endif
	
			if( inCommand == cmd_RemovePassphrase )
			{
				short	strIndex;
				
				if( ( GetModifiers() & optionKey ) == optionKey )
				{
					strIndex = kRemoveAltPassphrasesMenuItemStrIndex;
					sRemoveAlternatePassphrases	= TRUE;
				}
				else
				{
					strIndex = kRemovePassphraseMenuItemStrIndex;
					sRemoveAlternatePassphrases = FALSE;
				}
				
				GetIndString( outName, kMiscStringsListResID, strIndex );
			}
			break;
		}

		case cmd_AddRemovePublicKeys:
			outEnabled = TRUE;
			break;

#if PGP_DEBUG
		case cmd_DebugDiskTestsWindow:
		case cmd_DebugMountUnmountTest:
		case cmd_DebugUnmountAllPGPDisks:
		case cmd_DebugFragmentFile:
		case cmd_DebugTemp1:
		case cmd_DebugTemp2:
		case cmd_DebugTemp3:
			outEnabled = TRUE;
			break;
#endif

		default:
			LApplication::FindCommandStatus(inCommand, outEnabled,
											outUsesMark, outMark, outName);
			break;
	}
}

	static pascal Boolean
sFilterOpenFiles(CInfoPBRec * cpb)
{
	Boolean	showFile	= TRUE;
	
	showFile	= ! cpbIsOpen( cpb );
	
	return( ! showFile );
}


//	Presents a Standard File put dialog for getting an exting PGPDisk file.

	OSStatus
CPGPDiskApplication::GetExistingPGPDiskFSSpec(FSSpec *fileSpec)
{
	StandardFileReply	sfReply;
	SFTypeList			typeList;
	OSStatus			status = noErr;
	FileFilterUPP		upp;
	
	upp	= NewFileFilterProc( sFilterOpenFiles );
	
	pgpAssertAddrValid( fileSpec, FSSpec );
	
	typeList[0] = kPGPDiskFileType;
	
	StandardGetFile( upp, 1, typeList, &sfReply );
	
	DisposeRoutineDescriptor( upp );
	
	if( sfReply.sfGood )
	{
		// Canonicalize the spec.
		(void) FSMakeFSSpec( sfReply.sfFile.vRefNum, sfReply.sfFile.parID,
								sfReply.sfFile.name, fileSpec );
	}
	else
	{
		status = userCanceledErr;
	}
	
	return( status );
}

	void
CPGPDiskApplication::HandleNewPGPDisk(void)
{
	CComboError	err;
	
#if PGP_BUSINESS_SECURITY
	PGPKeySetRef			allKeys = kInvalidPGPKeySetRef;
	PGPKeyRef				adkRef = kInvalidPGPKeyRef;
	PGPBoolean				haveADK;
	PGPKeyID				keyID;
	PGPPublicKeyAlgorithm	algorithm;
		
	err.pgpErr = GetADKInfo( mContext, &haveADK, &keyID, &algorithm );
	if( err.IsntError() && haveADK )
	{
		PGPError	tempErr;
				
		tempErr = PGPOpenDefaultKeyRings( mContext, 0, &allKeys );
		if( IsntPGPError( tempErr ) )
		{
			tempErr = PGPGetKeyByKeyID( allKeys, &keyID, algorithm,
							&adkRef );
		}
		
		if( IsPGPError( tempErr ) )
			err.err = kPGPdiskADKNotFoundError;
	}
#endif
		
	if( err.IsntError() )
	{
		CNewDiskWizardDialog	*theDialog;
		
		theDialog = (CNewDiskWizardDialog *) LWindow::CreateWindow(
							kNewDiskWizardResID, this );
		if( IsntNull( theDialog ) )
		{
			theDialog->SetParams( mContext );
			
		#if PGP_BUSINESS_SECURITY
			if( haveADK )
			{
				theDialog->SetADK( allKeys, adkRef );
				
				// Dialog takes ownership of keyset
				allKeys	= kInvalidPGPKeySetRef;
			}
		#endif
		}
	}
	else
	{	
		Str255	errorStr;
		
		GetComboErrorString( err, errorStr );
		
		SysBeep( 1 );
		CWarningAlert::Display( kWAStopAlertType, kWAOKStyle,
					kErrorStringListResID,
					kCouldNotCreateDiskBecauseStrIndex,
					errorStr );
	}

#if PGP_BUSINESS_SECURITY
	if( PGPKeySetRefIsValid( allKeys ) )
		PGPFreeKeySet( allKeys );
#endif
}

	CComboError
CPGPDiskApplication::HandleMountPGPDisk(const FSSpec *inFileSpec)
{
	CComboError	err;
	FSSpec		fileSpec;
	Boolean		mountFailed;
					
	mountFailed = FALSE;
	
	// Prompt for the file if inFileSpec is nil
	if( IsNull( inFileSpec ) )
	{
		err.err = GetExistingPGPDiskFSSpec( &fileSpec );
	}
	else
	{
		AssertSpecIsValid( inFileSpec, "HandleMountPGPDisk" );
		
		fileSpec = *inFileSpec;
	}
	
tryAgain:
	if( err.IsntError() )
	{
		PGPDiskFileInfo		fileInfo;
		
		err.err = GetPGPDiskFileInfo( &fileSpec, &fileInfo );
		if( err.IsntError() )
		{
			if( fileInfo.fileIsOpen )
			{
				if( fileInfo.fileIsInUseByDriver )
				{
					if( fileInfo.fileIsMounted )
					{
						err.err = kPGPDiskFileInUseByDriverError;
					}
					else
					{
						// This is the window case where the volume had been
						// unmounted, but the drive queue element has not
						// been deleted yet. If the user is attempting to
						// open the file again, then just try to mount the
						// disk.
						
						ParamBlockRec	pb;
						
						pgpClearMemory( &pb, sizeof( pb ) );
						
						pb.volumeParam.ioVRefNum = fileInfo.fileDriveNumber;
						
						err.err = PBMountVol( &pb );
						if( err.IsntError() )
						{
							mountFailed = TRUE;
						}
					}	
				}
				else
				{
					err.err = kPGPDiskFileAlreadyOpenError;
				}
			}
			else
			{
				CSecurePString255	passphrase;
				Boolean				mountReadOnly = FALSE;
				
				err.err = DoMountDiskPassphraseDialog( &fileSpec, FALSE,
										passphrase, &mountReadOnly );
				if( err.IsntError() )
				{
					err = MountPGPDisk( mContext, &fileSpec, FALSE, mountReadOnly,
									passphrase, TRUE, NULL, NULL, NULL );
				}
			}
		}
	}
	
	if( err.IsError() && ! err.IsCancelError() )
	{
		Str255	msg;
		Str255	errorStr;
		
		GetIndString( msg, kErrorStringListResID,
				kCouldNotMountDiskBecauseStrIndex );
		PrintPString( msg, msg, fileSpec.name );
		
		GetComboErrorString( err, errorStr );
		PrintPString( msg, msg, errorStr );
		
		SysBeep( 1 );
		CWarningAlert::Display( kWAStopAlertType, kWAOKStyle, msg );
		
		if( err.err == kPGPDiskIncorrectPassphraseError ||
			err.err == kPGPDiskIncorrectPassphraseNoKeyringsError ||
			err.err == kPGPDiskIncorrectPassphraseKeyNotFoundError )
		{
			err.err		= noErr;
			err.pgpErr	= kPGPError_NoErr;
			
			goto tryAgain;
		}
	}
	
	return( err );
}

	void
CPGPDiskApplication::HandleAddPassphrase(void)
{
	OSStatus	status = noErr;
	FSSpec		fileSpec;
	
	status = GetExistingPGPDiskFSSpec( &fileSpec );
	if( IsntErr( status ) )
	{
		status = VerifyPGPDiskFileIsModifiable( &fileSpec );
		if( IsntErr( status ) )
		{
			CSecurePString255		masterPassphrase;
				
			status = DoGetMasterPassphraseDialog( fileSpec.name,
							masterPassphrase );
			if( IsntErr( status ) )
			{
				status = VerifyMasterPassphrase( mContext, &fileSpec,
								masterPassphrase );
				if( IsntErr( status ) )
				{
					CSecurePString255	newPassphrase;
					Boolean				readOnly = FALSE;
					
					status = DoAddPassphraseDialog( fileSpec.name,
									newPassphrase, &readOnly );
					if( IsntErr( status ) )
					{
						status = AddPassphrase( mContext, &fileSpec, masterPassphrase,
										newPassphrase, readOnly );
					}
				}
			}
		}
	}
	
	if( IsntErr( status ) )
	{
		CWarningAlert::Display( kWANoteAlertType, kWAOKStyle,
							kDialogStringListResID,
						 	kPassphraseAddedSuccessfullyStrIndex );
	}
	else if( status != userCanceledErr )
	{
		Str255	msg;
		Str255	errorStr;
		
		GetIndString( msg, kErrorStringListResID,
				kCouldNotAddPassphraseBecauseStrIndex );
		PrintPString( msg, msg, fileSpec.name );
		
		GetErrorString( status, errorStr );
		PrintPString( msg, msg, errorStr );
		
		SysBeep( 1 );
		CWarningAlert::Display( kWAStopAlertType, kWAOKStyle, msg );
	}
}

	void
CPGPDiskApplication::HandleChangePassphrase(void)
{
	OSStatus	status = noErr;
	FSSpec		fileSpec;
		
	status = GetExistingPGPDiskFSSpec( &fileSpec );
	if( IsntErr( status ) )
	{
		status = VerifyPGPDiskFileIsModifiable( &fileSpec );
		if( IsntErr( status ) )
		{
			CSecurePString255	oldPassphrase;
				
			status = DoGetOldPassphraseDialog( fileSpec.name, oldPassphrase );
			if( IsntErr( status ) )
			{
				status = VerifyPassphrase( mContext, &fileSpec, oldPassphrase );
				if( IsntErr( status ) )
				{
					CSecurePString255	newPassphrase;
					
					status = DoNewPassphraseDialog( fileSpec.name,
									newPassphrase );
					if( IsntErr( status ) )
					{
						status = ChangePassphrase( mContext, &fileSpec,
									oldPassphrase, newPassphrase );
					}
				}
			}
		}
	}
	
	if( IsntErr( status ) )
	{
		CWarningAlert::Display( kWANoteAlertType, kWAOKStyle,
							kDialogStringListResID,
						 	kPassphraseChangedSuccessfullyStrIndex );
	}
	else if( status != userCanceledErr )
	{
		Str255	msg;
		Str255	errorStr;
		
		GetIndString( msg, kErrorStringListResID,
				kCouldNotChangePassphraseBecauseStrIndex );
		PrintPString( msg, msg, fileSpec.name );
		
		GetErrorString( status, errorStr );
		PrintPString( msg, msg, errorStr );
		
		SysBeep( 1 );
		CWarningAlert::Display( kWAStopAlertType, kWAOKStyle, msg );
	}
}

	void
CPGPDiskApplication::HandleRemovePassphrase(void)
{
	OSStatus	status = noErr;
	FSSpec		fileSpec;
		
	status = GetExistingPGPDiskFSSpec( &fileSpec );
	if( IsntErr( status ) )
	{
		status = VerifyPGPDiskFileIsModifiable( &fileSpec );
		if( IsntErr( status ) )
		{
			CSecurePString255	passphrase;
					
			status = DoGetRemovePassphraseDialog( fileSpec.name, passphrase );
			if( IsntErr( status ) )
			{
				status = VerifyPassphrase( mContext, &fileSpec, passphrase );
				if( IsntErr( status ) )
				{
					status = RemovePassphrase( mContext, &fileSpec, passphrase );
				}
			}
		}
	}
	
	if( IsntErr( status ) )
	{
		CWarningAlert::Display( kWANoteAlertType, kWAOKStyle,
							kDialogStringListResID,
						 	kPassphraseRemovedSuccessfullyStrIndex );
	}
	else if( status != userCanceledErr )
	{
		Str255	msg;
		Str255	errorStr;
		
		GetIndString( msg, kErrorStringListResID,
				kCouldNotRemovePassphraseBecauseStrIndex );
		PrintPString( msg, msg, fileSpec.name );
		
		GetErrorString( status, errorStr );
		PrintPString( msg, msg, errorStr );
		
		SysBeep( 1 );
		CWarningAlert::Display( kWAStopAlertType, kWAOKStyle, msg );
	}
}

	void
CPGPDiskApplication::HandleRemoveAltPassphrases(void)
{
	OSStatus	status = noErr;
	FSSpec		fileSpec;
		
	status = GetExistingPGPDiskFSSpec( &fileSpec );
	if( IsntErr( status ) )
	{
		status = VerifyPGPDiskFileIsModifiable( &fileSpec );
		if( IsntErr( status ) )
		{
			CSecurePString255	masterPassphrase;
				
			status = DoGetMasterPassphraseDialog( fileSpec.name,
						masterPassphrase );
			if( IsntErr( status ) )
			{
				status = VerifyMasterPassphrase( mContext, &fileSpec,
								masterPassphrase );
				if( IsntErr( status ) )
				{
					status = RemoveAlternatePassphrases( mContext, &fileSpec );
				}
			}
		}
	}
	
	if( IsntErr( status ) )
	{
		CWarningAlert::Display( kWANoteAlertType, kWAOKStyle,
							kDialogStringListResID,
						 	kAltPassphrasesRemovedSuccessfullyStrIndex );
	}
	else if( status != userCanceledErr )
	{
		Str255	msg;
		Str255	errorStr;
		
		GetIndString( msg, kErrorStringListResID,
				kCouldNotRemoveAltPassphrasesBecauseStrIndex );
		PrintPString( msg, msg, fileSpec.name );
		
		GetErrorString( status, errorStr );
		PrintPString( msg, msg, errorStr );
		
		SysBeep( 1 );
		CWarningAlert::Display( kWAStopAlertType, kWAOKStyle, msg );
	}
}

//	Respond to 'odoc' AppleEvent events

	void
CPGPDiskApplication::HandleAppleEvent(
	const AppleEvent	&inAppleEvent,
	AppleEvent			&outAEReply,
	AEDesc				&outResult,
	long				inAENumber)
{
	switch (inAENumber)
	{
		case ae_OpenDoc:
			DoOpenDocAppleEvent( inAppleEvent );
			break;
			
		default:
			LApplication::HandleAppleEvent(inAppleEvent, outAEReply,
								outResult, inAENumber);
			break;
	}
}

	void
CPGPDiskApplication::DoOpenFile(const FSSpec *theFile)
{
	CInfoPBRec	cpb;
	OSStatus	status;
	
	AssertSpecIsValid( theFile, "DoOpenFile" );
	
	status = FSpGetCatInfo( theFile, &cpb );
	if( IsntErr( status ) && cpbIsFile( &cpb ) )
	{
		if( IsPGPDiskFileType( cpbFileCreator( &cpb ), cpbFileType( &cpb ) ) )
		{
			Boolean	enabled;
			Boolean	usesMark;
			Char16	mark;
			Str255	name;
			
			enabled = FALSE;
			FindCommandStatus( cmd_MountPGPDisk, enabled, usesMark, mark,
					name );

			if( enabled )
			{
				HandleMountPGPDisk( theFile );
			}
		}
		else
		{
			// Ignore all other file types
		}
	}
}

//	Respond to an AppleEvent to open a Document. Stolen From LApplication

	void
CPGPDiskApplication::DoOpenDocAppleEvent(const AppleEvent &inAppleEvent)
{
	AEDescList	docList;
	OSErr		err = ::AEGetParamDesc(&inAppleEvent, keyDirectObject,
							typeAEList, &docList);
	ThrowIfOSErr_(err);
	
	Int32	numDocs;
	err = ::AECountItems(&docList, &numDocs);
	
	sHaveODOCEvent = TRUE;
	
	ThrowIfOSErr_(err);

		// Loop through all items in the list
			// Extract descriptor for the document
			// Coerce descriptor data into a FSSpec
			// Tell Program object to open document
		
	for (Int32 i = 1; i <= numDocs; i++)
	{
		AEKeyword	theKey;
		DescType	theType;
		FSSpec		theFileSpec;
		Size		theSize;
	
		err = ::AEGetNthPtr(&docList, i, typeFSS, &theKey, &theType,
							(Ptr) &theFileSpec, sizeof(FSSpec), &theSize);
		ThrowIfOSErr_(err);
		
		DoOpenFile( &theFileSpec );
	}
	
	if( ! sHaveOAPPEvent )
	{
		// User launched app from finder by double clicking on a document.
		// Don't leave the app running in this case.
		DoQuit();
	}
	
	::AEDisposeDesc(&docList);
}

	void
CPGPDiskApplication::StartUp(void)
{
	LApplication::StartUp();
	
	sHaveOAPPEvent = TRUE;
	
	sMainWindowObj->Show();
	sMainWindowObj->UpdatePort();
}

	void
CPGPDiskApplication::ProcessNextEvent(void)
{
	LApplication::ProcessNextEvent();
	
	if( ! sHaveODOCEvent && ! sHaveOAPPEvent )
	{
		static Boolean	sNumProcessedEvents = 0;
	
		++sNumProcessedEvents;
		if( sNumProcessedEvents > 10 )
		{
			pgpDebugMsg( "Forcing application startup" );
			StartUp();
		}
	}
}


	void
CPGPDiskApplication::SpendTime(const EventRecord &inMacEvent)
{
	#pragma unused( inMacEvent )

	ushort			modifiers;
	static ushort	lastModifiers;
	
	modifiers = GetModifiers();
	if( modifiers != lastModifiers )
	{
		lastModifiers = modifiers;
		LCommander::SetUpdateCommandStatus( TRUE );
	}
}

	void
CPGPDiskApplication::MakeMenuBar(void)
{
	// we need to suspend leaks checking for MakeMenuBar
	// because PowerPlant will never release certain items

	MacLeaks_Suspend();

	new LMenuBar( 128 );

	MacLeaks_Resume();
}

	static PGPError
RecipientsDialog(
	PGPContextRef 			context,
	PGPKeySetRef			allKeys,
	PGPUInt32				numDefaultKeys,
	const PGPRecipientSpec	*defaultKeyList,
	PGPUInt32				*numKeys,
	PGPRecipientSpec		**keyList,
	PGPBoolean				*readOnly)
{
	PGPError		err;
	PGPMemoryMgrRef	memoryMgr;
	PGPPrefRef		clientPrefsRef	= kInvalidPGPPrefRef;
	
#if PGP_BUSINESS_SECURITY
	PGPPrefRef		adminPrefsRef	= kInvalidPGPPrefRef;	
#endif

	memoryMgr 	= PGPGetContextMemoryMgr( context );
	*keyList	= NULL;
	*numKeys	= 0;
	*readOnly	= FALSE;
	
	err = PGPOpenClientPrefs( memoryMgr, &clientPrefsRef );

#if PGP_BUSINESS_SECURITY
	if( IsntPGPError( err ) ) 
	{
		err = PGPOpenAdminPrefs( memoryMgr, &adminPrefsRef );
	}
#endif

	if( IsntPGPError( err ) )
	{
		PGPOptionListRef	recipientOptions;
		PGPBoolean			showMarginalValidity;
		PGPBoolean			marginalIsInvalid;
		PGPBoolean			warnOnADKs;
		char				title[256];
		char				desc[256];
		PGPUInt32			readOnlyInt;
		PGPKeySetRef		recipients;
		
		(void) PGPGetPrefBoolean( clientPrefsRef,
					kPGPPrefDisplayMarginalValidity, &showMarginalValidity);
		(void) PGPGetPrefBoolean( clientPrefsRef, kPGPPrefMarginalIsInvalid,
					&marginalIsInvalid);
		(void) PGPGetPrefBoolean( clientPrefsRef, kPGPPrefWarnOnADK,
						&warnOnADKs );

		GetIndCString( title, kDialogStringListResID,
				kReadOnlyCheckboxTitleStrIndex );
		GetIndCString( desc, kDialogStringListResID,
				kReadOnlyCheckboxDescStrIndex );

		err = PGPBuildOptionList( context, &recipientOptions,
					PGPOUIDisplayMarginalValidity( context,
						showMarginalValidity ),
					PGPOUIIgnoreMarginalValidity( context, marginalIsInvalid ),
					PGPOUIRecipientList( context, numKeys, keyList ),
					PGPOUIDialogOptions( context,
						PGPOUICheckbox( context, 1, title, desc, 0,
							&readOnlyInt, PGPOLastOption( context ) ),
						PGPOLastOption( context ) ),
					PGPOLastOption( context ) );
		if( IsntPGPError( err ) && IsntNull( defaultKeyList ) )
		{
			err = PGPAppendOptionList( recipientOptions,
						PGPOUIDefaultRecipients( context, numDefaultKeys,
							defaultKeyList ),
						PGPOLastOption( context ) );
		}
		
		if( IsntPGPError( err ) )
		{
			PGPAdditionalRecipientRequestEnforcement	arrEnforcement;
			
			arrEnforcement = kPGPARREnforcement_Warn;
			
		#if PGP_BUSINESS_SECURITY
			{
				PGPBoolean	enforceRemoteADKClass;
				
				if( IsntPGPError( PGPGetPrefBoolean( adminPrefsRef,
									kPGPPrefEnforceRemoteADKClass,
									&enforceRemoteADKClass ) ) &&
					enforceRemoteADKClass )
				{
					arrEnforcement = kPGPARREnforcement_Strict;
				}
			}
		#endif // PGP_BUSINESS_SECURITY
			
			UDesktop::Deactivate();		
			err = PGPRecipientDialog( context, allKeys, TRUE, &recipients,
						recipientOptions,
						PGPOUIEnforceAdditionalRecipientRequests(
							context, arrEnforcement, warnOnADKs ),
						PGPOLastOption( context ) );
			UDesktop::Activate();		

			if( IsntPGPError( err ) )
			{
				*readOnly = ( readOnlyInt != 0 );
				
				pgpAssert( IsntNull( *keyList ) );
				
				if( *numKeys != 0 )
				{
					PGPRecipientSpec	*curSpec = *keyList;
					PGPUInt32			keyIndex;
					
					/*
					** Need to convert keyrefs in the list to key ID's
					** before disposing of the recipients key set
					*/
					
					for( keyIndex = 0; keyIndex < *numKeys; keyIndex++ )
					{
						if( curSpec->type == kPGPRecipientSpecType_Key )
						{
							PGPKeyRef	keyRef;
							
							/* Structure is a union, so save off keyref */
							
							keyRef 			= curSpec->u.key;
							curSpec->type	= kPGPRecipientSpecType_KeyID;
							
							err = PGPGetKeyIDFromKey( keyRef,
										&curSpec->u.id.keyID );
							if( IsntPGPError( err ) )
							{
								PGPInt32	alg;
								
								err = PGPGetKeyNumber( keyRef,
											kPGPKeyPropAlgID, &alg );
							
								curSpec->u.id.algorithm =
										(PGPPublicKeyAlgorithm) alg;
							}
							
							if( IsPGPError( err ) )
								break;
								
							++curSpec;
						}
					}
				}
				
				if( IsPGPError( err ) )
				{
					PGPFreeData( *keyList );
					*keyList = NULL;
				}
				
				PGPFreeKeySet( recipients );
			}
			
			PGPFreeOptionList( recipientOptions );
		}
	}
	
	if( PGPPrefRefIsValid( clientPrefsRef ) )
		PGPClosePrefFile( clientPrefsRef );

#if PGP_BUSINESS_SECURITY
	if( PGPPrefRefIsValid( adminPrefsRef ) )
		PGPClosePrefFile( adminPrefsRef );
#endif	

	return( err );
}

	static CComboError
UpdateKeys(
	PGPDiskFileRef		diskFileRef,
	PGPKeySetRef		allKeys,
	PGPUInt32			numNewKeys,
	PGPRecipientSpec	*newKeyList,
	ConstStr255Param	masterPassphrase,
	PGPBoolean			readOnly)
{
	CComboError	err;
	PGPUInt32	numOldKeys;
	
	/*
	** First pass: Remove existing keys not in the new
	** key list.
	*/
	
	numOldKeys = GetPublicPGPDiskKeyCount( diskFileRef );
	if( numOldKeys != 0 )
	{
		PGPInt32	oldIndex;
	
		for( oldIndex = numOldKeys - 1; oldIndex >= 0; oldIndex-- )
		{
			PGPDiskKeyRef	diskKeyRef;
			
			err.err = GetIndPublicPGPDiskKey( diskFileRef, oldIndex,
							&diskKeyRef );
			if( err.IsntError() )
			{
				PGPKeyID				keyID;
				PGPPublicKeyAlgorithm	algorithm;
				PGPBoolean				locked;
				
				err = GetPublicPGPDiskKeyInfo( diskKeyRef, &keyID,
							&algorithm, &locked );
				if( err.IsntError() && ! locked )
				{
					PGPUInt32	newIndex;
					PGPBoolean	foundKey = FALSE;
					
					for( newIndex = 0; newIndex < numNewKeys; ++newIndex )
					{
						PGPRecipientSpec	*spec = &newKeyList[newIndex];
						
						if( PGPCompareKeyIDs( &spec->u.id.keyID,
								&keyID ) == 0 &&
							spec->u.id.algorithm == algorithm )
						{
							foundKey = TRUE;
							break;
						}	
					}
					
					if( ! foundKey )
					{
						err.err = RemovePGPDiskKey( diskKeyRef );
					}
				}
				
				DisposePGPDiskKey( diskKeyRef );
			}
		}
	}
	
	/*
	** Second pass: Add all keys on the new list. If a key is already
	** on the disk it will be ignored. If we cannot find a key in the
	** keyring then it should already be on the disk.
	*/

	if( err.IsntError() )
	{
		PGPUInt32	newIndex;
		
		for( newIndex = 0; newIndex < numNewKeys; ++newIndex )
		{
			PGPRecipientSpec	*spec = &newKeyList[newIndex];
			PGPKeyRef			keyRef;
			
			pgpAssert( spec->type == kPGPRecipientSpecType_KeyID );
			
			if( IsntPGPError( PGPGetKeyByKeyID( allKeys, &spec->u.id.keyID,
					spec->u.id.algorithm, &keyRef ) ) )
			{
				err = AddPublicPGPDiskKey( diskFileRef, keyRef,
							masterPassphrase, readOnly, FALSE );
				if( err.IsError() )
				{
					break;
				}
			}
		}	
	}
	
	if( err.IsntError() )
	{
		err.err = SavePGPDiskFile( diskFileRef );
	}
	
	return( err );
}

	void
CPGPDiskApplication::HandleAddRemovePublicKeys(void)
{
	CComboError			err;
	FSSpec				fileSpec;
	CSecurePString255	masterPassphrase;
			
	err.err = GetExistingPGPDiskFSSpec( &fileSpec );
	if( err.IsntError() )
	{
		err.err = VerifyPGPDiskFileIsModifiable( &fileSpec );
		if( err.IsntError() )
		{
			err.err = DoGetMasterPassphraseDialog( fileSpec.name,
							masterPassphrase );
			if( err.IsntError() )
			{
				err.err = VerifyMasterPassphrase( mContext, &fileSpec,
								masterPassphrase );
			}
		}
	}

	if( err.IsntError() )
	{
		PGPDiskFileRef	diskFileRef;
		
		err.err = OpenPGPDiskFile( mContext, &fileSpec, &diskFileRef );
		if( err.IsntError() )
		{
			PGPUInt32			numKeys;
			PGPRecipientSpec	*oldKeyList = NULL;
			PGPUInt32			numOldKeys = 0;
			
			numKeys = GetPublicPGPDiskKeyCount( diskFileRef );
			if( numKeys != 0 )
			{
				oldKeyList = (PGPRecipientSpec *) pgpAllocMac( numKeys *
										sizeof( oldKeyList[0] ),
										kMacMemory_ClearBytes |
										kMacMemory_UseApplicationHeap );
				if( IsntNull( oldKeyList ) )
				{
					PGPUInt32			defaultKeyIndex;
					PGPRecipientSpec	*curSpec = oldKeyList;
				
					for( defaultKeyIndex = 0; defaultKeyIndex < numKeys;
							defaultKeyIndex++ )
					{
						PGPDiskKeyRef		diskKeyRef;
						
						err.err = GetIndPublicPGPDiskKey( diskFileRef,
								defaultKeyIndex, &diskKeyRef );
						if( err.IsntError() )
						{
							PGPBoolean	locked;
							
							err = GetPublicPGPDiskKeyInfo(
									diskKeyRef, &curSpec->u.id.keyID,
									&curSpec->u.id.algorithm,
									&locked );
							if( err.IsntError() )
							{
								curSpec->type 	= kPGPRecipientSpecType_KeyID;
							#if PGP_BUSINESS_SECURITY
								curSpec->locked	= locked;
							#endif
							
								++curSpec;
								++numOldKeys;
							}
							
							DisposePGPDiskKey( diskKeyRef );
						}
						
						if( err.IsError() )
							break;
					}
				}
				else
				{
					err.pgpErr = kPGPError_OutOfMemory;
				}
			}
			
			if( err.IsntError() )
			{
				PGPKeySetRef	allKeys;
				
				err.pgpErr = PGPOpenDefaultKeyRings( mContext, 0,
								&allKeys );
				if( err.IsntError() )
				{
					PGPRecipientSpec	*newKeyList = NULL;
					PGPUInt32			numNewKeys	= 0;
					PGPBoolean			readOnly;
					
					UDesktop::Deactivate();
						err.pgpErr = RecipientsDialog( mContext,
										allKeys, numOldKeys,
										oldKeyList, &numNewKeys,
										&newKeyList, &readOnly );
					UDesktop::Activate();
					
					if( err.IsntError() )
					{
						err = UpdateKeys( diskFileRef, allKeys,
									numNewKeys, newKeyList,
									masterPassphrase, readOnly );

						PGPFreeData( newKeyList );
					}
				
					PGPFreeKeySet( allKeys );
				}
			}
			
			if( IsntNull( oldKeyList ) )
				pgpFreeMac( oldKeyList );

			ClosePGPDiskFile( diskFileRef );
		}
	}
	
	if( err.IsError() && ! err.IsCancelError() )
	{
		Str255	msg;
		Str255	errorStr;
		
		GetIndString( msg, kErrorStringListResID,
			kCouldNotAddPublicKeysBecauseStrIndex );
		PrintPString( msg, msg, fileSpec.name );
		
		GetComboErrorString( err, errorStr );
		PrintPString( msg, msg, errorStr );
		
		SysBeep( 1 );
		CWarningAlert::Display( kWAStopAlertType, kWAOKStyle, msg );
	}
	
}

#if PGP_DEBUG	// [

#define	kDebugMenuID	10001	// Must not conflict with regular menus

	void
CPGPDiskApplication::InstallDebugMenu(void)
{
	LMenu	*debugMenu;
	
	// Need to suspend leaking because PowerPlant menu objects leak like
	// crazy
	MacLeaks_Suspend();
	
	debugMenu = new( LMenu )( kDebugMenuResID );
	if( debugMenu != nil )
	{
		LMenuBar::GetCurrentMenuBar()->InstallMenu( debugMenu, 0 );
	}
	else
	{
		pgpDebugMsg( "InstallDebugMenu: Failed to create menu" );
	}

	MacLeaks_Resume();
}


	void
CPGPDiskApplication::DebugMountUnmountTest(void)
{
	CComboError			err;
	FSSpec				fileSpec;
	CSecurePString255	passphrase;
	Boolean				mountReadOnly;
					
	err.err = GetExistingPGPDiskFSSpec( &fileSpec );
	if( err.IsntError() )
	{
		err.err = DoMountDiskPassphraseDialog( &fileSpec, FALSE,
							passphrase, &mountReadOnly );
	}
	
	if( err.IsntError() )
	{
		CPGPStDialogHandler	dialogHandler( kWarningAlertDialogResID, nil );
		CWarningAlert	*dialogObj;
		Str255			msg;
		
		dialogObj = (CWarningAlert *) dialogHandler.GetDialog();
		if( IsNull( dialogObj ) )
		{
			pgpDebugMsg( "WarningAlert: Nil dialog object" );
		}
		
		PrintPString( msg, "\pMounting and unmounting the PGPDisk \322%1\323...",
				fileSpec.name );
		
		if( dialogObj->SetupDialog( kWANoteAlertType, kWACancelStyle, msg ) )
		{
			Boolean	mounted = FALSE;
			Boolean	done = FALSE;
			
			dialogObj->Show();
			
			while ( ! done )
			{
				UInt32	startTicks;
				
				startTicks = TickCount();
				
				// Delay 5 seconds between each mount/unmount cycle
				while( TickCount() - startTicks < 5 * 60L )
				{
					MessageT		result;
					
					result = dialogHandler.DoDialog();
					if( result > 0 )
					{
						done = TRUE;
						break;
					}
				}
				
				
				if( mounted )
				{
					PGPDiskFileInfo		fileInfo;
					
					// Unmount our disk.
			
					err.err = GetPGPDiskFileInfo( &fileSpec, &fileInfo );
					if( err.IsntError() )
					{
						ParamBlockRec	pb;
						
						pgpAssert( fileInfo.fileIsInUseByDriver );
						pgpAssert( fileInfo.fileIsMounted );
						pgpAssert( fileInfo.fileDriveNumber > 0 );
						
						pgpClearMemory( &pb, sizeof( pb ) );
						
						pb.volumeParam.ioVRefNum = GetVCBForDrive(
								fileInfo.fileDriveNumber )->vcbVRefNum;
						
						err.err = PBUnmountVol( &pb );
					}
					
					mounted = FALSE;
					
				}
				else if( ! done )
				{
					err = MountPGPDisk( mContext, &fileSpec, FALSE, mountReadOnly,
									passphrase, FALSE, NULL, NULL, NULL );
					if( err.IsntError() )
					{
						mounted = TRUE;
					}
				}
			}
				
			dialogObj->Hide();
		}
	}
	
	pgpAssert( err.IsntError() || err.IsCancelError() );
}

	void
CPGPDiskApplication::DebugUnmountAllPGPDisks(void)
{
	const ushort	kMaxDrivers	= 100;
	short			driverRefNums[ kMaxDrivers ];
	ushort 			numDrivers;
	
	GetAllPGPDiskDrivers( driverRefNums, kMaxDrivers, &numDrivers);
	for( ushort driverIndex = 0; driverIndex < numDrivers; ++driverIndex )
		{
		UnmountAllCloseAndRemove( driverRefNums[ driverIndex ] );
		}
}

	static OSStatus
FragmentFork(
	short 	sourceFileRef,
	short 	destFileRef,
	short 	tempFileRef,
	UInt32 	ioSize)
{
	OSStatus	status;
	Ptr			buffer;
	
	buffer = NewPtr( ioSize );
	if( IsntNull( buffer ) )
	{
		status = SetFPos( sourceFileRef, fsFromStart, 0 );
		if( IsntErr( status ) )
		{
			status = SetFPos( destFileRef, fsFromStart, 0 );
			if( IsntErr( status ) )
			{
				UInt32	bytesRemaining;
				
				status = GetEOF( sourceFileRef, (long *) &bytesRemaining );
				if( IsntErr( status ) )
				{
					while( bytesRemaining != 0 )
					{
						UInt32	bytesToRead;
						UInt32	bytesRead;
						
						bytesToRead = bytesRemaining;
						if( bytesToRead > ioSize )
							bytesToRead = ioSize;
						
						bytesRead = bytesToRead;
						
						status = FSRead( sourceFileRef, (long *) &bytesRead,
										buffer );
						if( IsntErr( status ) )
						{
							UInt32	bytesToWrite;
							
							bytesToWrite = bytesRead;
							
							status = FSWrite( destFileRef,
										(long *) &bytesToWrite, buffer );
							if( IsntErr( status ) )
							{
								(void) FlushFile( destFileRef );
								
								bytesToWrite = bytesRead;
								
								status = FSWrite( tempFileRef,
											(long *) &bytesToWrite, buffer );
								(void) FlushFile( tempFileRef );
							}
						}
						
						if( IsErr( status ) )
							break;
							
						bytesRemaining -= bytesRead;
					}
				}
			}
		}
		
		DisposePtr( buffer );
	}
	else
	{
		status = memFullErr;
	}
	
	return( status );
}

	static OSStatus
DoFragmentFiles(const FSSpec *sourceSpec, const FSSpec *destSpec)
{
	OSStatus	status;
	CInfoPBRec	cpb;
	
	status = FSpGetCatInfo( sourceSpec, &cpb );
	if( IsntErr( status ) )
	{
		(void) FSpDelete( destSpec );
		
		status = FSpCreate( destSpec, cpbFileCreator( &cpb ),
						cpbFileType( &cpb ), 0 );
		if( IsntErr( status ) )
		{
			FSSpec	tempFileSpec;
			
			tempFileSpec = *destSpec;
			NumToString( TickCount(), tempFileSpec.name );
			
			status = FSpCreate( &tempFileSpec, '????', '????', 0 );
			if( IsntErr( status ) )
			{
				short	tempFileRef;
				
				status = FSpOpenDF( &tempFileSpec, fsRdWrPerm, &tempFileRef );
				if( IsntErr( status ) )
				{
					UInt32	ioSize;
					
					status = GetVolumeBlockCounts( destSpec->vRefNum, nil,
									nil, &ioSize );
					if( IsntErr( status ) )
					{
						short	sourceFileRef;
						short	destFileRef;
						
						if( cpb.hFileInfo.ioFlLgLen != 0 )
						{
							status = FSpOpenDF( sourceSpec, fsRdPerm,
											&sourceFileRef );
							if( IsntErr( status ) )
							{
								status = FSpOpenDF( destSpec, fsRdWrPerm,
												&destFileRef );
								if( IsntErr( status ) )
								{
									status = FragmentFork( sourceFileRef,
												destFileRef, tempFileRef,
												ioSize );
											
									(void) FSClose( destFileRef );
								}
								
								(void) FSClose( sourceFileRef );
							}
						}
						
						if( IsntErr( status ) &&
							cpb.hFileInfo.ioFlRLgLen != 0 )
						{
							status = FSpOpenRF( sourceSpec, fsRdPerm,
											&sourceFileRef );
							if( IsntErr( status ) )
							{
								status = FSpOpenRF( destSpec, fsRdWrPerm,
												&destFileRef );
								if( IsntErr( status ) )
								{
									status = FragmentFork( sourceFileRef,
												destFileRef, tempFileRef,
												ioSize );
											
									(void) FSClose( destFileRef );
								}
								
								(void) FSClose( sourceFileRef );
							}
						}
					}
				
					(void) FSClose( tempFileRef );
				}				
		
				(void) FSpDelete( &tempFileSpec );
			}
		}
	
	}
	
	return( status );
}

	void
CPGPDiskApplication::DebugFragmentFile(void)
{
	SFTypeList			typeList;
	StandardFileReply	sfReply;
	
	StandardGetFile( nil, -1, typeList, &sfReply );
	if( sfReply.sfGood )
	{
		FSSpec	sourceSpec;
		Str255	defaultName;
		
		sourceSpec = sfReply.sfFile;
		
		CopyPString( sourceSpec.name, defaultName );
		
		if( defaultName[0] > 26 )
			defaultName[0] = 26;
			
		AppendPString( "\p.frag", defaultName );
		
		StandardPutFile( "\pSave fragmanted file as", defaultName, &sfReply );
		if( sfReply.sfGood )
		{
			FSSpec	destSpec;
			
			destSpec = sfReply.sfFile;
			
			if( ! FSpEqual( &sourceSpec, &destSpec ) )
			{
				OSStatus	status;
				
				status = DoFragmentFiles( &sourceSpec, &destSpec );
				if( IsErr( status ) )
				{
					CWarningAlert::Display( kWAStopAlertType, kWAOKStyle,
						"\pAn error occurred while fragmenting the file" );
				}	
			}
			else
			{
				CWarningAlert::Display( kWAStopAlertType, kWAOKStyle,
							"\pYou cannot fragment a file in place" );
			}
		}
	}
}

	void
CPGPDiskApplication::DebugTemp1(void)
{
	pgpDebugMsg( "DebugTemp1 not implemented" );
}

	void
CPGPDiskApplication::DebugTemp2(void)
{
	pgpDebugMsg( "DebugTemp2 not implemented" );
}

	void
CPGPDiskApplication::DebugTemp3(void)
{
	pgpDebugMsg( "DebugTemp3 not implemented" );
}

#endif // ]
