/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: DriverAPI.h,v 1.5 1999/03/10 02:24:36 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "DriverPrefs.h"

const ushort	kPGPDiskDriverVersion	= 0x0101;

const ulong		kPGPDiskBlockSize	= 512;
const OSType	kPGPDiskDriverType	= 'Drvr';
const uchar		kPGPDiskDriverNamePrefix[]	= "\p.PGPDisk";
const uchar		kPGPDiskDriverName[]		= "\p.PGPDisk000";


#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k		// [
#endif

#include "TunerStruct.h"


/*___________________________________________________________________________
	Used to tell the driver how to tune itself for a particular drive.
___________________________________________________________________________*/
typedef struct IOOptionsStruct
	{
	enum TunerType { kReadTuner, kWriteTuner };
	short			driveNumber;
	
	TunerType		tunerType;
	TunerStruct		tuner;
	} IOOptionsStruct;


// used in 'kGetDriverInfoSC' call
typedef struct PGPDriverInfoStruct
	{
	ushort		versionOut;
	ulong		writeBufferSizeOut;
	ushort		numDrivesOut;
	
	ulong		reserved[ 128 ];
	} PGPDriverInfoStruct;


// used for 'kGetDriveInfoSC' call
typedef struct PGPDriveInfoStruct
	{
	short			driveNumberIn;
	
	short			baseDriveNumberOut;
	TunerStruct		readTuneOut;
	TunerStruct		writeTuneOut;
	Boolean			breaksUpRequests;
	short			fileRefNum;
	ulong			reserved[ 128 ];
	
	} PGPDriveInfoStruct;


typedef struct PGPDriveUnmountedStruct
	{
	short					driveNumber;
	ProcessSerialNumber		unmountingProcess;
	
	} PGPDriveUnmountedStruct;


/*___________________________________________________________________________
	Used for all API calls.  'data' is typically a pointer to a struct or
	other data.
___________________________________________________________________________*/
typedef struct DriverAPIStruct
	{
	enum { kMagicIn = 'pgpI', kMagicOut = 'pgpO' };
	ulong	magic;
	long	data;
	
	// CAUTION: this entire struct must be no larger than short csParam[11]
	#define kCSParamSize	( sizeof( short ) * 11 )
	char		extra[ kCSParamSize  - sizeof( long ) - sizeof( ulong ) ]; 
	} DriverAPIStruct;




#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset	// ]
#endif



#include "AddDriveStruct.h"





// control and status codes for our driver
enum
	{
	// control codes
	kSetPrefsCC	= 10000,
	kAddDriveCC,
	kRemoveDriveCC,
	
	kChangeWriteBufferSizeCC,
	kSetIOOptionsCC,
	kToggleKeyBitsCC,
	kDriveUnmountedCC,
	
	// Status codes
	kFirstSC = 11100,
	kGetDriverInfoSC,
	kGetDriveInfoSC
	};


Boolean		IsPGPDiskDriver( short driverRefNum );

OSErr		PGPDiskStatus( ParamBlockRec *pb, short csCode, long data,
					short driverRefNum = 0);
OSErr		PGPDiskControl( ParamBlockRec *pb, short csCode, long data,
					short driverRefNum = 0);

Boolean		DriveIsPGPDisk( short vRefNum );
Boolean 	DriverNameIsPGPDisk( ConstStr255Param driverName );

Boolean		VolumeIsPGPDisk( short vRefNum );
OSErr		GetPGPDiskDriverInfo( short driverRefNum,
					PGPDriverInfoStruct *driverInfo );
OSErr		GetPGPDriveInfo( short driveNumber,
					PGPDriveInfoStruct *driveInfo );
OSStatus	ChangeWriteBufferSize( short driverRefNum, ulong bufferSize );
OSStatus	PGPDriverRemoveDrive( short driverRefnum,  short driveNumber );

OSErr		ChangeDriveTuner( short vRefNum, const TunerStruct * tuner,
					IOOptionsStruct::TunerType	tunerType);


void		GetUniquePGPDiskDriverName( StringPtr newName );


OSStatus	SendPreferencesToDriver(short driverRefNum,
					const PGPDiskDriverPrefs *driverPrefs);
OSStatus	PGPDiskDriveUnmountedInProcess(short driverRefNum,
					short driveNumber, ProcessSerialNumber unmountingAppPSN);

