/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CDirectoryNewDialog.cp,v 1.5 1999/03/10 02:32:21 heller Exp $
____________________________________________________________________________*/
#include "CDirectoryNewDialog.h"
#include "CPFDirectoryWindow.h"
#include <LBevelButton.h>
#include <LRadioButton.h>

const uchar directoryFilename[]="\pPGPFone Directory";

CDirectoryNewDialog *
CDirectoryNewDialog::CreateDirectoryNewDialogStream(
	LStream *inStream)
{
	return (new CDirectoryNewDialog(inStream));
}

CDirectoryNewDialog::CDirectoryNewDialog()
{
}

CDirectoryNewDialog::CDirectoryNewDialog(LStream *inStream)
	: LGADialog(inStream)
{
}

CDirectoryNewDialog::~CDirectoryNewDialog()
{
}

void
CDirectoryNewDialog::FinishCreateSelf()
{
	LGADialog::FinishCreateSelf();
	
	mDirWindow			= (CPFDirectoryWindow *)GetSuperCommander();
	mNameField			= (LEditText *)FindPaneByID('eNam');
	mAddressField		= (LEditText *)FindPaneByID('eAdd');
	mHelpCaption		= (LCaption *)FindPaneByID('cHlp');
	mModemButton		= (LRadioButton *)FindPaneByID('rMod');
	mAppleTalkButton	= (LRadioButton *)FindPaneByID('rApp');
	mInternetButton		= (LRadioButton *)FindPaneByID('rInt');
	mModemButton->AddListener(this);
	mAppleTalkButton->AddListener(this);
	mInternetButton->AddListener(this);
	mConnection			= _cme_Internet;
	mInternetButton->SetValue(1);
	SwitchTarget((LEditText *)FindPaneByID('eNam'));
}

void
CDirectoryNewDialog::SetFields(	enum ContactMethods connection,
								uchar				*name,
								uchar				*address)
{
	mNameField->SetDescriptor(name);
	mAddressField->SetDescriptor(address);
	switch(connection)
	{
		case _cme_Internet:
			mInternetButton->SetValue(1);
			break;
		case _cme_Serial:
			mModemButton->SetValue(1);
			break;
		case _cme_AppleTalk:
			mAppleTalkButton->SetValue(1);
			break;
	}
}

void
CDirectoryNewDialog::ListenToMessage(MessageT inMessage, void *ioParam)
{
	long value;
	
	value = (long) ioParam;
	switch(inMessage)
	{
		case 'rMod':
		case 'rApp':
		case 'rInt':
			if(mModemButton->GetValue())
			{
				mConnection	= _cme_Serial;
				mHelpCaption->SetDescriptor(
					"\pAddress entered should be a telephone number.\r(ie. 1-415-555-1212)");
			}
			else if(mAppleTalkButton->GetValue())
			{
				mConnection	= _cme_AppleTalk;
				mHelpCaption->SetDescriptor(
					"\pAddress entered should be an AppleTalk address.\r(ie. Zone;MachineName)");
			}
			else if(mInternetButton->GetValue())
			{
				mConnection	= _cme_Internet;
				mHelpCaption->SetDescriptor(
					"\pAddress entered should be an Internet address in DNS or dot notation.\r"
					"(ie. cpu.company.com)\r");
			}
			break;
		case 'bOK ':
			{
				uchar	name[32],
						address[64];
				
				// Save Info and send to main dir window
				mNameField->GetDescriptor(name);
				mAddressField->GetDescriptor(address);
				if(name[0] && address[0])
					mDirWindow->AddEntry(name, address, mConnection);
				else
				{
					PGFAlert("Please fill in all fields.", 0);
					break;
				}
			}
			delete this;
			break;
		case 'bCan':
			mDirWindow->CancelEntry();
			delete this;
	}
}

