/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: COTConfigDialog.cp,v 1.4 1999/04/08 11:45:27 wprice Exp $
____________________________________________________________________________*/
#include "COTConfigDialog.h"

#include <MacWindows.h>
#include <URegistrar.h>
#include <PP_Messages.h>
#include "CPGPnet.h"
#include "CColumnTable.h"
#include "MacStrings.h"
#include "pgpMem.h"
#include "MoreNetworkSetup.h"
#include "WarningAlert.h"

const PaneIDT	button_OK			=	'okay';
const PaneIDT	button_Secure		=	'secu';
const PaneIDT	table_Config		=	'tCfg';

const ResIDT	icon_Lock			=	3100;

enum {
	STRx_ConfigDialog						=	1014,
	kMakeSecureString						=	1,
	kMakeInsecureString						=	2,
	kNoNetworkSetupString					=	3
};

class	COTConfigTable	:	public CColumnTable
{
public:
	enum { class_ID = 'cfgT' };
						COTConfigTable(LStream *inStream) :
							CColumnTable(inStream) { };
	virtual				~COTConfigTable() { };
	void				FinishCreateSelf();
	virtual Boolean		GetCellDrawData(
								STableCell			inCell,
								ResIDT				&iconID,
								Int16				&indentLevel,
								Str255				data,
								StyleParameter		&style );
};

COTConfigDialog::COTConfigDialog(
	LStream * inStream) :
	LGADialog(inStream)
{
	RegisterClass_( COTConfigTable );
	mConfigList = (NSHConfigurationListHandle) NewHandle(0);
	mChanged = FALSE;
}

COTConfigDialog::~COTConfigDialog()
{
	DisposeHandle( (Handle)mConfigList );
}

	void
COTConfigDialog::FinishCreateSelf()
{
	OSStatus	err;
	
	mSecureButton	= (LPushButton *) FindPaneByID( button_Secure );
	mSecureButton->AddListener( this );
	( (LPushButton *) FindPaneByID( button_OK ) )->AddListener( this );
	
	mConfigTable	= (COTConfigTable *) FindPaneByID( table_Config );
	mConfigTable->AddListener( this );
	
	err = NSHGetConfigurationList( kOTTCPv4NetworkConnection, mConfigList );
	if( IsntErr( err ) )
	{
		ItemCount	numItems = NSHCountConfigurationList( mConfigList ),
					itemInx;
		
		HLock( (Handle) mConfigList );
		for( itemInx = 0; itemInx < numItems; itemInx++ )
		{
			NSHConfigurationListPtr		itemPtr = *mConfigList + itemInx;
			
			mConfigTable->InsertSiblingRows( 1, LArray::index_Last,
					&itemPtr, sizeof( NSHConfigurationListPtr ),
					FALSE, TRUE );
		}
	}
	
	Show();
	SetLatentSub( mConfigTable );
}

	void
COTConfigDialog::ListenToMessage(
	MessageT				inMessage,
	void *	)
{
	STableCell				cell;
	PGPBoolean				selected = FALSE;
	NSHConfigurationListPtr	config = NULL;
	UInt32					dataSize = sizeof(NSHConfigurationListPtr);
	Str255					pstr;
	
	cell = mConfigTable->GetFirstSelectedCell();
	if( cell.row > 0 )
	{
		selected = TRUE;
		cell.row = mConfigTable->GetWideOpenIndex( cell.row );
		mConfigTable->GetCellData( cell, &config, dataSize );
	}
	switch (inMessage)
	{
		case msg_OK:
			if( IsntNull( mConfigList ) && mChanged )
			{
				OSStatus	status;
				status = NSHSetConfigurationList(
						kOTTCPv4NetworkConnection, mConfigList );
				pgpAssert( IsntErr( status ) );
				if( !IsNetworkSetupAvailable() )
				{
					Hide();
					WarningAlert( kWANoteAlertType, kWAOKStyle,
						STRx_ConfigDialog,
						kNoNetworkSetupString );

				}
			}
			break;
		case coltable_SelectChange:
			if( selected )
				mSecureButton->Enable();
			else
				mSecureButton->Disable();
			break;
		case button_Secure:
			if( selected )
			{
				config->crypted = !config->crypted;
				mChanged = TRUE;
				mConfigTable->RefreshCell( cell );
			}
			break;
	}
	if( IsntNull( config ) )
	{
		if( config->crypted )
			GetIndString( pstr, STRx_ConfigDialog, kMakeInsecureString );
		else
			GetIndString( pstr, STRx_ConfigDialog, kMakeSecureString );
		mSecureButton->SetDescriptor( pstr );
	}
}

	void
COTConfigTable::FinishCreateSelf()
{
	CColumnTable::FinishCreateSelf();
}

	Boolean
COTConfigTable::GetCellDrawData(
	STableCell				inCell,
	ResIDT					&iconID,
	Int16					&indentLevel,
	Str255					data,
	StyleParameter			&style )
{
	NSHConfigurationListPtr	config;
	TableIndexT				col;
	UInt32					dataSize = sizeof(NSHConfigurationListPtr);
	
	iconID;	indentLevel;	style;
	col = inCell.col;
	inCell.col = 1;
	GetCellData( inCell, &config, dataSize );
	switch( col )
	{
		case 1:
			if( config->crypted )
				iconID = icon_Lock;
			else
				iconID = -1;
			CopyPString( config->name, data );
			if( config->selected )
				style = bold;
			break;
	}
	return FALSE;
}

