/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CPGPFindermenu.h,v 1.5 1999/04/22 21:09:18 jason Exp $
____________________________________________________________________________*/

#pragma once

#include "CPGPmenu.h"

class CPGPFindermenu	:	public	CPGPmenu {
public:
	enum { kSignature = 'MACS' };
	
						CPGPFindermenu(FSSpec * inFSSpec, SPGPmenuMESPData * inMESPData);
	virtual				~CPGPFindermenu();

	virtual void		Patch();
	
protected:
	class CPGPFindermenuMenuSelectPatch	:	public CPGPmenuMenuSelectPatch {
		virtual long	NewMenuSelect(Point startPt);
	};
	friend class CPGPFindermenuMenuSelectPatch;
	
	PGPBoolean			mWipeTrash;
	PGPBoolean			mWarnOnWipe;
	CString				mSpecialString;
	CString				mEmptyTrashString;
	CString				mWipeTrashString;
	CString				mWarnAndWipeTrashString;
	PGPInt16			mSpecialMenu;
	PGPInt16			mEmptyTrashItem;

	virtual void		Initialize();
	
	virtual void		AdjustMenuItems();
	virtual long		FilterMenuSelect(long inResult);
	virtual void		FindEmptyTrash();
	virtual PGPBoolean	DoWipeTrash();
	virtual void		UpdatePrefs();
	
	virtual void		Sign();
	virtual void		Encrypt();
	virtual void		EncryptAndSign();
	virtual void		DecryptVerify();
	
	virtual void		SendToolsEvent(AEEventID inEventID);
};