/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: MacMenus.h,v 1.4 1999/03/10 02:45:07 heller Exp $
____________________________________________________________________________*/
#ifndef Included_MacMenus_h	/* [ */
#define Included_MacMenus_h

#include "Menus.h"

#pragma options align=mac68k
typedef struct MenuRec {
	MenuRef		menuRef;
	SInt16		menuLeft;
} MenuRec;

typedef struct MenuList {
	SInt16	lastMenu;
	SInt16	lastRight;
	SInt16	notUsed;
	MenuRec	menus[ 1 ];	/* dynamic */
} MenuList;
#pragma options align=reset


PGP_BEGIN_C_DECLARATIONS


ushort		GetNumMenusInMenuBar( void );
MenuHandle	GetIndMenuInMenuBar( ushort index );

#define IsMenuItemEnabled(menuHandle, item)						\
			(((**(menuHandle)).enableFlags & (0x00000001 << (item))) != 0)


PGP_END_C_DECLARATIONS

#endif /* ] Included_MacMenus_h */


/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
