/*____________________________________________________________________________
	MacNew.c
	
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: MacNew.cp,v 1.11 1999/03/16 07:28:03 heller Exp $
____________________________________________________________________________*/

#include <stddef.h>

#include "MacNew.h"

#if USE_MAC_OPERATOR_NEW
#error use 'USE_PGP_OPERATOR_NEW'
#endif


#if USE_PGP_OPERATOR_NEW	// [

#include <new>


/* Temporarily disable leaks tracking */
#undef NewPtr
#undef DisposePtr

MacNewDummy::MacNewDummy()
{
}

/*____________________________________________________________________________
	With the modern memory manager, NewPtr() is substantially faster
	than MetroWerks operator new().
____________________________________________________________________________*/
	void *
operator new(size_t size)
{
	void *ptr;
	
#if MEMORY_ALLOC_MUST_BE_APP
	pgpAssertMsg( GetZone() == ApplicationZone(),
		"operator new: MEMORY_ALLOC_MUST_BE_APP");
#elif MEMORY_ALLOC_MUST_BE_SYS
	pgpAssertMsg( GetZone() == SystemZone(),
		"operator new: MEMORY_ALLOC_MUST_BE_SYS");
#elif MEMORY_ALLOC_MUST_BE_APP_OR_SYS
	pgpAssertMsg( GetZone() == ApplicationZone() || GetZone() == SystemZone(),
		"operator new: MEMORY_ALLOC_MUST_BE_APP_OR_SYS");
#endif

	ptr	= NewPtr( size );
	
	return ptr;
}
	
	
	void
operator delete(void *ptr)
{
	if( ptr != NULL )
	{
		DisposePtr( (Ptr) ptr );
	}
}

#endif	// ]