#!/usr/local/bin/perl

require "timelocal.pl";

%month2num = ("Jan",0,"Feb",1,"Mar",2,"Apr",3,"May",4,"Jun",5,
	      "Jul",6,"Aug",7,"Sep",8,"Oct",9,"Nov",10,"Dec",11);

@num2month = ("Jan","Feb","Mar","Apr","May","Jun",
	      "Jul","Aug","Sep","Oct","Nov","Dec");

@num2day = ("Sun","Mon","Tue","Wed","Thu","Fri","Sat");

%zoneconv = ("UT",0,"GMT",0,"EST",-5,"EDT",-4,"CST",-6,"CDT",-5,
	     "MST",-7,"MDT",-6,"PST",-8,"PDT",-7);

sub date2time {
  local($datestr) = @_;
  local($day,$mon,$tmpyear,$hour,$min,$tz,$one,$two,$year);
  local($sec,$sign,$hdiff,$mdiff,$time,$success);

  if (($day,$mon,$tmpyear,$hour,$min,$tz) =
      $datestr =~ m/(\d+)[ -]+([A-Za-z]+)[ -]+(\d+) +(\d+):([0-9:]+) +([A-Za-z0-9\+-]+)/o) {
    $success = 1;
  } elsif (($mon,$day,$hour,$min,$tz,$tmpyear) =
      $datestr =~ m/([A-Za-z]+) +(\d+) +(\d+):([0-9:]+) +([A-Za-z0-9\+-]+) +(\d+)/o) {
    $success = 1;
  } elsif (($mon,$day,$hour,$min,$tmpyear) =
      $datestr =~ m/([A-Za-z]+) +(\d+) +(\d+):([0-9:]+) +(\d+)/o) {
    $tz = $localtz;
    $success = 1;
  } elsif (($day,$mon,$tmpyear,$hour,$min) =
     $datestr =~ m/(\d+) +([A-Za-z]+) +(\d+) +(\d+):([0-9:]+)/o) {
    $success = 1;
    $tz = $localtz;
  } else { $success = 0; }

  if ($success) {
    $one = chop($tmpyear);  
    $two = chop($tmpyear);  
    $year = $two . $one;
    $mon = $month2num{$mon};

    if ($min =~ m/:/o) {
      ($min,$sec) = $min =~ m/(\d+):(\d+)/o;
    } else { $sec = 0; }

    ($tz = $tz) =~ tr/a-z/A-Z/;

    ($sign,$hdiff,$mdiff) = $tz =~ m/([+-])([0-9][0-9])([0-9][0-9])/o;
    if (defined($mdiff)) {
      if ($sign eq "-") { $hdiff *= -1; $mdiff *= -1; }
    } else {
      $hdiff = $mdiff = 0;
      if (defined($zoneconv{$tz})) {
	$hdiff = $zoneconv{$tz};
      } elsif ($tz =~ m/^[A-I]$/o) {
	$hdiff = -1 - (ord($tz) - ord('A'));
      } elsif ($tz =~ m/^[J-M]$/o) {
	$hdiff = -2 - (ord($tz) - ord('A'));
      } elsif ($tz =~ m/^[N-Y]$/o) {
	$hdiff = 1 + (ord($tz) - ord('N'));
      }
    }

    # need to catch 'die' calls in timegm for Perl5
    $time = eval '&timegm($sec,$min,$hour,$day,$mon,$year)';
    if (!defined($time)) { warn "$@\n"; return 0; }

    $time -= $hdiff*3600 - $mdiff*60;
    return $time;
  }
  warn "Invalid date string: $datestr\n";
  return 0;
}

sub local2time {
  local($day,$mon,$tmpyear,$hour,$tz) = @_;
  local($one,$two,$year);
  local($min,$sign,$hdiff,$mdiff,$time);

  $one = chop($tmpyear);  
  $two = chop($tmpyear);  
  $year = $two . $one;
  $mon = $month2num{$mon};

  ($hour,$min) = $hour =~ m/(\d+):(\d+)/o;

  ($tz = $tz) =~ tr/a-z/A-Z/;

  ($sign,$hdiff,$mdiff) = $tz =~ m/([+-])([0-9][0-9])([0-9][0-9])/o;
  if (defined($mdiff)) {
    if ($sign eq "-") { $hdiff *= -1; $mdiff *= -1; }
  } else {
    $hdiff = $mdiff = 0;
    if (defined($zoneconv{$tz})) {
      $hdiff = $zoneconv{$tz};
    } elsif ($tz =~ m/^[A-I]$/o) {
      $hdiff = -1 - (ord($tz) - ord('A'));
    } elsif ($tz =~ m/^[J-M]$/o) {
      $hdiff = -2 - (ord($tz) - ord('A'));
    } elsif ($tz =~ m/^[N-Y]$/o) {
      $hdiff = 1 + (ord($tz) - ord('N'));
    }
  }

  # need to catch 'die' calls in timegm for Perl5
  $time = eval '&timegm(0,$min,$hour,$day,$mon,$year)';
  if (!defined($time)) { warn "$@\n"; return 0; }

  $time -= $hdiff*3600 - $mdiff*60;
  return $time;
}

sub date2local {
  local($datestr) = @_;
  local($time,$sec,$min,$hour,$mday,$mon,$year,$wday,$clock);

  $time = &date2time($datestr);
  ($sec,$min,$hour,$mday,$mon,$year,$wday) = localtime($time);
  $clock = sprintf("%02d:%02d:%02d", $hour, $min, $sec);
  return "$num2day[$wday], $mday $num2month[$mon] 19$year $clock";
}

($sec,$min,$hour,$mday) = localtime(787320000);
($gmsec,$gmmin,$gmhour,$gmmday) = gmtime(787320000);
if ($hour - $gmhour < 0 ) {
  $localtz = sprintf("%03d%02d", $hour - $gmhour, $min - $gmmin);
} else {
  $localtz = sprintf("%02d%02d", $hour - $gmhour, $min - $gmmin);
}
