# raw.tcl
#----------------------------------------------------------------------------
# Copyright 1994 Siemens KWU Erlangen
# Permission to use, copy, modify, and distribute this documentation
# is hereby granted, provided that this copyright notice appears
# in all copies. This software is provided without any warranty, express
# or implied. Siemens KWU Erlangen makes no representations about the
# suitability of this software for any purpose.
#
# Author: Johan Lindbladh (tet90jl@tintin.hik.se)
#----------------------------------------------------------------------------
# This script generates a window with the  possibility to include a raw file.
#----------------------------------------------------------------------------

proc wrapraw {} {
destroy .raw
}

#---------------------------------------------------------------------------
#### proc includeraw ####
#---------------------------------------------------------------------------
proc includeraw {rawname contentname} {
global breakpoint
global currenttext
global winnumber
global includenum
global sumofwin
global currentwidgetnumber
global widgetname
global contenttype
global body
global description
global bg1 bg2 actbg bheight

set sumofwin [expr $sumofwin+1]
set includenum [expr $includenum+1]
# set breakpoint [[focus] index insert]
# set currenttext [focus]
set currentframe [split $currenttext .]
set part2 [lindex $currentframe 2]
set currentframe .[lindex $currentframe 1]
## Checks if cursor doesn't stand in an textfield, then the input will be first
if {$part2 !="text"} {
   set currenttext $widgetname(1)
   set currentframe [split $currenttext .]
   set currentframe .[lindex $currentframe 1]
   set breakpoint 1.0
   }
# Just for bugging

frame .f$includenum -background $bg1

#### if first position in the current textwidget

if {$breakpoint=="1.0"} {
   pack .f$includenum -fill both -side top -before $currentframe
   canvas .f$includenum.canvas -background $bg1 -relief raised -height 20
   pack .f$includenum.canvas -fill x
   updatesendlist $currentwidgetnumber($currenttext) $sumofwin
   set currentwidgetnumber(.f$includenum.canvas) \
        [expr $currentwidgetnumber($currenttext)-1]
   set widgetname($currentwidgetnumber(.f$includenum.canvas)) \
	.f$includenum.canvas
   set contenttype($currentwidgetnumber(.f$includenum.canvas)) \
        "\[SafeTcl_makebody \"$contentname\" "
   set body($currentwidgetnumber(.f$includenum.canvas)) \
        "\[exec mimencode -b $rawname\] base64\] "
   set description($currentwidgetnumber(.f$includenum.canvas)) \
        "rawfile : $rawname , $contentname"
   # # # # #
} else {
   pack .f$includenum -fill both -side top -after $currentframe
   text .f$includenum.text -relief raised -bd 2 -background $bg2 \
        -yscrollcommand ".f$includenum.scroll set" -height $bheight
   scrollbar .f$includenum.scroll  -relief flat  -background $bg2 -foreground \
        $bg2 -activeforeground $actbg -command ".f$includenum.text yview"
   pack .f$includenum.scroll -side right -fill y
   pack .f$includenum.text -expand yes -fill both
   .f$includenum.text insert 1.0 [ $currenttext get insert end]
   $currenttext delete insert end
   updatesendlist [expr $currentwidgetnumber($currenttext)+1] $sumofwin

   set currentwidgetnumber(.f$includenum.text) \
        [expr $currentwidgetnumber($currenttext)+1]
   set widgetname($currentwidgetnumber(.f$includenum.text)) .f$includenum.text
   set contenttype($currentwidgetnumber(.f$includenum.text)) \
        "\[SafeTcl_makebody \"text/plain\" "
   set body($currentwidgetnumber(.f$includenum.text)) \
        "\[.f$includenum.text get 1.0 end\]\] "
   set description($currentwidgetnumber(.f$includenum.text)) \
        "textfield"

   set sumofwin [expr $sumofwin+1]
   set includenum [expr $includenum+1]
   frame .f$includenum -background $bg1
   pack .f$includenum -fill both -side top -after $currentframe
   canvas .f$includenum.canvas -background $bg1 -relief raised -height 20
   pack .f$includenum.canvas -fill x

   set currentwidgetnumber(.f$includenum.canvas) [expr \
        $currentwidgetnumber($currenttext)+1]
   updatesendlist [expr $currentwidgetnumber($currenttext)+1] $sumofwin
   set widgetname($currentwidgetnumber(.f$includenum.canvas)) \
	.f$includenum.canvas
   set contenttype($currentwidgetnumber(.f$includenum.canvas)) \
        "\[SafeTcl_makebody \"$contentname\" "
   set body($currentwidgetnumber(.f$includenum.canvas)) \
        "\[exec mimencode -b $rawname\] base64\] "
   set description($currentwidgetnumber(.f$includenum.canvas)) \
        "rawfile : $rawname , $contentname"
   }
.f$includenum.canvas create text 1 10 -anchor w -text \
	"rawfile : $rawname , $contentname" 
destroy .raw
.butt.label configure -text "Including a raw file... done" -foreground #000000
}

#----------------------------------------------------------------------------

#### rawmenu ####
# shows what file you have selected and let you specify the Contenttype
#----------------------------------------------------------------------------
proc rawmenu {} {
global type
global numberoftype
global localname
global contentname
global rawname
global bg1 bg2 actbg

toplevel .raw
wm title .raw "A raw file"
wm iconname .raw "Raw"

label .raw.header1 -text "A raw file" -background $bg1 \
	-font "-*-helvetica-*-r-*-*-*-240-*-*-*-*-*-*" -foreground red
label .raw.header2 -text "Please give the following options" -background $bg1
pack .raw.header1 -side top -fill x
pack .raw.header2 -side top -fill x

frame .raw.f0 -background $bg2 -relief ridge -borderwidth 2
pack .raw.f0 -fill both
label .raw.f0.file -width 12 -text "File               :" -background $bg2
label .raw.f0.rawname -width 60  -background $bg2 -text $rawname -anchor w
pack .raw.f0.file -side left -anchor w
pack .raw.f0.rawname -side left

#----------------------------------------------------------------------------
# Pack the menu and entry for the Content
#----------------------------------------------------------------------------
frame .raw.f3 -background $bg2
pack .raw.f3 -fill both
menubutton .raw.f3.content -width 12 -text "Contenttype :" -background $bg1 \
	-activebackground $actbg -relief raised -anchor w -menu .raw.f3.content.m 
menu .raw.f3.content.m -background $bg1 -activebackground $actbg
for {set i 1} {$i <= $numberoftype} {incr i 1} {
  .raw.f3.content.m add command -label $type($i) -command \
	".raw.f3.contentname delete 0 end; .raw.f3.contentname \
        insert 0 $type($i)" -background $bg1 -activebackground $actbg
  }
entry .raw.f3.contentname -width 60 -relief sunken \
        -background $bg2 -textvariable contentname
pack .raw.f3.content -side left -anchor w
pack .raw.f3.contentname -side left

#----------------------------------------------------------------------------
# Button actions
#----------------------------------------------------------------------------
frame .raw.f2 -background $bg1
pack .raw.f2 -fill both
button .raw.f2.include -text Include -command {includeraw $rawname \
	$contentname} -background $bg1 -activebackground $actbg
button .raw.f2.quit -text Cancel -command "wrapraw; .butt.label configure \
	-text \"Including a raw file...cancelled\" -foreground #000000" \
	-background $bg1 -activebackground $actbg
button .raw.f2.listdir -text "New FSBox" -command {wrapraw;raw} \
	-background $bg1 -activebackground $actbg

pack .raw.f2.include .raw.f2.quit .raw.f2.listdir -side left -expand yes -pady 5

wm minsize . 1 1
grab .raw

#----------------------------------------------------------------------------
# bindings
#----------------------------------------------------------------------------
}

#---------------------------------------------------------------------------
#### proc raw ####
# Creates a FSBox with the label Select a rawfile
#---------------------------------------------------------------------------
proc raw {} {
global fsBoxMessage
global rawname

.butt.label configure -text "Including a raw file..." -foreground #3d55ff 
set fsBoxMessage "Select a rawfile"
set rawname [FSBox]
if [file isfile $rawname] {
   rawmenu 
   }
}
