# textbody.tcl
#----------------------------------------------------------------------------
# Copyright 1994 Siemens KWU Erlangen
# Permission to use, copy, modify, and distribute this documentation
# is hereby granted, provided that this copyright notice appears
# in all copies. This software is provided without any warranty, express
# or implied. Siemens KWU Erlangen makes no representations about the
# suitability of this software for any purpose.
#
# Author: Johan Lindbladh (tet90jl@tintin.hik.se)
#----------------------------------------------------------------------------
# This script includes a new empty bodytext
#----------------------------------------------------------------------------

#----------------------------------------------------------------------------
#### proc textbody ####
#----------------------------------------------------------------------------

proc textbody  {} {
global breakpoint
global currenttext
global winnumber
global includenum
global sumofwin
global currentwidgetnumber
global widgetname
global contenttype
global body
global description
global bg1 bg2 actbg bheight

set sumofwin [expr $sumofwin+1]
set includenum [expr $includenum+1]
set currentframe [split $currenttext .]
set part2 [lindex $currentframe 2]
set currentframe .[lindex $currentframe 1]
## Checks if cursor doesn't stand in an textfield, the input will be first
if {$part2 !="text"} {
  set currenttext $widgetname(1)
  set currentframe [split $currenttext .]
  set currentframe .[lindex $currentframe 1]
  set breakpoint 1.0
  }
frame .f$includenum -background $bg1
#### if first position in the current textwidget
if {$breakpoint=="1.0"} {
  pack .f$includenum -fill both -side top -before $currentframe
  text .f$includenum.text -relief raised -bd 2 -background $bg2 \
	-yscrollcommand ".f$includenum.scroll set" -height $bheight
  scrollbar .f$includenum.scroll -relief flat -background $bg2 \
        -foreground  $bg2 -activeforeground $actbg \
        -command ".f$includenum.text yview"
  pack .f$includenum.scroll -side right -fill y
  pack .f$includenum.text -expand yes -fill both
  updatesendlist $currentwidgetnumber($currenttext) $sumofwin
  set currentwidgetnumber(.f$includenum.text) \
        [expr $currentwidgetnumber($currenttext)-1]
  set widgetname($currentwidgetnumber(.f$includenum.text)) \
        .f$includenum.text
  set contenttype($currentwidgetnumber(.f$includenum.text)) \
	"\[SafeTcl_makebody \"text/plain\" "
  set description($currentwidgetnumber(.f$includenum.text)) \
	"textfield"
  set body($currentwidgetnumber(.f$includenum.text)) \
        "\[.f$includenum.text get 1.0 end\]\] "
} else {
   pack .f$includenum -fill both -side top -after $currentframe
   text .f$includenum.text -relief raised -bd 2 -background $bg2 \
	-yscrollcommand ".f$includenum.scroll set" -height $bheight
   scrollbar .f$includenum.scroll -relief flat -background $bg2 -foreground \
        $bg2 -activeforeground $actbg -command ".f$includenum.text yview"
   pack .f$includenum.scroll -side right -fill y
   pack .f$includenum.text -expand yes -fill both
   .f$includenum.text insert 1.0 [ $currenttext get insert end]
   $currenttext delete insert end
   updatesendlist [expr $currentwidgetnumber($currenttext)+1] $sumofwin

   set currentwidgetnumber(.f$includenum.text) \
        [expr $currentwidgetnumber($currenttext)+1]
   set widgetname($currentwidgetnumber(.f$includenum.text)) .f$includenum.text
   set contenttype($currentwidgetnumber(.f$includenum.text)) \
       "\[SafeTcl_makebody \"text/plain\" "
   set body($currentwidgetnumber(.f$includenum.text)) \
        "\[.f$includenum.text get 1.0 end\]\] "
   set description($currentwidgetnumber(.f$includenum.text)) \
        "textfield"
   set sumofwin [expr $sumofwin+1]
   set includenum [expr $includenum+1]
   frame .f$includenum -background $bg1
   pack .f$includenum -fill both -side top -after $currentframe

   text .f$includenum.text -relief raised -bd 2 -background $bg2 \
	-yscrollcommand ".f$includenum.scroll set" -height $bheight
   scrollbar .f$includenum.scroll -relief flat -background $bg2 \
        -foreground  $bg2 -activeforeground $actbg \
        -command ".f$includenum.text yview"
   pack .f$includenum.scroll -side right -fill y
   pack .f$includenum.text -expand yes -fill both
   set currentwidgetnumber(.f$includenum.text) \
        [expr $currentwidgetnumber($currenttext)+1]
   updatesendlist [expr $currentwidgetnumber($currenttext)+1] $sumofwin
   set widgetname($currentwidgetnumber(.f$includenum.text)) \
        .f$includenum.text
   set contenttype($currentwidgetnumber(.f$includenum.text)) \
        "\[SafeTcl_makebody \"text/plain\" "
   set description($currentwidgetnumber(.f$includenum.text)) \
        "textfield"
   set body($currentwidgetnumber(.f$includenum.text)) \
        "\[.f$includenum.text get 1.0 end\]\] "
   }
.butt.label configure -text "Including a textbody...done" -foreground #000000
}
