/*  _ __ ___ _
 * | |\ /  /| |  $Id: CdlItem.C,v 1.10 1995/07/24 10:10:11 deans Exp $
 * | | /  / | |  Copyright (C) 1995 IXI Limited.
 * |_|/__/_\|_|  IXI Limited, Cambridge, England.
 *
 * Component   : CdlItem.C
 *
 * Author      : Dean Sheehan (deans@x.co.uk)
 *
 * Description : Contains the implementation for CdlClass and CdlPass, the two
 *               top level entities within a CDL file.
 *
 * License     :
			Object Tcl License & Copyright
			------------------------------

IXI Object Tcl software, both binary and source (hereafter, Software) is copyrighted by IXI Limited (IXI), and ownership remains with IXI. 

IXI grants you (herafter, Licensee) a license to use the Software for academic, research and internal business purposes only, without a fee. Licensee may distribute the binary and source code (if required) to third parties provided that the copyright notice and this statement appears on all copies and that no charge is associated with such copies. 

Licensee may make derivative works. However, if Licensee distributes any derivative work based on or derived from the Software, then Licensee will (1) notify IXI regarding its distribution of the derivative work, and (2) clearly notify users that such derivative work is a modified version and not the original IXI Object Tcl distributed by IXI. IXI strongly recommends that Licensee provide IXI the right to incorporate such modifications into future releases of the Software under these license terms. 

Any Licensee wishing to make commercial use of the Software should contact IXI, to negotiate an appropriate license for such commercial use. Commercial use includes (1) integration of all or part of the source code into a product for sale or license by or on behalf of Licensee to third parties, or (2) distribution of the binary code or source code to third parties that need it to utilize a commercial product sold or licensed by or on behalf of Licensee. 

IXI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. IXI SHALL NOT BE LIABLE FOR ANY DAMAGES WHATSOEVER SUFFERED BY THE USERS OF THIS SOFTWARE. 

Copyright (C) 1995, IXI Limited 

By using or copying this Software, Licensee agrees to abide by the copyright law and all other applicable laws of England and the U.S., including, but not limited to, export control laws, and the terms of this license. IXI shall have the right to terminate this license immediately by written notice upon Licensee's breach of, or non-compliance with, any of its terms. Licensee may be held legally responsible for any copyright infringement that is caused or encouraged by Licensee's failure to abide by the terms of this license. 

Comments and questions are welcome and can be sent to
otcl@x.co.uk 

For more information on copyright and licensing issues, contact: 
Legal Department, IXI Limited, Vision Park, Cambridge CB4 4ZR,
ENGLAND. 

 *
 */

// System Includes
#include <string.h>
#include <stdlib.h>

// Tcl Includes

// Local Includes
#include "CdlItem.H"
#include "CdlMethod.H"
#include "CdlFile.H"

CdlIndent::CdlIndent (int n)
{
   spaces = TAB * n;
}

CdlIndent &CdlIndent::operator ++ (int)
{
   spaces += TAB;
   return *this;
}

CdlIndent &CdlIndent::operator ++ ()
{
   spaces += TAB;
   return *this;
}

CdlIndent &CdlIndent::operator -- (int)
{
   spaces -= TAB;
   return *this;
}

CdlIndent &CdlIndent::operator -- ()
{
   spaces -= TAB;
   return *this;
}

ofstream &operator << (ofstream &o, CdlIndent &c)
{
   for (int i = 0; i < c.spaces; i++)
   {
      o << " ";
   }
   return o;
}

CdlItem::CdlItem ()
{
}

CdlItem::~CdlItem ()
{
}

CdlPass::CdlPass (char *l)
{
   pos = HEADER_AND_SOURCE;

   if (*l == '\n')
   {
      l++;
   }
   line = strdup(l);
   if (line[strlen(line) - 1] == '\n')
   {
      line[strlen(line) - 1] = NULL;
   }
}

CdlPass::CdlPass (char *p, char *l)
{
   pos = HEADER_AND_SOURCE;

   if (strcmp(p,"-h") == 0)
   {
      pos = HEADER;
   }
   else if (strcmp(p,"-s") == 0)
   {
      pos = SOURCE;
   }

   if (*l == '\n')
   {
      l++;
   }
   line = strdup(l);
   if (line[strlen(line) - 1] == '\n')
   {
      line[strlen(line) - 1] = NULL;
   }
}

CdlPass::~CdlPass ()
{
   free(line);
}

int CdlPass::genHeader (ofstream &o)
{
   if (pos == HEADER || pos == HEADER_AND_SOURCE)
   {
      o << line << endl;
   }
   return 0;
}

int CdlPass::genSource (ofstream &o)
{
   if (pos == SOURCE || pos == HEADER_AND_SOURCE)
   {
      o << line << endl;
   }
   return 0;
}

CdlClass::CdlClass (char *n, int noOfS, char *s[])
{
   name = strdup(n);
   noOfInstanceMethods = 0;
   noOfClassMethods = 0;
   constructor = NULL;
   noOfSuperclasses = noOfS;
   superclasses = s;
}

CdlClass::~CdlClass ()
{
   free(name);
   if (constructor != NULL)
   {
      delete constructor;
   }
   int m;
   for (m = 0; m < noOfInstanceMethods; m++)
   {
      delete instanceMethod[m];
   }
   for (m = 0; m < noOfClassMethods; m++)
   {
      delete classMethod[m];
   }
   if (noOfSuperclasses != 0)
   {
      free(superclasses);
   }
}

char *CdlClass::giveName (void)
{
   return name;
}

void CdlClass::addInstanceMethod (CdlInstanceMethod *m)
{
   instanceMethod[noOfInstanceMethods] = m;
   noOfInstanceMethods++;
}

void CdlClass::addClassMethod (CdlClassMethod *m)
{
   classMethod[noOfClassMethods] = m;
   noOfClassMethods++;
}

void CdlClass::setConstructor (CdlConstructor *c)
{
   constructor = c;
}

CdlConstructor *CdlClass::getConstructor (void)
{
   return constructor;
}

int CdlClass::genHeader (ofstream &o)
{
   genOtclClassDec(o);
   o << endl;
   genOtclPartDec(o);
   o << endl;

   return 1;
}

int CdlClass::genSource (ofstream &o)
{
   genOtclClassDef(o);
   o << endl;
   genOtclPartDef(o);
   o << endl;
   return 1;
};

void CdlClass::genOtclClassDec (ofstream &o)
{
   CdlIndent tab(1);

   o << "class " << name << OTCL_CLASS_SUFFIX << " : public OtclClassCpp"<<endl;
   o << "{" << endl;
   o << "public:" << endl;
   o << tab << name << OTCL_CLASS_SUFFIX << " ();" << endl;
   o << tab << "OtclPart *instantiatePart (Tcl_Interp *, int *, int," << endl;
   o << tab << "                           char *[], OtclObject *," << endl;
   o << tab << "                           OtclPart **partPtr);" << endl;
   o << tab << "static " << name << OTCL_CLASS_SUFFIX << " instance;" << endl;
   o << tab << "int classMethod (Tcl_Interp *, int, char *[]); " << endl;
   o << "};" << endl;
}

void CdlClass::genOtclClassDef (ofstream &of)
{
   CdlIndent tab(1);

   // Static Attribute Definition
   of << name << OTCL_CLASS_SUFFIX << " " << name << OTCL_CLASS_SUFFIX
      << "::instance;" << endl;

   of << endl;

   // Constructor Definition
   of << name << OTCL_CLASS_SUFFIX << "::" << name << OTCL_CLASS_SUFFIX
      << " () : ";
   of << "OtclClassCpp(\"" << name << "\") {}" << endl;

   of << endl;

   // ::instatntiatePart(...)
   of << "OtclPart *" << name << OTCL_CLASS_SUFFIX << "::instantiatePart (" 
      << "Tcl_Interp *i," << endl;
   of << tab << "int *returnCode, int argc," << endl;
   of << tab << "char *argv[], OtclObject *o," << endl;
   of << tab << "OtclPart **partPtr)" << endl;
   of << "{" << endl;

   of << tab << "if (argc != " << constructor->getNoOfArgs() << ")" << endl;
   of << tab << "{" << endl;
   tab++;
   of << tab << "*returnCode = TCL_ERROR;" << endl;
   of << tab << "Otcl::setTclResult(i,ARGS_METHOD_ERR,\"constructor\","
      << "\"" << name << "\");" << endl;
   of << tab << "return NULL;" << endl;
   tab--;
   of << tab << "}" << endl;

// Exception if argc no enough

   constructor->preProcessArgs(of,tab);
 
   of << tab << "OtclPart *res = new " << name << OTCL_PART_SUFFIX << " (";

   constructor->passArgs(of,"o");

   of << ");" << endl;

   constructor->postProcessArgs(of,tab);

   of << tab << "*partPtr = res;" << endl;
   
   of << tab << "return res;" << endl; 

   of << "}" << endl;

   of << endl;

   // classMethod

   of << "int " << name << OTCL_CLASS_SUFFIX << "::classMethod ("
      << "Tcl_Interp *i, int argc, char *argv[])" << endl;
   of << "{" << endl;
   for (int m = 0; m < noOfClassMethods; m++)
   {
      classMethod[m]->executeBinding(name,of,tab);
      of << endl;
   }
   of << tab << "Otcl::setTclResult(i,CLASS_METHOD_NOT_FOUND_ERR,"
      << "argv[1],\"" << name << "\");" << endl;
   of << tab << "return TCL_ERROR;" << endl;
   of << "}" << endl;
}

void CdlClass::genOtclPartDec (ofstream &of)
{
   of << "class " << name << OTCL_PART_SUFFIX << " : public OtclPartCpp, "
      << "public " << name << endl;
   of << "{" << endl;
   of << "public:" << endl;

   constructor->genDec(of);

   of << endl;

   // Copy constructor:
   of << "   " << name << OTCL_PART_SUFFIX << "(const " << name << " &);"
      << endl;

   of << "   ~" << name << OTCL_PART_SUFFIX << " ();" << endl;

   for (int m = 0; m < noOfInstanceMethods; m++)
   {
      if (instanceMethod[m]->isDynamic())
      {
         instanceMethod[m]->genDec(of);
      }
   }

   of << "   char *giveClassName (void);" << endl;
   of << "   int executeMethod (Tcl_Interp *, char *, int, char *[], int*);" 
      << endl;
   of << "   int discardPart (Tcl_Interp *, int);" << endl;
   of << "   void *toCpp (char *);" << endl;

   of << "};" << endl;
}

void CdlClass::genOtclPartDef (ofstream &of)
{
   // Constructor from OTCL instantiation
   of << name << OTCL_PART_SUFFIX << "::" << name << OTCL_PART_SUFFIX << " (";

   constructor->defineArgs(of);

   of << ") :" << endl;
   of << "   " << name << "(";

   constructor->passArgsUpwards(of);

   of << ")," << endl;

   // Arg pass to parent classes
   of << "   OtclPartCpp(o) {}" << endl;

   of << endl;

   // Copy constructor
   of << name << OTCL_PART_SUFFIX << "::" << name << OTCL_PART_SUFFIX << " (";
   of << "const " << name << " &obj) :" << endl;
   of << "   " << name << "(obj)," << endl;
   of << "    OtclPartCpp(NULL)" << endl;
   of << "{" << endl;
   of << "}" << endl;
   

   // Destructor
   of << name << OTCL_PART_SUFFIX << "::~" << name << OTCL_PART_SUFFIX 
      << "()" << endl;
   of << "{" << endl;
   of << "   if (!owner->discardingParts())" << endl;
   of << "   {" << endl;
   of << "      Otcl::otclPtr->discard(Otcl::tclInterp,owner->getSelf(),"
      << "OTCL_TRUE);" << endl;
   of << "   }" << endl;
   of << "}" << endl;

   of << endl;

   // giveClassName
   of << "char *" << name << OTCL_PART_SUFFIX << "::giveClassName (void)" << endl;
   of << "{" << endl;
   of << "   return \"" << name << "\";" << endl;
   of << "}" << endl;

   // discardPart
   of << "int " << name << OTCL_PART_SUFFIX
      << "::discardPart (Tcl_Interp *, int fromCpp)" << endl;
   of << "{" << endl;
   of << "   if (fromCpp == OTCL_TRUE) return TCL_OK;" << endl;
   of << "   delete this;" << endl;
   of << "   return TCL_OK;" << endl;
   of << "}" << endl;

   of << endl;

   // toCpp
   of << "void *" << name << OTCL_PART_SUFFIX
      << "::toCpp (char *cppClassName)" << endl;
   of << "{" << endl;

   of << "   if (strcmp(cppClassName,\"" << name << "\") == 0)" << endl;
   of << "   {" << endl;
   of << "      return (void*)((" << name << "*)this);" << endl;
   of << "   }" << endl;

   for (int s = 0; s < noOfSuperclasses; s++)
   {
      of << "   if (strcmp(cppClassName,\"" << superclasses[s] << "\") == 0)"
         << endl;
      of << "   {" << endl;
      of << "      return (void*)((" << superclasses[s] << "*)this);" << endl;
      of << "   }" << endl;
   } 

   of << "   return NULL;" << endl;
   of << "}" << endl;

   of << endl;

   // executeMethod
   of << "int " << name << OTCL_PART_SUFFIX << "::executeMethod (Tcl_Interp *i,"
      << " char *mName, int argc," << endl;
   of << "         char *argv[], int *found)" << endl;
   of << "{" << endl;

   int m;
   for (m = 0; m < noOfInstanceMethods; m++)
   {
      instanceMethod[m]->executeBinding(name,of);
      of << endl;
   }

   of << "   *found = OTCL_FALSE;" << endl;
   of << "   return TCL_OK;" << endl;
   of << "}" << endl;

   // Dynamic method definitions
   for (m = 0; m < noOfInstanceMethods; m++)
   {
      if (instanceMethod[m]->isDynamic())
      {
         of << endl;
         instanceMethod[m]->genDef(name,of);
      }
   }
}

