#ifndef CDL_METHOD_H
#define CDL_METHOD_H

/*  _ __ ___ _
 * | |\ /  /| |  $Id: CdlMethod.H,v 1.4 1995/06/16 13:03:55 deans Exp $
 * | | /  / | |  Copyright (C) 1995 IXI Limited.
 * |_|/__/_\|_|  IXI Limited, Cambridge, England.
 *
 * Component   : CdlMethod.H
 *
 * Author      : Dean Sheehan (deans@x.co.uk)
 *  
 * Description : Header file for CdlMethod class that models methods in the
 *               CDL input file.
 *
 * License     :
			Object Tcl License & Copyright
			-----------------------------

IXI Object Tcl software, both binary and source (hereafter, Software) is copyrighted by IXI Limited (IXI), and ownership remains with IXI. 

IXI grants you (herafter, Licensee) a license to use the Software for academic, research and internal business purposes only, without a fee. Licensee may distribute the binary and source code (if required) to third parties provided that the copyright notice and this statement appears on all copies and that no charge is associated with such copies. 

Licensee may make derivative works. However, if Licensee distributes any derivative work based on or derived from the Software, then Licensee will (1) notify IXI regarding its distribution of the derivative work, and (2) clearly notify users that such derivative work is a modified version and not the original IXI Object Tcl distributed by IXI. IXI strongly recommends that Licensee provide IXI the right to incorporate such modifications into future releases of the Software under these license terms. 

Any Licensee wishing to make commercial use of the Software should contact IXI, to negotiate an appropriate license for such commercial use. Commercial use includes (1) integration of all or part of the source code into a product for sale or license by or on behalf of Licensee to third parties, or (2) distribution of the binary code or source code to third parties that need it to utilize a commercial product sold or licensed by or on behalf of Licensee. 

IXI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. IXI SHALL NOT BE LIABLE FOR ANY DAMAGES WHATSOEVER SUFFERED BY THE USERS OF THIS SOFTWARE. 

Copyright (C) 1995, IXI Limited 

By using or copying this Software, Licensee agrees to abide by the copyright law and all other applicable laws of England and the U.S., including, but not limited to, export control laws, and the terms of this license. IXI shall have the right to terminate this license immediately by written notice upon Licensee's breach of, or non-compliance with, any of its terms. Licensee may be held legally responsible for any copyright infringement that is caused or encouraged by Licensee's failure to abide by the terms of this license. 

Comments and questions are welcome and can be sent to
otcl@x.co.uk 

For more information on copyright and licensing issues, contact: 
Legal Department, IXI Limited, Vision Park, Cambridge CB4 4ZR,
ENGLAND. 

 *
 */

// System Includes
#include <fstream.h>

// Local Includes
#include "CdlItem.H"

// Forward Class Declarations
class CdlArg;
class CdlRtn;

// Public Defines
#define MAX_ARGS 20

class CdlMethod
{
public: // Public Enumerations

   enum Binding {STATIC, DYNAMIC, ABSTRACT};

public: // Public Constructor & Destructor

   CdlMethod (char *name);

   virtual ~CdlMethod ();

public: // Public Instance Methods

   void addArg (CdlArg *m);

   void setRtn (CdlRtn *r);
   CdlRtn *getRtn (void);

   int isPublic (void);

   void setVoidReturn (void);
   int returnIsVoid (void);

   void setVoidArgs (void);
   int argsAreVoid (void);

   int getNoOfArgs (void);

protected:  // Private Instance Attributes

   CdlArg *arg[MAX_ARGS];
   int noOfArgs;

   CdlRtn *rtn;

   char *name;

   int voidReturn;
   int voidArgs;
};

class CdlInstanceMethod : public CdlMethod
{
public:

   CdlInstanceMethod (char *name);

   ~CdlInstanceMethod ();

   void setBinding (Binding b);

   void genDec (ofstream &);

   void genDef (char *className, ofstream &);

   int isDynamic (void);

   void executeBinding (char *className, ofstream &);

private:  // Private Instance Attributes

   Binding binding;
};

class CdlClassMethod : public CdlMethod
{
public:

   CdlClassMethod (char *name);

   ~CdlClassMethod ();

   void executeBinding(char *className, ofstream &, CdlIndent);
};

class CdlConstructor : public CdlMethod
{
public:

   CdlConstructor (char *name);

   ~CdlConstructor ();

   void genDec (ofstream &);

   void defineArgs (ofstream &);
   void passArgsUpwards (ofstream &);

   void preProcessArgs (ofstream &, CdlIndent);
   void passArgs (ofstream &, char *lastArg);
   void postProcessArgs (ofstream &, CdlIndent);

};

#endif // CDL_METHOD
