/*  _ __ ___ _
 * | |\ /  /| |  $Id: OtclAttribute.C,v 1.6 1995/05/09 16:14:20 deans Exp $
 * | | /  / | |  Copyright (C) 1995 IXI Limited.
 * |_|/__/_\|_|  IXI Limited, Cambridge, England.
 *
 * Component   : OtclAttribute.C
 *
 * Author      : Dean Sheehan (deans@x.co.uk)
 *
 * Description : Contains the implementation of OtclAttribute and 
 *               OtclAttributeTemplate classes that model attributes on classes
 *               in Object Tcl.
 *
 * License     :
			Object Tcl License & Copyright
			------------------------------

IXI Object Tcl software, both binary and source (hereafter, Software) is copyrighted by IXI Limited (IXI), and ownership remains with IXI. 

IXI grants you (herafter, Licensee) a license to use the Software for academic, research and internal business purposes only, without a fee. Licensee may distribute the binary and source code (if required) to third parties provided that the copyright notice and this statement appears on all copies and that no charge is associated with such copies. 

Licensee may make derivative works. However, if Licensee distributes any derivative work based on or derived from the Software, then Licensee will (1) notify IXI regarding its distribution of the derivative work, and (2) clearly notify users that such derivative work is a modified version and not the original IXI Object Tcl distributed by IXI. IXI strongly recommends that Licensee provide IXI the right to incorporate such modifications into future releases of the Software under these license terms. 

Any Licensee wishing to make commercial use of the Software should contact IXI, to negotiate an appropriate license for such commercial use. Commercial use includes (1) integration of all or part of the source code into a product for sale or license by or on behalf of Licensee to third parties, or (2) distribution of the binary code or source code to third parties that need it to utilize a commercial product sold or licensed by or on behalf of Licensee. 

IXI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. IXI SHALL NOT BE LIABLE FOR ANY DAMAGES WHATSOEVER SUFFERED BY THE USERS OF THIS SOFTWARE. 

Copyright (C) 1995, IXI Limited 

By using or copying this Software, Licensee agrees to abide by the copyright law and all other applicable laws of England and the U.S., including, but not limited to, export control laws, and the terms of this license. IXI shall have the right to terminate this license immediately by written notice upon Licensee's breach of, or non-compliance with, any of its terms. Licensee may be held legally responsible for any copyright infringement that is caused or encouraged by Licensee's failure to abide by the terms of this license. 

Comments and questions are welcome and can be sent to
otcl@x.co.uk 

For more information on copyright and licensing issues, contact: 
Legal Department, IXI Limited, Vision Park, Cambridge CB4 4ZR,
ENGLAND. 

 *
 */

// Tcl Includes
#include <tclInt.h>

// Local Includes
#include "Otcl.H"
#include "OtclAttribute.H"


// Constructor for OtclAttribute class.
// hashEntry is the Tcl_HashEntry * that this attribute is owned bye.
OtclAttribute::OtclAttribute (Tcl_HashEntry *hashEntry, int isArray,
                              char *initialiser, Tcl_Interp *interp)
{
   var = new Var;
   var->flags = (isArray == OTCL_TRUE) ? VAR_ARRAY : 0;
   var->searchPtr = NULL;
   var->tracePtr = NULL;
   var->refCount = 0;
   var->hPtr = hashEntry;

   if (isArray)
   {
      var->value.tablePtr = new Tcl_HashTable;
      Tcl_InitHashTable(var->value.tablePtr,TCL_STRING_KEYS);

      if (initialiser != NULL)
      {
         // break initialiser down into list of pairs
         int argc;
         char **argv;
         if (Tcl_SplitList(interp,initialiser,&argc,&argv) == TCL_OK)
         {
            int innerArgc;
            char **innerArgv;
            Var *v;
            int newEntry;
            Tcl_HashEntry *hentry;
            for (int index = 0; index < argc; index++)
            {
               if (Tcl_SplitList(interp,argv[index],&innerArgc,&innerArgv) ==
                   TCL_OK)
               {
                  if (innerArgc == 2)
                  {
                     v = new Var;
                     hentry = Tcl_CreateHashEntry(var->value.tablePtr,
                                                  innerArgv[0],
                                                  &newEntry);
                     if (newEntry)
                     {
                        Tcl_SetHashValue(hentry,v);
                     }    
                     else
                     {
                        free((char*)v->value.string);
                        delete v;
                     }
                     v->flags = 0;
                     v->searchPtr = NULL;
                     v->tracePtr = NULL;
                     v->refCount = 0;
                     v->hPtr = hentry;
                     v->valueLength = strlen(innerArgv[1]);
                     v->value.string = strdup(innerArgv[1]);
                     v->valueSpace = v->valueLength;
         
                  }
                  free((char*)innerArgv);
               }
            }
            free((char*)argv);
         }
      }
   }  
   else
   {
      if (initialiser == NULL)
      {
         var->valueLength = 1;  
         var->value.string = strdup("");
      }
      else
      {
         var->valueLength = strlen(initialiser);
         var->value.string = strdup(initialiser);
      }
      var->valueSpace = var->valueLength;
   } 
}

OtclAttribute::~OtclAttribute ()
{
    if (var->valueSpace != 0)
    {
       free(var->value.string);
       var->valueSpace = 0;
       var->valueLength = 0;
    }
    delete var;
}

OtclAttribute::operator Var * ()
{
   return var;
}

OtclAttributeTemplate::OtclAttributeTemplate (Tcl_Interp *, int array, char *i)
{
   if (i == NULL)
   {
      initialiser = NULL;
   }
   else
   {
      initialiser = strdup(i);
   }
   isArray = array;
}

OtclAttributeTemplate::~OtclAttributeTemplate ()
{
   if (initialiser != NULL)
   {
      free (initialiser);
   }
}

OtclAttribute *OtclAttributeTemplate::instantiate (Tcl_Interp *interp, 
                                                   Tcl_HashEntry *hashEntry)
{
   return new OtclAttribute(hashEntry,isArray,initialiser,interp);
}
