#ifndef OTCL_ERROR_H
#define OTCL_ERROR_H

/*  _ __ ___ _
 * | |\ /  /| |  $Id: OtclError.H,v 1.6 1995/06/16 13:04:04 deans Exp $
 * | | /  / | |  Copyright (C) 1995 IXI Limited.
 * |_|/__/_\|_|  IXI Limited, Cambridge, England.
 *
 * Component   : OtclError.H
 *
 * Author      : Dean Sheehan (deans@x.co.uk)
 *  
 * Description : Contains the #defines for all of the error strings
 *
 * License     :
			Object Tcl License & Copyright
			-----------------------------

IXI Object Tcl software, both binary and source (hereafter, Software) is copyrighted by IXI Limited (IXI), and ownership remains with IXI. 

IXI grants you (herafter, Licensee) a license to use the Software for academic, research and internal business purposes only, without a fee. Licensee may distribute the binary and source code (if required) to third parties provided that the copyright notice and this statement appears on all copies and that no charge is associated with such copies. 

Licensee may make derivative works. However, if Licensee distributes any derivative work based on or derived from the Software, then Licensee will (1) notify IXI regarding its distribution of the derivative work, and (2) clearly notify users that such derivative work is a modified version and not the original IXI Object Tcl distributed by IXI. IXI strongly recommends that Licensee provide IXI the right to incorporate such modifications into future releases of the Software under these license terms. 

Any Licensee wishing to make commercial use of the Software should contact IXI, to negotiate an appropriate license for such commercial use. Commercial use includes (1) integration of all or part of the source code into a product for sale or license by or on behalf of Licensee to third parties, or (2) distribution of the binary code or source code to third parties that need it to utilize a commercial product sold or licensed by or on behalf of Licensee. 

IXI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. IXI SHALL NOT BE LIABLE FOR ANY DAMAGES WHATSOEVER SUFFERED BY THE USERS OF THIS SOFTWARE. 

Copyright (C) 1995, IXI Limited 

By using or copying this Software, Licensee agrees to abide by the copyright law and all other applicable laws of England and the U.S., including, but not limited to, export control laws, and the terms of this license. IXI shall have the right to terminate this license immediately by written notice upon Licensee's breach of, or non-compliance with, any of its terms. Licensee may be held legally responsible for any copyright infringement that is caused or encouraged by Licensee's failure to abide by the terms of this license. 

Comments and questions are welcome and can be sent to
otcl@x.co.uk 

For more information on copyright and licensing issues, contact: 
Legal Department, IXI Limited, Vision Park, Cambridge CB4 4ZR,
ENGLAND. 

 *
 */

// Error Messages

#define ARGS_CLASS_INTERFACE_ERR "wrong # args: should be \"otclInterface className ?-isA classList? body\""

#define ARGS_CLASS_IMPLEMENTATION_ERR "wrong # args: should be \"otclImplementation className body\""

#define ARGS_INSTANTIATE_ERR "wrong # args: should be \"otclNew className args\""

#define ARGS_DISCARD_ERR "wrong # args: should be \"otclDelete object\""

#define ARGS_METHOD_INTERFACE_ERR "wrong # args: should be \"method name args\""

#define ARGS_CLASS_METHOD_INTERFACE_ERR "wrong # args: should be \"classMethod name args\""

#define ARGS_CONSTRUCTOR_INTERFACE_ERR "wrong # args: should be \"constructor args\""

#define ARGS_METHOD_IMPLEMENTATION_ERR "wrong # args: should be \"method name args body\""

#define ARGS_CLASS_METHOD_IMPLEMENTATION_ERR "wrong # args: should be \"classMethod name args body\""

#define ARGS_CONSTRUCTOR_IMPLEMENTATION_ERR "wrong # args: should be \"constructor args parentConstructors body\""

#define ARGS_DESTRUCTOR_ERR "wrong # args: should be \"destructor body\""

#define ARGS_ATTRIBUTE_ERR "wrong # args: should be \"attribute name ?initial?\""

#define ARGS_CLASS_ATTRIBUTE_ERR "wrong # args: should be \"classAttribute name initial\""

#define ARGS_CLASS_METHOD_EXE_ERR "wrong # args: should be \"className method args\""

#define ARGS_METHOD_EXE_ERR "wrong # args: should be \"object method ?args?\""

#define ARGS_OTCL_ERR "wrong # args: should be \"otcl command ...\""

#define CLASS_ALREADY_INTERFACED_ERR "Class \"%s\" already declared."

#define CLASS_IMP_BEFORE_INT_ERR "Class \"%s\" interface has not been declared."

#define CLASS_UNDEFINED_ERR "Class \"%s\" is undefined."

#define METHOD_INTERFACE_DUPLICATED_ERR "Method \"%s\" duplicated in interface for class \"%s\"."

#define TOO_MANY_SUPERCLASSES_ERR "Too many superclasses specified in interface for class \"%s\". Maximum is %d."

#define SUPERCLASS_NOT_KNOWN_ERR "Class \"%s\" interface specified an unknown class, \"%s\", as one of its superclasses."

#define CONSTRUCTOR_NOT_INTERFACED_ERR "Constructor for class \"%s\" must be specified in interface."

#define SYNTAX_ERROR_IN_FORMAL_ARG_ERR "Syntax error in formal argument %d for method \"%s\". Formal argument specification is \"%s\"."

#define DUP_CONSTRUCTOR_ERR "Duplication of parent construction parameters for class \"%s\" from constructor of class \"%s\"."

#define DIFF_NO_OF_FORMAL_ARGS_IN_SPECS_ERR "Method \"%s\" has different number of arguments specified in its interface and implementation."

#define PUBLIC_IMP_DEFAULT_FORMAL_ARGS_ERR "Method \"%s\" has default values specified for formal arguments in its implementation. Can only specify defaults in interface if method is public."

#define BODY_ALREADY_SPECIFIED_ERR "Method \"%s\" implementated twice."

#define SYNTAX_ERROR_PARENT_CONSTRUCTOR_ERR "Syntax error in parent constructor \"%s\" in constructor of class \"%s\"."

#define PARENT_CONSTRUCTOR_UNKNOWN_CLASS_ERR "Constructor of class \"%s\" has specified an unknown class, \"%s\", in its parent construction specifier."

#define DESTRUCTOR_CANNOT_HAVE_ARGS_ERR "Destructor for class \"%s\" specifies formal arguments."

#define INST_ATTRIB_CLASH_ERR "Instance attribute \"%s\" in class \"%s\" clashes with another instance attribute of the same name."

#define CLASS_ATTRIB_CLASH_ERR "Class attribute \"%s\" in class \"%s\" clashes with another class attribute of the same name."

#define CLASS_ATTRIB_CLASH_INST_ERR "Class attribute \"%s\" in class \"%s\" clashes with an instance attribute of the same name."

#define INST_ATTRIB_CLASH_CLASS_ERR "Instance attribute \"%s\" in class \"%s\" clashes with a class attribute of the same name."

#define SUPERCLASS_DUPLICATION_ERR "Class \"%s\" is specified as a superclass of class \"%s\" twice."

#define COULDNT_MANAGE_OBJECT_ERR "Couldn't manage the new instance of class \"%s\"."

#define UNKNOWN_OBJECT_ERR "Object (%s) unknown."

#define FORMAL_ARG_HAS_NO_DEFAULT_ERR "Formal argument \"%s\" has no default value but not enough actual aguments."

#define BREAK_NOT_IN_LOOP_ERR "Break used outside of a loop."

#define CONTINUE_NOT_IN_LOOP_ERR "Continue used outside of a loop."

#define CALLING_INFO_ERR "\n    (method \"%.50s\" line %d)"

#define INST_METHOD_NOT_FOUND_ERR "Instance method \"%s\" not found for object of class \"%s\"."

#define PRIVATE_METHOD_NO_ACCESS_ERR "Method \"%s\" of class \"%s\" is private and cannot be accessed from outside class scope."

#define NO_CLASSES_IN_ISA_LIST_ERR "Class \"%s\" does not specify any classes in its -isA class list. Must specify at least one class with the -isA option."

#define CLASS_ALREADY_COMPLETED_ERR "Class \"%s\" has already been completely specified."

#define TOO_MANY_ARGS_TO_METHOD_ERR "Too many arguments have been supplied to \"%s\"."

#define CLASS_METHOD_NOT_FOUND_ERR "Class method \"%s\" not found for class \"%s\"."

#define ATTRIB_CANNOT_BE_CALLED_ERR "Attribute's cannot be called \"%s\"."

#define IMP_AS_INST_INT_AS_CLASS_ERR "Method \"%s\" specified as a class method in the interfaced but implemented as an instance method."

#define IMP_AS_CLASS_INT_AS_INST_ERR "Method \"%s\" specified as an instance method in the interface but implemented as a class method."

#define BAD_NAME_FOR_INST_METHOD_ERR "Cannot name an instance method \"%s\"."

#define BAD_NAME_FOR_CLASS_METHOD_ERR "Cannot name a class method \"%s\"."

#define INST_METHOD_NOT_COMPLETED_ERR "Instance method \"%s\" of class \"%s\" has not been completed. An interfaced method must be implemented."

#define CLASS_METHOD_NOT_COMPLETED_ERR "Class method \"%s\" of class \"%s\" has not been completed. An interfaced method must be implemented."

#define FORMAL_ARG_ATTRIB_CLASH_ERR "Method \"%s\" of class \"%s\" has a formal argument \"%s\" that classes with an attribute of the same name."

#define ARGS_CLASS_CMD_ERR "wrong # args: should be \"class method ?arg...?\"" 

#define ARGS_METHOD_ERR "Incorrect number of arguments for method \"%s\" of class \"%s\""

#define DUP_FORMAL_ARGUMENT_ERR "Duplicated formal argument \"%s\" in method \"%s\"."

#define NOT_A_BASE_CLASS_ERR "Class \"%s\" is not a superclass of class \"%s\"."

#define REDEFINED_DESTRUCTOR_ERR "Re-definition of destructor in class \"%s\"."

#define UNKNOWN_OTCL_COMMAND_ERR "Invalid command name \"%s\""

#define UNKNOWN_OSERVER_COMMAND_ERR "Invalid otcl oserver command \"%s\"."

#define ADDRESS_NO_COLON_ERR "Address \"%s\" contains no ':' port separator character."

#define ADDRESS_INVALID_PORT_ERR "Address \"%s\" contains an invalid port number."

#define COULDNT_SOCKET_ERR "TCP/IP socket could not be created because \"%s\"."

#define COULDNT_GET_HOSTNAME_ERR "Could get host addressing information for host \"%s\"."

#define COULDNT_CONNECT_ERR "Couldn't connect to process at address \"%s\" because \"%s\"."

#define ARGS_OSERVER_INIT_ERR "wrong # args: should be \"otcl oserver init ?port? ?maxPort?\""

#define CANNOT_BIND_TO_PORT_ERR "Cannot bind to TCP/IP port \"%d\"."

#define NO_AVAILABLE_PORTS_ERR "Couldn't find an available TCP/IP port to listen on in range %d to %d."

#define ARGS_REMOTE_OBJECT_ERR "wrong # args: should be \"otcl remoteObject address\""

#define NOT_REMOTE_OBJECT_ERR "Invalid remote object reference \"%s\"."

#define ARGS_OSERVER_PROCESS_ERR "wrongs # args: should be \"otcl oserver process ?script?\""

#define ARGS_REMOTE_CLASS_ERR "wrong # args: should be \"otcl remoteClass name address\""

#define REMOTE_CLASS_INTERNAL_CLASS_CLASH_ERR "Class \"%s\" is an internal class. Cannot redefine with a remote class."

#define OTCL_OSERVER_ALREADY_INIT_ERR "Otcl oserver has already been initialised."

#define OTCL_OSERVER_MIN_PORT_ERR "Otcl oserver min port range is less than 0."

#define OTCL_OSERVER_MAX_PORT_ERR "Otcl oserver max port < min port."

#define OTCL_OSERVER_MUST_INIT_FIRST_ERR "Otcl oserver must be initialised before requests can be processed."

#define OTCL_OSERVER_SELECT_ERR "Otcl oserver select error."

#define ARGS_OTCL_OSERVER_GET_ADDRESS_ERR "wrongs # args: should be \"otcl oserver getAddress\"."

#define OTCL_BAD_REMOTE_OBJECT_ERR "Bad remote object \"%s\"."

#endif  // OTCL_ERROR_H
