/* 
 * argcargv.c
 *
 * This code was derived from Microsoft Systems Journal, May 1991,
 * pp. 135-136.  It allows character-based DOS programs to maintain
 * their conventional main() interface and initializes the WINIO
 * pkg to support conventional C stdio functions.
 */

#include "windows.h"
#include <stdlib.h>
#include <string.h>
#include "winio.h"

#ifdef __BORLANDC__
// Borland must have followed (incorrect) doc in SDK Guide, p. 14-3
#define argc	_argc
#define argv	_argv

extern int	_argc;
extern char	**_argv;
#else
// Microsoft C code per MSJ, May 1991, pp. 135-6
#define argc	__argc
#define argv	__argv

extern int	__argc;
extern char	**__argv;
#endif

/*
 * Supporting a subroutine called main() causes a multiply-defined
 * link error.  So we just call Cmain().  Applications can redefine
 * "main" on the compilor command line (/Dmain=Cmain).
 */
extern int	Cmain(int argc, char **argv, char **envp);

HANDLE		_hinst;
HANDLE		_hprevinst;
LPSTR		_lpcmdline;
int		_ncmdshow;

int PASCAL WinMain(
	HANDLE	hInstance,
	HANDLE	hPrevInstance, 
	LPSTR	lpCmdLine,
	int	nCmdShow
	)
{
	/* Save as globals so application can reference */
	_hinst = hInstance;
	_hprevinst = hPrevInstance;
	_lpcmdline = lpCmdLine;
	_ncmdshow = nCmdShow;
	
	/* Initialize WINIO pkg */
	if (! winio_init(hInstance, hPrevInstance, nCmdShow, 0))
		return 1;
	
	/* Start the application */
	return Cmain(argc, argv, environ);
}
