


array(n)              Tcl Built-In Commands              array(n)



_________________________________________________________________

NAME
     array - Manipulate array variables

SYNOPSIS
     array option arrayName ?arg arg ...?
_________________________________________________________________


DESCRIPTION
     This command performs one of several operations on the vari-
     able  given  by arrayName.  ArrayName must be the name of an
     existing array variable.   The  option  argument  determines
     what  action  is  carried  out  by  the  command.  The legal
     options (which may be abbreviated) are:

     array anymore arrayName searchId
          Returns 1 if there are any more  elements  left  to  be
          processed  in  an  array search, 0 if all elements have
          already been returned.  SearchId indicates which search
          on  arrayName  to  check, and must have been the return
          value from a previous invocation of array  startsearch.
          This  option  is particularly useful if an array has an
          element with an empty name, since the return value from
          array nextelement won't indicate whether the search has
          been completed.

     array donesearch arrayName searchId
          This command terminates an array  search  and  destroys
          all  the  state  associated with that search.  SearchId
          indicates which search on  arrayName  to  destroy,  and
          must have been the return value from a previous invoca-
          tion of array startsearch.  Returns an empty string.

     array names arrayName
          Returns a list containing the names of all of the  ele-
          ments  in  the  array.  If there are no elements in the
          array then an empty string is returned.

     array nextelement arrayName searchId
          Returns the name of the next element in  arrayName,  or
          an  empty  string  if  all  elements  of arrayName have
          already been returned in  this  search.   The  searchId
          argument  identifies the search, and must have been the
          return value of an array startsearch command.  Warning:
          if  elements  are  added  to or deleted from the array,
          then all searches are automatically terminated just  as
          if  array  donesearch had been invoked; this will cause
          array  nextelement  operations  to   fail   for   those
          searches.




Tcl                      Last change:                           1






array(n)              Tcl Built-In Commands              array(n)



     array size arrayName
          Returns a decimal string giving the number of  elements
          in the array.

     array startsearch arrayName
          This command initializes an  element-by-element  search
          through the array given by arrayName, such that invoca-
          tions of the array nextelement command will return  the
          names  of  the  individual elements in the array.  When
          the search has been  completed,  the  array  donesearch
          command  should  be  invoked.   The  return  value is a
          search identifier that must be used in  array  nextele-
          ment  and array donesearch commands; it allows multiple
          searches to be underway  simultaneously  for  the  same
          array.


KEYWORDS
     array, element names, search




































Tcl                      Last change:                           2



