


error(n)              Tcl Built-In Commands              error(n)



_________________________________________________________________

NAME
     error - Generate an error

SYNOPSIS
     error message ?info? ?code?
_________________________________________________________________


DESCRIPTION
     Returns a TCL_ERROR code, which causes  command  interpreta-
     tion to be unwound.  Message is a string that is returned to
     the application to indicate what went wrong.

     If the info argument is provided and  is  non-empty,  it  is
     used to initialize the global variable errorInfo.  errorInfo
     is used to accumulate a stack trace of what was in  progress
     when  an  error occurred; as nested commands unwind, the Tcl
     interpreter adds information  to  errorInfo.   If  the  info
     argument  is present, it is used to initialize errorInfo and
     the first increment of unwind information will not be  added
     by  the  Tcl  interpreter.  In other words, the command con-
     taining the error command will not appear in  errorInfo;  in
     its place will be info.  This feature is most useful in con-
     junction with the catch command: if a caught error cannot be
     handled  successfully,  info  can  be used to return a stack
     trace reflecting the original point  of  occurrence  of  the
     error:

          catch {...} errMsg
          set savedInfo $errorInfo
          ...
          error $errMsg $savedInfo


     If the code argument is present, then its value is stored in
     the errorCode global variable.  This variable is intended to
     hold a machine-readable description of the  error  in  cases
     where  such information is available; see the section BUILT-
     IN VARIABLES below for information on the proper format  for
     the  variable.   If  the  code argument is not present, then
     errorCode is automatically reset  to  ``NONE''  by  the  Tcl
     interpreter as part of processing the error generated by the
     command.


KEYWORDS
     error, errorCode, errorInfo






Tcl                      Last change:                           1



