


tclvars(n)            Tcl Built-In Commands            tclvars(n)



_________________________________________________________________

NAME
     tclvars - Variables used by Tcl
_________________________________________________________________


DESCRIPTION
     The following  global  variables  are  created  and  managed
     automatically by the Tcl library.  Except where noted below,
     these variables should normally be treated as  read-only  by
     application-specific code and by users.

     env
          This variable is maintained by Tcl as  an  array  whose
          elements are the environment variables for the process.
          Reading  an  element  will  return  the  value  of  the
          corresponding environment variable.  Setting an element
          of the array will modify the corresponding  environment
          variable  or  create  a  new  one if it doesn't already
          exist.  Unsetting an element of  env  will  remove  the
          corresponding environment variable.  Changes to the env
          array will affect the environment passed to children by
          commands  like  exec.  If the entire env array is unset
          then Tcl will stop monitoring env accesses and will not
          update environment variables.

     errorCode
          After an error has occurred, this variable will be  set
          to  hold  additional  information  about the error in a
          form that is easy to process with programs.   errorCode
          consists  of a Tcl list with one or more elements.  The
          first element of the list identifies a general class of
          errors,  and  determines  the format of the rest of the
          list.  The following formats for errorCode are used  by
          the  Tcl core; individual applications may define addi-
          tional formats.

          ARITH code msg
               This format  is  used  when  an  arithmetic  error  |
               occurs  (e.g.  an attempt to divide by zero in the  |
               expr command).  Code identifies the precise  error  |
               and  msg  provides a human-readable description of  |
               the error.  Code will be either  DIVZERO  (for  an  |
               attempt to divide by zero), DOMAIN (if an argument  |
               is outside the  domain  of  a  function,  such  as  |
               acos(-3)),   IOVERFLOW   (for  integer  overflow),  |
               OVERLFLOW (for a floating-point overflow), or UNK-  |
               NOWN  (if  the cause of the error cannot be deter-  |
               mined).

          CHILDKILLED pid sigName msg



Tcl                      Last change:                           1






tclvars(n)            Tcl Built-In Commands            tclvars(n)



               This format is used when a child process has  been
               killed because of a signal.  The second element of
               errorCode will be  the  process's  identifier  (in
               decimal).   The third element will be the symbolic
               name of the signal that caused the process to ter-
               minate;  it  will  be  one  of  the names from the
               include  file  signal.h,  such  as  SIGPIPE.   The
               fourth element will be a short human-readable mes-
               sage describing the signal,  such  as  ``write  on
               pipe with no readers'' for SIGPIPE.

          CHILDSTATUS pid code
               This format is  used  when  a  child  process  has
               exited  with  a  non-zero exit status.  The second
               element of errorCode will be the  process's  iden-
               tifier  (in decimal) and the third element will be
               the exit code returned by  the  process  (also  in
               decimal).

          CHILDSUSP pid sigName msg
               This format is used when a child process has  been
               suspended because of a signal.  The second element
               of errorCode will be the process's identifier,  in
               decimal.   The  third element will be the symbolic
               name of the signal  that  caused  the  process  to
               suspend;  this  will  be one of the names from the
               include  file  signal.h,  such  as  SIGTTIN.   The
               fourth element will be a short human-readable mes-
               sage describing the signal, such  as  ``background
               tty read'' for SIGTTIN.

          NONE
               This format is used for errors where no additional
               information  is available for an error besides the
               message returned with the error.  In  these  cases
               errorCode will consist of a list containing a sin-
               gle element whose contents are NONE.

          POSIX errName msg
               If the first element of errorCode is  POSIX,  then  |
               the  error  occurred  during  a POSIX kernel call.
               The second element of the list  will  contain  the
               symbolic  name of the error that occurred, such as
               ENOENT; this will be one of the values defined  in
               the  include  file  errno.h.  The third element of
               the  list  will  be   a   human-readable   message
               corresponding  to  errName, such as ``no such file
               or directory'' for the ENOENT case.

          To set errorCode, applications should use library  pro-
          cedures such as Tcl_SetErrorCode and Tcl_PosixError, or  |
          they may invoke the error command.   If  one  of  these



Tcl                      Last change:                           2






tclvars(n)            Tcl Built-In Commands            tclvars(n)



          methods hasn't been used, then the Tcl interpreter will
          reset the variable to NONE after the next error.

     errorInfo
          After an error has occurred, this string  will  contain
          one or more lines identifying the Tcl commands and pro-
          cedures that were being executed when the  most  recent
          error  occurred.  Its contents take the form of a stack
          trace showing the various nested Tcl commands that  had
          been invoked at the time of the error.

     tcl_precision
          If this variable is set,  it  must  contain  a  decimal  |
          number  giving  the  number  of  significant  digits to  |
          include  when  converting  floating-point   values   to  |
          strings.  If this variable is not set then 6 digits are  |
          included.  17 digits is ``perfect'' for IEEE  floating-  |
          point  in  that it allows double-precision values to be  |
          converted to strings and back to binary with no loss of  |
          precision.


KEYWORDS
     arithmetic, error, environment,  POSIX,  precision,  subpro-
     cess, variables






























Tcl                      Last change:                           3



