#include <stdio.h>
#include <string.h>
#include <wchar.h>
#include <io.h>

#include "dirent.h"


DIR *
opendir(dirname)
	char	*dirname;
{
	char		dest_path[_MAX_PATH];
	//struct find_t	fileinfo;
	struct _finddata_t fileinfo;
	long findhandle;
	struct _stat	statbuf;
	DIR		*dirptr;
	DIRENT		*dirent;

	strcpy(dest_path, dirname);
	if ((strlen(dest_path) == 2) && (dest_path[1] == ':'))
		strcat(dest_path, "\\");

	if (_access(dest_path, 0) != 0) {
		errno = ENOENT;
		return (NULL);
	}

	_stat(dest_path, &statbuf);
	if (!(statbuf.st_mode & _S_IFDIR)) {
		errno = ENOTDIR;
		return (NULL);
	}

	dirptr = (DIR *)calloc(1, sizeof(DIR));
	if(dirptr == NULL) {
		errno = ENOMEM;
		return (NULL);
	}

	dirptr->dd_loc = 0;
	dirptr->dd_size = 0L;
	dirptr->dd_magic = D_MAGIC;
	dirptr->dd_buf = (DIRENT *)malloc(sizeof (DIRENT));

	/* Open directory to be scanned */
	if (dest_path[strlen(dest_path)-1] == '\\')
		dest_path[strlen(dest_path)-1] = '\0';
	strcat(dest_path, "\\*.*");

	// _dos_findfirst(dest_path, _A_SUBDIR, &fileinfo);
	findhandle = _findfirst(dest_path,&fileinfo);

	do {
		if (fileinfo.attrib & _A_SUBDIR) {

			/* Directory entry.  Ignore "." and ".." */
			if (!strcmp(fileinfo.name, ".") ||
			    !strcmp(fileinfo.name, ".."))
				continue;
		}

		if (dirptr->dd_buf == NULL)
			dirptr->dd_buf = (DIRENT *)malloc(sizeof (DIRENT));
		else
			dirptr->dd_buf = (DIRENT *)realloc(dirptr->dd_buf,
				(size_t)(dirptr->dd_size + 1) * sizeof(DIRENT));

		dirent = &(dirptr->dd_buf[dirptr->dd_size]);
		dirent->d_reclen = sizeof(DIRENT);
		dirent->d_namlen = strlen(fileinfo.name);
		strcpy(dirent->d_name, fileinfo.name);
		_strlwr(dirent->d_name);

		dirptr->dd_size++;

	} while (_findnext(findhandle,&fileinfo) == 0);

	return (dirptr);
}


/*
 *	readdir - returns the next directory structure from the list and
 *	updates values in the DIR structure.
 */
DIRENT *
readdir(dirptr)
	DIR	*dirptr;
{
	if (dirptr->dd_magic != D_MAGIC) {
		errno = ENOTDIR;
		return (NULL);
	}

	if (dirptr->dd_loc >= dirptr->dd_size) {
		errno = ENFILE;
		return (NULL);
	}

	return (&(dirptr->dd_buf[dirptr->dd_loc++]));
}


/*
 *	closedir - close given directory. destroy given DIR struct so we
 *	know it is closed.
 */
int
closedir(dirptr)
	DIR	*dirptr;
{
	if(dirptr->dd_magic != D_MAGIC) {
		errno = ENOTDIR;
		return (-1);
	}

	free (dirptr->dd_buf);
	free (dirptr);
	return (0);
}
