/*
 * wmhandlr.h
 *
 * Event (WM_ message) handlers - interface
 * Originally in Microsoft Systems Journal, 1991, by Dave Maxey
 * and Andrew Schulman.
 *
 * wmhandler_init MUST be called before a window is opened.
 * wmhandler_get returns current handler for an event.
 * wmhandler_set also returns current handler, and then makes
 *	supplied handler current for the message type.
 */

#ifndef _WMHANDLR_H
#define _WMHANDLR_H

#ifdef __cplusplus
extern "C" {
#endif
typedef long		(*WMHANDLER)(HWND, unsigned, WORD, LONG);

extern long FAR PASCAL /* _export */ WndProc(HWND, WORD, WORD, LONG);

extern void		wmhandler_init(void);
extern WMHANDLER	wmhandler_get(unsigned);
extern WMHANDLER	wmhandler_set(unsigned, WMHANDLER);

#ifdef __cplusplus
}
#endif

#endif /* _WMHANDLR_H */
