/* supertcl.c */
#include <stdio.h>
#include <tcl.h>
#include <tclExtend.h>
#include <tk.h>

	/* For expect and Debug */
extern char *exp_argv0;
static int debug_v=-1;
static char debug_init[] = "trap {exp_debug 1} SIGINT";

main(argc, argv) 
int argc;
char *argv[];
{
	exp_argv0 = argv[0];	 /* Needed by expect */
	/* get Debug option */
	if ((argc>1) && (argv[1][0] == '-') && (argv[1][1] == 'D') ) {
	    debug_v = atoi(argv[2]);
	    argc -= 2;
	    argv += 2;
	}

	/*
	 * Create the main window. This calls
	 * back into Tcl_AppInit.
	 */
	Tk_Main(argc, argv);
	exit(0);
}

/*
 * The following variable is a special hack that is needed in order for
 * Sun shared libraries to be used for Tcl.
 */
   
#ifdef NEED_MATHERR
extern int matherr();
int *tclDummyMathPtr = (int *) matherr;
#endif
   
int
Tcl_AppInit(interp)
Tcl_Interp *interp;
{
	if (debug_v != -1) {   /* turn on Debug if it need */
	    Tcl_Eval(interp, debug_init);
	    if (debug_v == 1)
	    	Dbg_On(interp,0);
	}

	/* Initialise extensions */
	if (TclX_Init(interp) == TCL_ERROR) {
		/* TclX_Init is called instead of Tcl_Init */
		return TCL_ERROR;
	}
	if (Tk_Init(interp) == TCL_ERROR) {
		/* TclX_Init is called instead of Tcl_Init */
		return TCL_ERROR;
	}
	if (Exp_Init(interp) == TCL_ERROR) {	/* Expect */
		return TCL_ERROR;
	}
	if (Itcl_Init(interp) == TCL_ERROR) {	/* incr tcl  */
		return TCL_ERROR;
	}
	if (Tdp_Init(interp) == TCL_ERROR) {	/*  Tcl-DP  */
		return TCL_ERROR;
	}
	if (Blt_Init(interp) == TCL_ERROR) {	/*  BLT  */
		return TCL_ERROR;
	}
	
	/* This information is returned by the infox (tclX) command. */
	tclAppName = "SuperTk";
	tclAppLongname = "Tcl-TclX-Expect-Tdp-Itcl-Tk-BLT";
	tclAppVersion = "0.5";

	tcl_RcFileName = "~/.tkshrc";
        return TCL_OK;
}
