'\" @(#)tclStruct:read.n	1.4	96/04/23
.so man.macros
.TH struct_read n "" TclStruct "TclStruct Built-In Commands"
.BS
.SH NAME
struct_read \- Read from a stream to an object or field
.SH SYNOPSIS
\fBstruct_read \fI?flags? channelId \fIobj\fR|\fIobj(elem) \fI?length? \fR
.BE

.SH DESCRIPTION
.PP
Read from a channel specified by \fIchannelId\fR (a Tcl file id)
into an object or field.
\fIchannelId\fR must be \fBstdin\fR or the return value from a previous
call to \fBopen\fR or \fBsocket\fR;
it must refer to a file that was opened for reading.
The file is read as a binary stream of bytes directly
into the object or field;
to insure that the file is read as a binary file the channel must
be configured as a binary channel with the command:
.br
	\fBfconfigure \fIchannelId \fB\-translation binary\fR
.PP
By default, the length to be read is the size of the object.
If a \fIlength\fR is specified, it may either be the integer length,
or a variable that contains the integer length.  When a variable name
is specified, then the number of bytes read is stored in the variable
as well as being returned to the caller.
.PP
The following optional \fIflags\fR may be specified in any order:
.IP "\fB\-eofok\fR"
Normally the struct_read command will generate an error if the read
fails because of end-of-file.  Specifying \fB\-eofok\fR will allow
struct_read to return a value of 0 when EOF is read.
.IP "\fB\-partial\fR"
Normally struct_read will continue reading until it reads the full
number of bytes wanted.  Specifying \fB\-partial\fR will cause
struct_read to return the actual number of bytes read from the first
read.  Note that this will normally be used in conjunction with
unbuffered (see \fBfconfigure\fR(n)) channels
since otherwise the \fBTcl_Read\fR() call will
most likely do its own retries.
.IP "\fB\-mod4\fR"
Make sure the \fIlength\fR read is a multiple of 4 by increasing 
the \fIlength\fR read if necessary.  It is the caller's responsibility
to make sure the object is big enough to avoid overwriting the
end of the object buffer.
.PP
struct_read returns the number of bytes read.

.SH EXAMPLES
This example reads in the contents of an object from a file.
.DS
set file [open 'filename' r]
fconfigure $file -translation binary
read $file obj
close $file
.DE

.SH WARNINGS
.PP
The data read is not machine independent.

.SH "SEE ALSO"
close(n),
fconfigure(n),
open(n),
read(n),
socket(n).
.br
Tcl_OpenFileChannel(3).
.br
struct_write(n).

.SH KEYWORDS
buffering, channel, end of file, read, struct
