'\" @(#)tclStruct:write.n	1.4	96/04/23
.so man.macros
.TH struct_write n "" TclStruct "TclStruct Built-In Commands"
.BS
.SH NAME
struct_write \- Write an object to a file
.SH SYNOPSIS
\fBstruct_write \fI?flags? channelId \fIobj\fR|\fIobj(elem) \fI?length? \fR
.BE

.SH DESCRIPTION
.PP
Write the binary information contained within a struct object
to an external file.
\fIchannelId\fR must have been the return value from a previous
call to \fBopen\fR or \fBsocket\fR, or it may be \fBstdout\fR or \fBstderr\fR to
refer to one of the standard I/O channels; it must refer to a
channel that was opened for writing.
Output to files in buffered internally by Tcl; the \fBflush\fR
command may be used to force buffered characters to be output.
.PP
To insure that Tcl performs no new-line conversions on binary data
the channel must be configured as a binary channel:
.br
	\fBfconfigure \fIchannelId \fB\-translation binary\fR
.PP
The data is written in a machine dependent format.
.PP
By default, the length to be write is the size of the object.
If a \fIlength\fR is specified, it may either be the integer length,
or a variable that contains the integer length.  When a variable name
is specified, then the number of bytes written is stored in the variable
as well as being returned to the caller.
.PP
The following optional \fIflags\fR may be specified in any order:
.IP "\fB\-partial\fR"
Normally struct_write will continue writing until it writes the full
number of bytes wanted.  Specifying \fB\-partial\fR will cause
struct_write to return the actual number of bytes written from the first
write.  Note that this will normally be used in conjunction with
\fB\-unbuffered\fR since otherwise the \fBfwrite\fR(3S) call will
most likely do its own retries.
.IP "\fB\-mod4\fR"
Make sure the \fIlength\fR write is a multiple of 4 by increasing 
the \fIlength\fR written if necessary.  Any extra bytes written
are not initialized and will have a unspecified value.
.PP
struct_write returns the number of bytes written.
.SH EXAMPLES
.PP
.DS
set file [open 'filename' w]
fconfigure $file -translation binary
struct_write $file obj
.DE
.PP
To write the data in a machine independent fashion, the
struct should be written out in a (possibly nested) Tcl list:
.DS
puts "$obj()"
.DE

.SH WARNINGS
.PP
The data written is not machine independent.

.SH "SEE ALSO"
fconfigure(n),
open(n),
socket(n),
write(n).
.br
struct_read(n).

.SH KEYWORDS
channel, write, struct
