#!/usr/local/bin/tclsh
#	"@(#)tclStruct:fslsfonts.tcl	1.3	96/04/23"
#
# Written by Matthew Costello
# (c) 1995 NCR Corporation, Dayton Ohio USA
#
# See the file "license.terms" for information on usage and
# redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.

#	fslsfonts.tcl
# This is a (partial) implementation of the fslsfonts(1)
# command:
#	Fslsfonts lists the fonts that match the given pattern.  The
#	wildcard character "*" may be used to match any sequence of
#	characters (including none), and "?" to match any single
#	character.  If no pattern is given, "*" is assumed.


# Load the required extensions
##lappend auto_load /usr/local/lib/tclstruct
load /usr/local/lib/libtclStruct[info sharedlibextension] Struct

# Process command line arguments
catch {set fontserver $env(FONTSERVER)}
set fontpattern {*}
if {[string compare [lindex $argv 0] "-server"] == 0} {
	set fontserver [lindex $argv 1]
	incr argc -2
}
if {[string compare [lindex $argv 0] "-fn"] == 0} {
	set fontpattern [lindex $argv 1]
	incr argc -2
}
if {$argc != 0} {
	puts stderr "Usage: $argv0 \[-server servername\] \[-fn pattern\]"
	exit 2
}

# Determine where the font server is located
if {[catch {set fs [split $fontserver : ]}]} {
	puts stderr "$argv0: FONTSERVER not set"
	exit 2
}
##puts "FONTSERVER = <$fontserver>"
if {[llength $fs] != 2} {
	puts stderr "$argv0: FONTSERVER should have format 'server:port'"
	exit 2
}

# Connect to the font server
##puts "FS = <$fs>"
set fd [eval socket $fs]
##puts "FD = <$fd>"
##puts "CHANOPTS = [fconfigure $fd]"
fconfigure $fd -translation binary -buffering none
##puts "CHANOPTS = [fconfigure $fd]"

# struct_info debug +all
struct_typedef fs_open_connection_t {struct
	align 1
	{char	byte-order}
	{ubyte	num-auths}
	{ushort	client-major-protocol-version}
	{ushort	client-minor-protocol-version}
	{ushort	auth-len}
	{ubyte*0	authorization-protocols}
	align 4
}
struct_typedef fs_open_connection_setup_t {struct
	{ushort	status}
	{ushort	server-major-protocol-version}
	{ushort server-minor-protocol-version}
	{ubyte	num_alternates}
	{ubyte	auth_index}
	{ushort	alternate_len}
	{ushort	auth_len}
	{ubyte*0	data}
}
struct_typedef fs_open_connection_setup2_t {struct
	{uint	remaining-length}
	{ushort	maximum-request-length}
	{ushort	vendor-length}
	{uint	release-number}
	{char*0	vendor}
}

##puts "Writing open connection"
struct_new open_connection fs_open_connection_t(0)
set open_connection() { l 0 2 0 }
##puts "Endian = [struct_info type int endian]"
if {[string compare little [struct_info type int endian]]} {
	set open_connection(byte-order) B
}
##struct_show open_connection
struct_write $fd open_connection


##puts "Reading connection setup"
struct_new connection_setup fs_open_connection_setup_t(0)
set rlen [struct_read $fd connection_setup]
##puts "Read $rlen bytes"
##struct_show connection_setup

##puts "Reading connection accept"
struct_new connection_accept fs_open_connection_setup2_t(0)
set rlen [struct_read $fd connection_accept]
##puts "Read $rlen bytes"
##struct_show connection_accept

struct_typedef vendor_name1_t char*$connection_accept(vendor-length)
struct_typedef vendor_name2_t {struct {vendor_name1_t vendor_name} align 4}
struct_new vendor_name vendor_name2_t
##puts "Reading vendor name (of [struct_info sizeof vendor_name] bytes)"
set rlen [struct_read $fd vendor_name]
##puts "Read $rlen bytes"
##struct_show vendor_name


# Getting font list
struct_typedef fs_list_fonts_t {struct
	{ubyte	major-opcode}
	{ubyte	minor_opcode}
	{ushort	length}
	{uint	max-names}
	{ushort	pattern-length}
	{ushort	{}}
	{char*0 pattern}
	align 4
}
struct_new list_fonts fs_list_fonts_t([string length $fontpattern])
set list_fonts() "13 0 4 99999 [string length $fontpattern] $fontpattern"
set list_fonts(length) [expr [struct_info sizeof list_fonts] / 4]
struct_write $fd list_fonts

struct_typedef fs_list_fonts_reply_t {struct
	{ubyte	type}
	{ubyte	pad}
	{ushort	sequence-number}
	{uint	length}
	{uint	num-replies}
	{uint	num-fonts}
}
	# LISTofSTRNAME
struct_new list_fonts_reply fs_list_fonts_reply_t
set rlen [struct_read $fd list_fonts_reply]
##puts "num-replies:       $list_fonts_reply(num-replies)"
##puts "number of fonts:   $list_fonts_reply(num-fonts)"

catch {unset buffer}
struct_new buffer byte*[expr ( $list_fonts_reply(length) - 4 ) * 4]
set rlen [struct_read $fd buffer]
##puts "Length of string buffer rlen = $rlen (size = [struct_info sizeof buffer])"
for {set i 0 ; set count $list_fonts_reply(num-fonts)} {$count > 0} {incr count -1} {
	set len $buffer($i._ubyte_)
#	puts "i = $i, len = $len"
	incr i 1
#	puts "\tsizeof buffer(_char_.$i-[expr $i + $len]) = [struct_info object buffer(_char_.$i-[expr $i + $len]) size]"
	puts "$buffer(_char_.$i-[expr $i + $len])"
	incr i $len
}

close $fd
