/*
 *	tclStruct package
 *  Support 'C' structures in Tcl
 *
 *  Written by Matthew Costello
 *  (c) 1995 NCR Corporation, Dayton Ohio USA
 *
 *  See the file "license.terms" for information on usage and
 *  redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */
#include "stInternal.h"
STRUCT_SCCSID("@(#)tclStruct:stCopy.c	1.1	95/09/08")


/*
 * struct_copy copy binary data
 */
int
Struct_CopyCmd(cdata, interp, argc, argv)
  ClientData cdata;                   /* Client Data */
  Tcl_Interp *interp;                 /* Current interpreter. */
  int argc;                           /* Number of arguments. */
  char **argv;                        /* Argument strings. */
{
    Struct_Object objdst, objsrc;

    Struct_PkgInfo(cdata,si_cmdCount) += 1;
    if (argc != 3) {
	Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		  " objectDest objectSrc\"", (char *) NULL);
	return TCL_ERROR;
    }
#ifdef DEBUG
    if (struct_debug & (DBG_COMMAND)) Struct_PrintCommand(argc,argv);
#endif

    if (Struct_GetObject(interp,argv[1],&objdst) == TCL_ERROR)
	return TCL_ERROR;
    if (Struct_GetObject(interp,argv[2],&objsrc) == TCL_ERROR) {
	Struct_ReleaseType(objdst.type);
	return TCL_ERROR;
    }

    if (objdst.type != objsrc.type) {
	Tcl_SetResult(interp,"the two objects have different types",TCL_STATIC);
	Struct_ReleaseType(objdst.type);
	Struct_ReleaseType(objsrc.type);
	return TCL_ERROR;
    }

    if (objdst.size != objsrc.size) {
	Tcl_SetResult(interp,"the two objects have different sizes",TCL_STATIC);
	Struct_ReleaseType(objdst.type);
	Struct_ReleaseType(objsrc.type);
	return TCL_ERROR;
    }

    if (objdst.data == objsrc.data) {
	Tcl_SetResult(interp,"the two objects are the same object",TCL_STATIC);
	Struct_ReleaseType(objdst.type);
	Struct_ReleaseType(objsrc.type);
	return TCL_ERROR;
    }

    memcpy( (char *)objdst.data, (char *)objsrc.data, objdst.size );
    Struct_ReleaseType(objdst.type);
    Struct_ReleaseType(objsrc.type);
    return TCL_OK;
}
