/*
 *	tclStruct package
 *  Support 'C' structures in Tcl
 *
 *  Written by Matthew Costello
 *  (c) 1995 NCR Corporation, Dayton Ohio USA
 *
 *  See the file "license.terms" for information on usage and
 *  redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 *  The inspiration for this came from Laurent Demailly's tclbin package.
 *  I hadn't realized how much variable traces could be perverted :-)
 *
 */


#ifdef lint
# define STRUCT_SCCSID(sccsid)
#else
# define STRUCT_SCCSID(sccsid)	static char struct_sourceID[] = sccsid ;
static char struct_inthdrID[] = "@(#)tclStruct:stInternal.h	1.3	95/09/12";
#endif

#ifdef STDC_HEADERS
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <limits.h>
#include <float.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "tcl.h"
#include <malloc.h>
#include "tclStruct.h"

/*
 *  The tclStruct package supports the type definition of complex 'C'
 *  data structures and the creation/referencing them through Tcl
 *  associative arrays.
 */


/*  Internal information needed/used by this package.  This information
 *  is per-interpreter, so it is stored as the ClientData associated
 *  with the tclStruct Tcl commands.
 */
typedef struct {
	Tcl_HashTable	si_typeHash;	/* Hash table for defined types */

	/* Statistics */
	int		si_cmdCount;	/* number of commands executed */
	int		si_rdCount;	/* number of read accesses */
	int		si_wrCount;	/* number of write accesses */
	int		si_nNewTypes;	/* number of created types */
	int		si_nExTypes;	/* number of destroyed types */
} Struct_PkgInfo_t;
#define Struct_PkgInfo(cdata,elem)	(((Struct_PkgInfo_t *)cdata)->elem)
#define Struct_TypeHash(cdata)	(&((Struct_PkgInfo_t *)cdata)->si_typeHash)


/* ****************************************************************** */
#ifdef DEBUG
/*  When DEBUG is defined, enable the display of debugging messages.
 */
extern	int			struct_debug;
#define DBG_NONE		0
#define DBG_REFCOUNT		000001
#define DBG_NEWTYPE		000002
#define DBG_PARSETYPE		000004
#define DBG_PARSEELEMENT	000010
#define DBG_LOOKUP		000020
#define DBG_NEWOBJECT		000040
#define DBG_GETOBJECT		000100
#define DBG_FLOAT		000200
#define DBG_INT			000400
#define DBG_UNSET		001000
#define DBG_COMMAND		002000
#define DBG_CHAR		004000
#define DBG_ARRAY		010000
#define DBG_VARLEN		020000
#define DBG_IO			040000

EXTERN void Struct_PrintCommand _ANSI_ARGS_((int,char **));
EXTERN CONST char *Struct_TypeName _ANSI_ARGS_((Struct_TypeDef *));
EXTERN CONST char *Struct_ObjectName _ANSI_ARGS_((Struct_Object *, int));
#endif	/*DEBUG*/

#ifdef DEBUG
/*VARARGS*/
EXTERN void panic _ANSI_ARGS_((char *fmt,...));	/* Internal to Tcl7.5 */
#ifdef STRUCT_MAGIC
# define Struct_CheckType(typeptr,where) \
	if (typeptr == NULL) \
		panic("NULL type in Struct_%s", where); \
	else if (typeptr->magic != STRUCT_MAGIC_TYPE) \
		panic("Corruption of type structure %p in Struct_%s", \
			(void *)typeptr, where ); \
	else if (typeptr->refcount <= 0) \
		panic("Negative refcount of type %s in Struct_%s", \
			Struct_TypeName(typeptr), where )
# define Struct_CheckObject(objectptr,where) \
	if (objectptr == NULL) \
		panic("NULL object in Struct_%s", where); \
	else if (objectptr->magic != STRUCT_MAGIC_OBJECT) \
		panic("Corruption of object structure %p in Struct_%s", \
			(void *)objectptr, where ); \
	Struct_CheckType(objectptr->type,where)
#else	/*STRUCT_MAGIC*/
# define Struct_CheckType(typeptr,where) \
	if (typeptr == NULL) \
		panic("NULL type in Struct_%s", where); \
	else if (typeptr->refcount <= 0) \
		panic("Negative refcount of type %s in Struct_%s", \
			Struct_TypeName(typeptr), where )
# define Struct_CheckObject(objectptr,where) \
	if (objectptr == NULL) \
		panic("NULL object in Struct_%s", where); \
	Struct_CheckType(objectptr->type,where)
#endif	/*!STRUCT_MAGIC*/
#else	/*DEBUG*/
# define Struct_CheckType(typeptr,where)
# define Struct_CheckObject(objectptr,where)
#endif	/*DEBUG*/

/* ****************************************************************** */

/*
 *  These macros provide very low-level access to the Struct_Object
 *  associated with a tclStruct associative array.  These macros
 *  should only be used to check that an object does, or does not,
 *  exist.
 */
#define STRUCT_GETOBJECT(interp,name) (Tcl_VarTraceInfo(interp,name,0,Struct_MainTraceProc,(ClientData)NULL))
#define STRUCT_GETOBJECT2(interp,name1,name2) (Tcl_VarTraceInfo2(interp,name1,name2,0,Struct_MainTraceProc,(ClientData)NULL))

/* ****************************************************************** */

/*
 *  Internal 'C' interfaces using within the tclStruct package:
 */

EXTERN CONST char *Struct_AccessElement _ANSI_ARGS_((Tcl_Interp *,Struct_Object *,char*));
EXTERN CONST char *Struct_GenerateName _ANSI_ARGS_((const char *));
EXTERN Struct_Object *Struct_NewObject _ANSI_ARGS_((Struct_TypeDef *,void *,int));
EXTERN Struct_TypeDef * Struct_CloneType _ANSI_ARGS_((ClientData, Tcl_Interp *, const char *, Struct_TypeDef *));
EXTERN Struct_TypeDef * Struct_DefArray _ANSI_ARGS_((ClientData, Tcl_Interp *, Struct_TypeDef *, int));
EXTERN Struct_TypeDef * Struct_InstantiateType _ANSI_ARGS_((ClientData, Tcl_Interp *, const char *, Struct_TypeDef *, int));
EXTERN Struct_TypeDef * Struct_LookupType _ANSI_ARGS_((ClientData, Tcl_Interp *,const char *typename));
EXTERN Struct_TypeDef * Struct_NewType _ANSI_ARGS_((ClientData, Tcl_Interp *, const char *, int, int, Tcl_VarTraceProc *));
EXTERN Struct_TypeDef * Struct_ParseDefOptions _ANSI_ARGS_((ClientData, Tcl_Interp *, Struct_TypeDef *, Struct_StructElem *, int, char **));
EXTERN int Struct_CopyCmd _ANSI_ARGS_((ClientData, Tcl_Interp *,int , char **));
EXTERN int Struct_DebugInfo _ANSI_ARGS_((ClientData,Tcl_Interp *,int,char **));
EXTERN int Struct_DefType _ANSI_ARGS_((ClientData, Tcl_Interp *, CONST char *,char *));
EXTERN int Struct_GetObject _ANSI_ARGS_((Tcl_Interp *,const char*,Struct_Object *));
EXTERN int Struct_GetObjectAndCheck _ANSI_ARGS_((Tcl_Interp *,const char*,const char *,Struct_Object *));
EXTERN int Struct_InfoCmd _ANSI_ARGS_((ClientData, Tcl_Interp *,int , char **));
EXTERN int Struct_NewCmd _ANSI_ARGS_((ClientData, Tcl_Interp *,int , char **));
EXTERN int Struct_ReadCmd _ANSI_ARGS_((ClientData, Tcl_Interp *,int , char **));
EXTERN int Struct_RegisterBuiltInType _ANSI_ARGS_((ClientData, Tcl_Interp *, const char *, int, int, Tcl_VarTraceProc *));
EXTERN int Struct_RegisterType _ANSI_ARGS_((ClientData, Tcl_Interp *, const char *, Struct_TypeDef *));
EXTERN int Struct_TypeDefCmd _ANSI_ARGS_((ClientData, Tcl_Interp *,int , char **));
EXTERN int Struct_UnTypeDefCmd _ANSI_ARGS_((ClientData, Tcl_Interp *,int , char **));
EXTERN int Struct_WriteCmd _ANSI_ARGS_((ClientData, Tcl_Interp *,int , char **));
EXTERN void Struct_AttachType _ANSI_ARGS_((Struct_TypeDef *));
EXTERN void Struct_DeleteObject _ANSI_ARGS_((Struct_Object *));
EXTERN void Struct_ReleaseType _ANSI_ARGS_((Struct_TypeDef *));
EXTERN int Struct_GetBinaryInt _ANSI_ARGS_((void *, int, int));
EXTERN void Struct_PutBinaryInt _ANSI_ARGS_((int, void *, int, int));


/*
 *  Each structure instance is a tcl array,
 *  with an attached memory buffer holding the contents
 *  of the structure, as well as a pointer to the definition
 *  of the structure.  References to the structure are caught
 *  by our trace proc to do any R/W conversion and access the
 *  'real' structure in the memory buffer.
 */
EXTERN Tcl_VarTraceProc	Struct_MainTraceProc;

/*
 *  The Tcl trace procedures for our built-in types.  These
 *  routines are only called by Struct_MainTraceProc, which
 *  passes the Struct_Ojbect as ClientData.
 */
EXTERN Tcl_VarTraceProc	Struct_TraceChar;
EXTERN Tcl_VarTraceProc	Struct_TraceInt;
EXTERN Tcl_VarTraceProc	Struct_TraceDouble;
EXTERN Tcl_VarTraceProc	Struct_TraceHex;
EXTERN Tcl_VarTraceProc	Struct_TraceFloat;
EXTERN Tcl_VarTraceProc	Struct_TracePtr;
EXTERN Tcl_VarTraceProc	Struct_TraceAddr;
EXTERN Tcl_VarTraceProc	Struct_TraceString;
EXTERN Tcl_VarTraceProc	Struct_TraceStruct;
EXTERN Tcl_VarTraceProc	Struct_TraceArray;

