/*
 * $Id: complete.c,v 1.3 1995/07/18 22:01:16 dimka Exp $
 *
 * $Log: complete.c,v $
 * Revision 1.3  1995/07/18  22:01:16  dimka
 * Draft Release
 *
 * Revision 1.2  1995/05/30  16:34:35  dimka
 * rl_complete_internal command is added
 *
 * Revision 1.1  1995/05/28  18:52:46  dimka
 * Initial revision
 *
 *
 * Copyright (C) 1995 Dimitry Kloper . Technion . 
 *
 * complete.c -- add readline completion features to tcl .
 * 
 */

#include <string.h>
#include "rl.h"


extern Tcl_Interp *rl_interp;

/*
 * Rl_AlternativeCompleteCall -- see explanation of Rl_AlternativeComplete()
 * The difference that this function receives tcl command name to run as
 * a parameter .
 *
 */
static
char ** Rl_AlternativeCompleteCall (text,start,end,name)
char *text;
int start;
int end;
char *name;
{
  char **argv;
  int argc;
  Tcl_CmdInfo info;
  char sstart[20];
  char send[20];

  if(!Tcl_GetCommandInfo(rl_interp,name,&info)) return NULL;
  strcpy(sstart,ltoa(start));
  strcpy(send,ltoa(end));
  if(Tcl_VarEval(rl_interp,name," {",text,"} ",
		 sstart," ",send,(char*)NULL) == TCL_ERROR) 
    return NULL;
  
  if(Tcl_SplitList(rl_interp,rl_interp->result,&argc,&argv) == TCL_ERROR) 
    return NULL;
  if(argc > 0) return argv;
  return NULL;
}

/*
 * Rl_AlternativeComplete () -- this is alternative complete function
 * for readline . It is written for 'rl_attempted_completion_function' hook .
 * It searches for tcl function 'rl_complete_matches' . If it exists it calls
 * it with TEXT START END parameters and expects result to be plain tcl list .
 * If all right ( the returned list is not empty ) the splitted list is returned .
 */


char ** Rl_AlternativeComplete (text,start,end)
char *text;
int start;
int end;
{
  return Rl_AlternativeCompleteCall(text,start,end,"rl_complete_matches");
}

/*
 * Rl_CompleteGeneratorCall() -- see explanation of Rl_CompleteGenerator()
 * The difference that this function receives tcl command name to run as
 * a parameter .
 *
 */

static
char *Rl_CompleteGeneratorCall(text,count,name)
char *text;
int count;
char *name;
{
  Tcl_CmdInfo info;
  char *result;

  if(!Tcl_GetCommandInfo(rl_interp,name,&info)) return NULL; 
  if(Tcl_VarEval(rl_interp,name," {",text,"} ",
		 ltoa(count),(char*)NULL) == TCL_ERROR) 
    return NULL;
  if(*rl_interp->result == '\0') return NULL;
  if((result = (char*)ckalloc(strlen(rl_interp->result) + 1)) == NULL) return NULL;
  strcpy(result,rl_interp->result);
  return result;
}

/*
 * Rl_CompleteGenerator() -- this is generator function for rl_complete_matches() .
 * It searches for tcl function 'rl_generate_matches' . If it exists it calls it
 * with TEXT COUNT parameters and expects result to be string .
 * Copy of the string is returned .
 */
char *Rl_CompleteGenerator(text,count)
char *text;
int count;
{
  return Rl_CompleteGeneratorCall(text,count,"rl_generate_matches");
}



/* local variable , contains name of current tcl generator */
static
char *tcl_generator = "rl_generate_matches";

/* dummy_generator -- just another wrapper for  Rl_CompleteGeneratorCall() */
static 
char *dummy_generator(text,count)
char *text;
int count;
{
  if(tcl_generator != NULL)
    return Rl_CompleteGeneratorCall(text,count,tcl_generator);
  return NULL;
}

/*
 * Rl_CallCompletionMatchesCmd() -- this is interface to completion_matches() . Syntax
 *  rl_matches text ?proc?
 * 'text' is text to match .
 * 'proc' must be rl_generate_matches like procedure , if ommited rl_generate_matches is 
 * used . Returs tcl list of all matches .
 */

int Rl_CallCompletionMatchesCmd(cdata, interp, argc, argv)
     ClientData cdata;                   /* Client Data */
     Tcl_Interp *interp;                 /* Current interpreter. */
     int argc;                           /* Number of arguments. */
     char **argv;                        /* Argument strings. */
{
  char **largv,**ptr;
  int largc = 0;

  if(argc < 2 || argc > 3) {
    Tcl_AppendResult(interp,"wrong # of args , should be \"",argv[0],
		     " text ?proc?\"",(char*)NULL);
    return TCL_ERROR;
  }
  
  if(argc == 3) tcl_generator = argv[2];
  largv = completion_matches(argv[1],dummy_generator);
  for(ptr = largv ; ptr != NULL && *ptr != NULL ; ptr++) largc++;
  Tcl_SetResult(interp,Tcl_Merge(largc,largv),TCL_DYNAMIC);
  return TCL_OK;
}

/*
 * Rl_CompleteInternalCmd() -- interface to rl_complete_internal() . Syntax :
 *  rl_complete_internal what_to_do
 *  'what_to_do' is one from following :
 *      "?" or "list" -- list all possible completions
 *      "\t" or "standard" -- make standard completion
 *      "*" or "insert" -- insert all possible completions
 *      "!" or "display" -- display all possible completions and perform completion
 *      if possible .
 */
int Rl_CompleteInternalCmd(cdata, interp, argc, argv)
     ClientData cdata;                   /* Client Data */
     Tcl_Interp *interp;                 /* Current interpreter. */
     int argc;                           /* Number of arguments. */
     char **argv;                        /* Argument strings. */
{
  char what_to_do;

  if(argc != 2) {
    Tcl_AppendResult(interp,"wrong # of args , should be \"",argv[0],
		     " whet-to_do\"",(char*)NULL);
    return TCL_ERROR;
  }

  if(strcmp(argv[1],"?") == 0 || strcmp(argv[1],"list") == 0) what_to_do = '?';
  else
  if(strcmp(argv[1],"\t") == 0 || strcmp(argv[1],"standard") == 0) what_to_do = '\t';
  else
  if(strcmp(argv[1],"*") == 0 || strcmp(argv[1],"insert") == 0) what_to_do = '*';
  else
  if(strcmp(argv[1],"!") == 0 || strcmp(argv[1],"display") == 0) what_to_do = '!';
  else {
    Tcl_AppendResult(interp,"wrong option : ",argv[1],(char*)NULL);
    return TCL_ERROR;
  }
  
  Tcl_SetResult(interp,ltoa(rl_complete_internal(what_to_do)),TCL_VOLATILE);
  return TCL_OK;

}
