/*
 * $Id: display.c,v 1.1 1995/05/26 19:57:55 dimka Exp $
 *
 * $Log: display.c,v $
 * Revision 1.1  1995/05/26  19:57:55  dimka
 * Initial revision
 *
 *
 * Copyright (C) 1995 Dimitry Kloper . Technion . 
 *
 * display.c -- this file contains redisplay support . 
 *              See readline.info::...::Redisplay
 * 
 */

#include <tcl.h>
#include <readline.h>
#include "rl.h"

/* 
 * Rl_MessageCmd() -- interface to rl_message() . Syntax :
 *    rl_message ?string?
 * if string is given display it in echo arrea , otherwise
 * clear echo arrea with rl_clear_message()
 */

int Rl_MessageCmd(cdata, interp, argc, argv)
     ClientData cdata;                   /* Client Data */
     Tcl_Interp *interp;                 /* Current interpreter. */
     int argc;                           /* Number of arguments. */
     char **argv;                        /* Argument strings. */
{
  if(argc < 1 || argc > 2) {
    Tcl_AppendResult(interp,"wrong # of args , should be \"",argv[0]," ?string?\"",(char*)NULL);
    return TCL_ERROR;
  }

  if(argc == 1) {
    rl_clear_message();
    return TCL_OK;
  }
  
  rl_message("%s",argv[1],NULL);
  return TCL_OK;
}

/*
 * Rl_DisplayCmd() -- interface to redisplay functions . Syntax :
 *   rl_display ?option?
 *     where option can be :
 *       update -- rl_forced_to_update_display() will be called
 *       new_line -- rl_on_new_line() will be called
 *       clear -- rl_reset_line_state() will be called
 *   without options rl_redisplay() will be called .
 */
int Rl_DisplayCmd(cdata, interp, argc, argv)
     ClientData cdata;                   /* Client Data */
     Tcl_Interp *interp;                 /* Current interpreter. */
     int argc;                           /* Number of arguments. */
     char **argv;                        /* Argument strings. */
{
  if(argc < 1 || argc > 2) {
    Tcl_AppendResult(interp,"wrong # of args , should be \"",argv[0]," ?option?\"",(char*)NULL);
    return TCL_ERROR;
  }
    
  if(argc == 1) rl_redisplay();
  else
  if(strcmp(argv[1],"update") == 0) rl_forced_update_display();
  else
  if(strcmp(argv[1],"new_line") == 0) rl_on_new_line();
  else
  if(strcmp(argv[1],"clear") == 0) rl_reset_line_state();
  else {
    Tcl_AppendResult(interp,"not valid option : ",argv[1],(char*)NULL);
    return TCL_ERROR;
  }
    
  return TCL_OK;
}
