#
# $Id: tclrsh.tcl,v 1.6 1995/07/25 07:59:40 dimka Exp $
#
# $Log: tclrsh.tcl,v $
# Revision 1.6  1995/07/25  07:59:40  dimka
# none
#
# Revision 1.5  1995/07/20  10:57:57  dimka
# rl_event_handler is now variable which contains
# actual handler name.
#
# Revision 1.4  1995/07/18  22:00:55  dimka
# Draft Release
#
# Revision 1.3  1995/05/27  21:28:23  dimka
# Undo support is added
#
# Revision 1.2  1995/05/27  16:54:06  dimka
# history support upgraded
#
# Revision 1.1  1995/05/26  18:46:45  dimka
# Initial revision
#
#
# tclrsh.tcl -- make rlsh to be like tcsh

#
# used for debugging 
#
proc print_bind { keyseq keymap } {
   if { [catch {
      rl_message "$keyseq $keymap"
      rl_display new_line
   }] != 0 } {
      puts stderr $errorInfo
   }
}

#
# matches generator 
#
#proc rl_generate_matches { text count } {
#   global tcl_completion_list
#   global env
#   global errorInfo
#   set res {}
#
#   if { $count == 0 } {
#      set tcl_completion_list [concat [info command ${text}*] [glob -nocomplain ${text}*]]
#   } 
#   
#   if { $tcl_completion_list != {} } {  
#      set res [lindex $tcl_completion_list 0]
#      set tcl_completion_list [lrange $tcl_completion_list 1 end]
#   }
#
#   return $res      
#}

#
# use this for fun
#
proc rl_event_hook {} {
   global rl_prompt 
   rl_message [rl_expand_prompt $rl_prompt]
}

#
# This procedure receives start and end positions and trying
# to analize the rl_line_buffer for information what to match
# in different situations only command , variable , file name etc.. 
# can be matched.
#
proc rl_match_what { start end } {
   global rl_line_buffer
   set res {}

   set prefix [string trim [string range $rl_line_buffer 0 [expr $start - 1]] " \n\t"]
   set pend [expr [string length $prefix] - 1]


   if { $prefix == "" } { 
      set res {exe cmd dir} 
   } elseif { [string index $prefix $pend] == "\{" } { 
      set res {cmd} 
   } elseif { [string index $prefix $pend] == "\[" } { 
      set res {cmd} 
   } elseif { [string index $prefix $pend] == "\$" } { 
      set res {var} 
   } elseif { [set lep [string last exec $prefix]] >= 0 && $lep == ($pend - 3) } { 
      set res {exe dir} 
   } elseif { [set lep [string last set $prefix]] >=0 && $lep == ($pend - 2) } { 
      set res {var} 
   } else { 
      set res {fle} 
   }

   return $res
}

#
# procedures below are used for actual text completion
# 
proc rl_complete_cmd { text } {
   return [info commands "$text*"]
}

proc rl_complete_var { text } {
   return [uplevel 3 "concat \[info vars \"$text*\"\] \[info globals \"$text*\"\] "]
}

proc strsame { str1 str2 } {
   set res {}
   for { set i 0 } { [string index $str1 $i] != {} && [string index $str2 $i] != {} } { incr i } {
      if { [string index $str1 $i] == [string index $str2 $i] } { 
	 set res "$res[string index $str1 $i]"
      } else {
	 return $res
      }
   }
   return $res
}

proc rl_complete_exe { text } {
   set res {}
   
   foreach file [glob -nocomplain "$text*"] {
      if { ![file isdirectory $file] && [file executable $file] } {
	 lappend res $file
      }
   }
   return $res
}

proc rl_complete_dir { text } {
   set res {}
   
   foreach file [glob -nocomplain "$text*"] {
      if { [file isdirectory $file] } {
	 lappend res $file
      }
   }
   return $res
}


proc rl_complete_fle { text } {
   return [glob -nocomplain "$text*"]
}

#
# this procedure returns the longest match among of matches list
#
#
proc rl_find_best_completion { text matches } {
   if { $matches == {} } {
      return $text 
   }

   set best [lindex $matches 0]
   foreach word $matches {
      set best [strsame $best $word]
      if { $best == {} } { break }
   }

   if { [string length $best] > [string length $text] } {
      return $best
   } 
   return $text
}

#
# this is actulal matches completer
#
proc rl_complete_matches { text start end } {
   global errorInfo

   set res {}

   foreach match [rl_match_what $start $end] {

      switch $match {
	 cmd { set res [concat $res [rl_complete_cmd $text]] } \
	 var { set res [concat $res [rl_complete_var $text]] } \
	 exe { set res [concat $res [rl_complete_exe $text]] } \
	 dir { set res [concat $res [rl_complete_dir $text]] } \
	 fle { set res [concat $res [rl_complete_fle $text]] }
      }  
   }

   return [concat [list [rl_find_best_completion $text $res]] $res]
}

#
# scroll history upon request
#
proc hist_revert { keyseq keymap } {
   global chistev
   global rl_point 

   set nextid [history nextid]
   if { [ catch {
      switch $keyseq {
	 "\\eOA" -
	 "\\C-p" {
	    set hist [history event [expr ($nextid - [incr chistev]) % $nextid]]
	 } \
	 "\\eOB" -
	 "\\C-n" {
            set hist [history event [expr ($nextid - [incr chistev -1]) % $nextid]]
         }
      }
      rl_text delete 0 
      set rl_point 0
      rl_text insert $hist 
   } ] == 1 } {
   }
}

#
# undo 
#
proc undo { keyseq keymap } {
   rl_undo
}

#
# remember tcsh prompt format ? Here is the same one
#
proc rl_expand_prompt { prompt } {
   global env

   set date [split [exec date]]
   set day [lindex $date 0]
   set month [lindex $date 1]
   set dnum [lindex $date 2]
   if { $dnum == {} } { 
      set dnum [lindex $date 3]
      set time [lindex $date 4]
   } else {
      set time [lindex $date 3]
   }
 
   regsub "\%d" "$prompt" "$day $month $dnum" prompt
   regsub "\%t" "$prompt" $time prompt
   
   regsub $env(HOME) [pwd] ~ path
   regsub "\%p" "$prompt" $path prompt
   
   set host [exec hostname]
   regsub "\%H" "$prompt" $host prompt
   regsub "\%h" "$prompt" [lindex [split $host .] 0] prompt
   return $prompt
}

#
# This is rl_complete from GNU Readline analog. Here I use it for 
# moving cursor back one position after completion.
#
proc rl_complete { ks km } {
   global errorInfo 
   global rl_point
   global rl_end
   global rl_line_buffer
   
   rl_complete_internal !
   if { $rl_point == $rl_end && [string index $rl_line_buffer [expr $rl_end -1]] == " " } {
      incr rl_point -1
      rl_delete_text $rl_point $rl_end
   }
}

set msg {}
set chistev 0
set rl_prompt "%h %t %p >"
set rl_dbg_prompt "dbg>"
set rl_prompt2 "==()=>"
set rl_dbg_prompt2 "%==d=>"

rl_bind "\\C-p" [rl_get_keymap] hist_revert
rl_bind "\\C-n" [rl_get_keymap] hist_revert
if { [info exists rl_strong_bindings] == 1 } {
   rl_bind "\\eOA" [rl_get_keymap] hist_revert
   rl_bind "\\eOB" [rl_get_keymap] hist_revert
}
rl_bind "\\C-_" [rl_get_keymap] undo
rl_bind "\\C-u" [rl_get_keymap] undo
rl_bind "\\C-i" [rl_get_keymap] rl_complete

set rl_basic_word_break_characters " \t\n\"\\'`\[\]\{\}@$><=;|&{("
set rl_completer_word_break_characters $rl_basic_word_break_characters
set rl_filename_completion_desired 0


proc interactor { prompt prompt2 } {
   global chistev

   set line [readline [rl_expand_prompt $prompt]]
   if { "$line" == "" } { return 0 } 
   while { [info complete "$line"] != 1 } {
      set line "$line\n[readline [rl_expand_prompt $prompt2]]"
   }

   set command [lindex [split $line] 0]
   set exec {}
   
   set chistev 0
   if { [info commands $command] == {} } { 
      set exec "exec "
   }

   set hist_line $line
   set line "$exec$line"


   if { [set res [catch {puts stdout [uplevel 1 "$line"]} msg]] == 1 } {
      puts stdout "$msg"
   }

   history add $hist_line
   
   return $res
}

proc dbg_interactor {} {
   global rl_dbg_prompt
   global rl_dbg_prompt2

   while {[rl_dbg] == 1} {
      set res [uplevel 1 "interactor \"$rl_dbg_prompt\" \"$rl_dbg_prompt2\""]
      if { $res == 2 } break;
   }   
}


#proc all { file } {
#   return 1 
#}

#rl_setDbgIgnoreFuncs all
#rl_setDbgInteractor dbg_interactor

while 1 { interactor $rl_prompt $rl_prompt2}









