/*
 * $Id: libes_dbg.c,v 1.2 1995/07/18 22:00:20 dimka Exp $
 *
 * $Log: libes_dbg.c,v $
 * Revision 1.2  1995/07/18  22:00:20  dimka
 * Draft Release
 *
 * Revision 1.1  1995/06/02  19:32:40  dimka
 * Initial revision
 *
 *
 * Copyright (C) 1995 Dimitry Kloper . Technion . 
 *
 * libes_dbg.c -- rl support for Don Libes tcl debugger .
 *
 */

#ifdef WITH_LIBES_DBG

#include <string.h>
#include "rl.h"
#include <Dbg.h>


static
int Rl_DbgIgnoreAll _ANSI_ARGS_((Tcl_Interp *interp,char *file));

/*
 * Rl_DbgActiveCmd() -- return 1 if we are currently in debug mode . Syntax
 *   rl_dbg
 *
 */

int Rl_DbgActiveCmd(cdata, interp, argc, argv)
     ClientData cdata;                   /* Client Data */
     Tcl_Interp *interp;                 /* Current interpreter. */
     int argc;                           /* Number of arguments. */
     char **argv;                        /* Argument strings. */
{
  if(argc != 1) {
    Tcl_AppendResult(interp,"wrong # of arguments , should be \"",argv[0],"\"",(char*)NULL);
    return TCL_ERROR;
  }
  
  Tcl_SetResult(interp,Dbg_Active(interp)?"1":"0",TCL_STATIC);
  return TCL_OK;
}

/* 
 * This is pointer to name of tcl function which will be called
 * as an actual interactor .
 *
 */
static
char *tcl_dbg_interactor = NULL;
static
Dbg_InterProc *old_interactor = NULL;

/*
 * Rl_DbgInteractor() -- interactor which will be used by Dbg . It looks for
 * tcl function named by tcl_dbg_interactor . If it exists it executes it .
 * The tcl function interacts with user and and must exit only on TCL_RETURN .
 *
 */

int Rl_DbgInteractor(interp)
Tcl_Interp *interp;
{
  Tcl_CmdInfo info;

  if(tcl_dbg_interactor == NULL ||
     !Tcl_GetCommandInfo(interp,tcl_dbg_interactor,&info)) 
    if(old_interactor == NULL) {
      Tcl_AppendResult(interp,"can't find Dbg interactor . internal bug ?",(char*)NULL);
      return TCL_ERROR;
    } else {
      (*old_interactor)(interp);
      return TCL_OK;
    }

  if(Tcl_Eval(interp,tcl_dbg_interactor) == TCL_ERROR) {
    fprintf(stdout,"%s\n",interp->result);
    if(old_interactor == NULL) {
      Tcl_AppendResult(interp,"can't find Dbg interactor . internal bug ?",(char*)NULL);
      return TCL_ERROR;
    } else {	
      (*old_interactor)(interp);
      return TCL_OK;
    }
  } 
   
  return TCL_OK;
}

/* 
 * Rl_SetDbgInteractorCmd() -- set tcl function as current dbg interactor .Syntax :
 *  rl_setDbgInteractor ?proc?
 *
 *  if 'proc' is ommited , the curent interactor name is returned . If proc == {}
 *  the interactor is reset to the default one .
 *  Old interactor name is returned .
 */

int Rl_SetDbgInteractorCmd(cdata, interp, argc, argv)
     ClientData cdata;                   /* Client Data */
     Tcl_Interp *interp;                 /* Current interpreter. */
     int argc;                           /* Number of arguments. */
     char **argv;                        /* Argument strings. */
{
  char *old_tcl_interactor = tcl_dbg_interactor ;

  if(argc < 1 || argc > 2) {
    Tcl_AppendResult(interp,"wrong # of arguments , should be \"",argv[0],
		     " ?proc?\"",(char*)NULL);
    return TCL_ERROR;
  }

  if(argc == 2) {
    if(*argv[1] != '\0') {
      if((tcl_dbg_interactor = (char*)ckalloc(strlen(argv[1])+1)) == NULL) {
	Tcl_AppendResult(interp,"can't allocate memory",(char*)NULL);
	return TCL_ERROR;
      }
      strcpy(tcl_dbg_interactor,argv[1]);
    } else
      tcl_dbg_interactor = NULL;
  }
  
  if(old_interactor == NULL) 
    old_interactor = Dbg_Interactor(interp,Rl_DbgInteractor);
  
  if(old_tcl_interactor)
    Tcl_SetResult(interp,old_tcl_interactor,TCL_DYNAMIC);
  return TCL_OK;
    
}

static
char *tcl_ignorefunc = NULL;
static
Dbg_IgnoreFuncsProc *old_ignorefunc = NULL;

/*
 * Ignore function which ignores everything 
 */
static
int Rl_DbgIgnoreAll(interp,file)
Tcl_Interp *interp;
char *file;
{
  return 1;
}

/*
 * Rl_DbgIgnoreFunc() -- this is ignore function for Dbg .
 * See Rl_DbgInteractor .
 *
 *
 */
 
int Rl_DbgIgnoreFunc(interp,file)
Tcl_Interp *interp;
char *file;
{
  Tcl_CmdInfo info;
  Dbg_IgnoreFuncsProc *old_ignore;

  if(tcl_ignorefunc == NULL ||
     !Tcl_GetCommandInfo(interp,tcl_ignorefunc,&info)) {
    if(old_ignorefunc != NULL) 
      return (*old_ignorefunc)(interp,file);
    else return 0;
  }

  old_ignore = Dbg_IgnoreFuncs(interp,Rl_DbgIgnoreAll);

  if(Tcl_VarEval(interp,tcl_ignorefunc," ",file,(char*)NULL) == TCL_ERROR) {
    fprintf(stderr,"%s\n",interp->result);
    Dbg_IgnoreFuncs(interp,old_ignore);
    if(old_ignorefunc != NULL) 
      return (*old_ignorefunc)(interp,file);
    else return 0;
  } 

  Dbg_IgnoreFuncs(interp,old_ignore);
  return(  *interp->result == '0' ? 0 : 1 );
}


/*
 * Rl_SetIgnoreFuncCmd() -- set ignore func , works like Rl_SetDbgInteractorCmd()
 */

int Rl_SetDbgIgnoreFuncCmd(cdata, interp, argc, argv)
     ClientData cdata;                   /* Client Data */
     Tcl_Interp *interp;                 /* Current interpreter. */
     int argc;                           /* Number of arguments. */
     char **argv;                        /* Argument strings. */
{
  char *old_tcl_ignorefunc = tcl_ignorefunc ;

  if(argc < 1 || argc > 2) {
    Tcl_AppendResult(interp,"wrong # of arguments , should be \"",argv[0],
		     " ?proc?\"",(char*)NULL);
    return TCL_ERROR;
  }

  if(argc == 2) {
    if(*argv[1] != '\0') {
      if((tcl_ignorefunc = (char*)ckalloc(strlen(argv[1])+1)) == NULL) {
	Tcl_AppendResult(interp,"can't allocate memory",(char*)NULL);
	return TCL_ERROR;
      }
      strcpy(tcl_ignorefunc,argv[1]);
    } else
      tcl_ignorefunc = NULL;
  }
  
  if(old_ignorefunc == NULL) 
    old_ignorefunc = Dbg_IgnoreFuncs(interp,Rl_DbgIgnoreFunc);
  
  if(old_tcl_ignorefunc)
    Tcl_SetResult(interp,old_tcl_ignorefunc,TCL_DYNAMIC);
  return TCL_OK;
}

/*
 * Rl_DbgArgcArgvCmd() -- interface for Dbg_ArgcArgv() . Syntax :
 *  rl_setDbgArgs list
 * list is the argv list .
 */
int Rl_DbgArgcArgvCmd(cdata, interp, argc, argv)
     ClientData cdata;                   /* Client Data */
     Tcl_Interp *interp;                 /* Current interpreter. */
     int argc;                           /* Number of arguments. */
     char **argv;                        /* Argument strings. */
{
  char **largv;
  int largc;
  
  if(argc != 2) {
    Tcl_AppendResult(interp,"wrong # of arguments , should be \"",argv[0],
		     " list\"",(char*)NULL);
    return TCL_ERROR;
  }
  if(Tcl_SplitList(interp,argv[1],&largc,&largv) == TCL_ERROR) 
    return TCL_ERROR;
  Dbg_ArgcArgv(largc,largv,0);
  return TCL_OK;
    
}

#endif
