/*
 * $Id: rl.h,v 1.5 1995/07/20 10:58:09 dimka Exp $
 *
 * $Log: rl.h,v $
 * Revision 1.5  1995/07/20  10:58:09  dimka
 * rl_event_handler is now variable which contains
 * actual handler name.
 *
 * Revision 1.4  1995/07/18  22:04:58  dimka
 * Draft Release
 *
 * Revision 1.3  1995/05/28  15:47:58  dimka
 * Rl_StrVars p field is now char**
 *
 * Revision 1.2  1995/05/27  21:30:24  dimka
 * new commands are added
 *
 * Revision 1.1  1995/05/26  21:15:36  dimka
 * Initial revision
 *
 * 
 * Copyright (C) 1995 Dimitry Kloper . Technion . 
 *
 * rl.h -- definitions for rl extension .
 *
 */

#ifndef _rl_h_
#define _rl_h_

#include <stdio.h>
#include <stdlib.h>
#include <readline.h>
#include <tcl.h>

typedef struct { char *name ; int *p ; int w; } Rl_IntVars;
typedef struct { char *name ; char **p ; int w; } Rl_StrVars;
typedef struct { char *name ; char** name_var;Function **rl_hook;Function* hook;} Rl_Hooks; 
typedef struct { int count ; Tcl_HashTable table; } Rl_KeymapTable;
typedef struct { Keymap map; Tcl_HashTable table; } Rl_KeymapEntry;

EXTERN int Rl_Init _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN int Rl_ReadlineCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,int argc,char **argv));
EXTERN int Rl_MkBareKeymapCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
					   int argc,char **argv));
EXTERN int Rl_MkKeymapCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
				       int argc,char **argv));
EXTERN int Rl_CopyKeymapCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
					 int argc,char **argv));
EXTERN int Rl_DelKeymapCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
					int argc,char **argv));
EXTERN int Rl_GetKeymapCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
					int argc,char **argv));
EXTERN int Rl_SetKeymapCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
					int argc,char **argv));
EXTERN int Rl_GetByNameKeymapCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
					      int argc,char **argv));
EXTERN int Rl_BindCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
				   int argc,char **argv));
EXTERN int Rl_Parse_n_BindCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
					   int argc,char **argv));
EXTERN int Rl_MessageCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
				      int argc,char **argv));
EXTERN int Rl_DisplayCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
				      int argc,char **argv));
EXTERN int Rl_TextCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
				   int argc,char **argv));
EXTERN int Rl_InfoCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
				   int argc,char **argv));
EXTERN int Rl_UndoCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
				   int argc,char **argv));
EXTERN int Rl_CallCompletionMatchesCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
						    int argc,char **argv));
EXTERN int Rl_CompleteInternalCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
				   int argc,char **argv));

#ifdef WITH_LIBES_DBG
EXTERN int Rl_DbgActiveCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
					int argc,char **argv));
EXTERN int Rl_SetDbgInteractorCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
					int argc,char **argv));
EXTERN int Rl_SetDbgIgnoreFuncCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
					int argc,char **argv));
EXTERN int Rl_DbgArgcArgvCmd _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
					int argc,char **argv));


EXTERN int Rl_DbgInteractor _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN int Rl_DbgIgnoreFunc _ANSI_ARGS_((Tcl_Interp *interp,char* file));
#endif



EXTERN char *Rl_TraceInt _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
				      char *name1,char *name2,int flags));
EXTERN char *Rl_TraceStr _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
				      char *name1,char *name2,int flags));
EXTERN char *Rl_TraceHook _ANSI_ARGS_((ClientData cdata,Tcl_Interp *interp,
				      char *name1,char *name2,int flags));

EXTERN char **Rl_AlternativeComplete _ANSI_ARGS_((char *text,int start,int end));
EXTERN char *Rl_CompleteGenerator _ANSI_ARGS_((char *text,int count));
EXTERN int Rl_ProceedEvent _ANSI_ARGS_((int count,int key));

#if defined(NEED_LTOA) 
EXTERN char *ltoa _ANSI_ARGS_((long x));
#endif
#if defined(NEED_XLTOA)
EXTERN char *xltoa _ANSI_ARGS_((unsigned long x));
#endif

#define isBad(x) (((x)<0)||((x)>last))

#endif
