/*
 * $Id: text.c,v 1.3 1995/07/18 22:03:01 dimka Exp $
 *
 * $Log: text.c,v $
 * Revision 1.3  1995/07/18  22:03:01  dimka
 * Draft Release
 *
 * Revision 1.2  1995/05/27  21:28:55  dimka
 * isBad macro removed to rl.h
 *
 * Revision 1.1  1995/05/26  21:13:56  dimka
 * Initial revision
 *
 *
 * Copyright (C) 1995 Dimitry Kloper . Technion . 
 *
 * text.c -- contains support for modifying text rl
 *           functions .
 */
 
#include <string.h>
#include "rl.h"

extern char *rl_copy_text _ANSI_ARGS_((int,int));

/*
 * Rl_TextCmd() -- interface to modifying text functions . Syntax :
 *  rl_text option opt1 ?opt2?
 *   where option is one from the following :
 *     insert -- this inserts text 'opt1' in current cursor position 
 *               opt2 is skipped .
 *     delete -- this deletes text from the current readline buffer 
 *               opt1 , op2 are start and end positions respectively .
 *               opt1 must represent integer , opt2 represents integer
 *               If opt2 is not mentioned , the text will be deleted up 
 *               to end of buffer .
 *     copy   -- this will return copy of the text . opt1 & opt2 same as for 'delete'
 *     kill   -- this is same as 'delete' but deleted text inserted into
 *               kill ring .
 *   The affected text is always returned .
 */

int Rl_TextCmd(cdata, interp, argc, argv)
     ClientData cdata;                   /* Client Data */
     Tcl_Interp *interp;                 /* Current interpreter. */
     int argc;                           /* Number of arguments. */
     char **argv;                        /* Argument strings. */
{
  int start,end,last;
  char *text;

  if(argc < 3 || argc > 4) {
    Tcl_AppendResult(interp,"wrong # of args , should be \"",argv[0],
		     " option opt1 ?opt2?\"",(char*)NULL);
    return TCL_ERROR;
  }

  if(rl_line_buffer != NULL) last = end = strlen(rl_line_buffer);
  else last = end = 0;

  if(strcmp(argv[1],"insert") == 0) rl_insert_text((text = argv[2]));
  else
  if(strcmp(argv[1],"delete") == 0) {
    if(Tcl_GetInt(interp,argv[2],&start) != TCL_OK || isBad(start)) {
      Tcl_AppendResult(interp,"unexpected integer  : ",argv[2],(char*)NULL);
      return TCL_ERROR;
    }
    if(argc == 4)
      if(Tcl_GetInt(interp,argv[3],&end) != TCL_OK || isBad(end)) {
	Tcl_AppendResult(interp,"unexpected integer  : ",argv[2],(char*)NULL);
	return TCL_ERROR;
      }

    if((text = rl_copy_text(start,end)) == NULL) {
      Tcl_AppendResult(interp,"can't copy text ",(char*)NULL);
      return TCL_ERROR;
    }
    rl_delete_text(start,end);
  }
  else
  if(strcmp(argv[1],"copy") == 0) {
    if(Tcl_GetInt(interp,argv[2],&start) != TCL_OK || isBad(start)) {
      Tcl_AppendResult(interp,"unexpected integer  : ",argv[2],(char*)NULL);
      return TCL_ERROR;
    }
    if(argc == 4)
      if(Tcl_GetInt(interp,argv[3],&end) != TCL_OK || isBad(end)) {
	Tcl_AppendResult(interp,"unexpected integer  : ",argv[2],(char*)NULL);
	return TCL_ERROR;
      }

    if((text = rl_copy_text(start,end)) == NULL) {
      Tcl_AppendResult(interp,"can't copy text ",(char*)NULL);
      return TCL_ERROR;
    }
  }
  else
  if(strcmp(argv[1],"kill") == 0) {
    if(Tcl_GetInt(interp,argv[2],&start) != TCL_OK || isBad(start)) {
      Tcl_AppendResult(interp,"unexpected integer  : ",argv[2],(char*)NULL);
      return TCL_ERROR;
    }
    if(argc == 4)
      if(Tcl_GetInt(interp,argv[3],&end) != TCL_OK || isBad(end)) {
	Tcl_AppendResult(interp,"unexpected integer  : ",argv[2],(char*)NULL);
	return TCL_ERROR;
      }

    if((text = rl_copy_text(start,end)) == NULL) {
      Tcl_AppendResult(interp,"can't copy text ",(char*)NULL);
      return TCL_ERROR;
    }
    rl_kill_text(start,end);
  }
  else {
    Tcl_AppendResult(interp,"not valid option : ",argv[1],(char*)NULL);
    return TCL_ERROR;
  }

  Tcl_SetResult(interp,text,TCL_DYNAMIC);
      
  return TCL_OK;
}
