/*
 * $Id: undo.c,v 1.1 1995/05/27 21:28:32 dimka Exp $
 *
 * $Log: undo.c,v $
 * Revision 1.1  1995/05/27  21:28:32  dimka
 * Initial revision
 *
 *
 * Copyright (C) 1995 Dimitry Kloper . Technion . 
 * 
 * undo.c -- undo support .
 *
 */

#include <string.h>
#include "rl.h"

/*
 * Rl_UndoCmd -- undo support interface . Syntax :
 *  rl_undo ?option? ?arg1 arg2 ...?
 *  where 'option' is one from the following : 
 *    begin - does not requires params . Calls rl_begin_undo_group()
 *    end - does not requires params . Calls rl_end_undo_group()
 *    add - requires the following params :
 *            what - can be 'begin' 'end' 'insert' 'delete'
 *            text ,start , end  - see rl_add_undo() docs for more info .
 *            if 'start' is ommited beginning of buffer will be used
 *            if 'end' is ommited end of buffer will be used .
 *    free - does not requires params . Calls free_undo_list ()
 *    modify - requires 'start' and 'end' params , calls rl_modifying()
 *  Without any options calls rl_do_undo().
 */

int Rl_UndoCmd(cdata, interp, argc, argv)
     ClientData cdata;                   /* Client Data */
     Tcl_Interp *interp;                 /* Current interpreter. */
     int argc;                           /* Number of arguments. */
     char **argv;                        /* Argument strings. */
{
  int start=0, end=0,last;
  int what;

  if(rl_line_buffer != NULL) last = end = strlen(rl_line_buffer);

  if(argc <= 2) {
    Tcl_SetResult(interp,(rl_do_undo())?"1":"0",TCL_STATIC);
    return TCL_OK;
  }

  if(strcmp(argv[1],"begin") == 0) {
    if(argc > 2) {
      Tcl_AppendResult(interp,"wrong # of args , should be \"",argv[0]," begin\"",
		       (char*)NULL);
      return TCL_ERROR;
    }
    rl_begin_undo_group();
    return TCL_OK;
  }
  else
  if(strcmp(argv[1],"end") == 0) {
    if(argc > 2) {
      Tcl_AppendResult(interp,"wrong # of args , should be \"",argv[0]," end\"",
		       (char*)NULL);
      return TCL_ERROR;
    }
    rl_end_undo_group();
    return TCL_OK;
  }
  else
  if(strcmp(argv[1],"free") == 0) {
    if(argc > 2) {
      Tcl_AppendResult(interp,"wrong # of args , should be \"",argv[0]," free\"",
		       (char*)NULL);
      return TCL_ERROR;
    }
    free_undo_list();
    return TCL_OK;
  }
  else
  if(strcmp(argv[1],"add") == 0) {
    if(argc < 4 || argc > 6) {
      Tcl_AppendResult(interp,"wrong # of args , should be \"",argv[0],
		       " add what text ?start? ?end?\"",
		       (char*)NULL);
      return TCL_ERROR;
    }

    if(argc == 6)
      if(Tcl_GetInt(interp,argv[5],&end) != TCL_OK || isBad(end)) {
	Tcl_AppendResult(interp,"unexpected integer  : ",argv[5],(char*)NULL);
	return TCL_ERROR;
      }    
    if(argc >= 5)
      if(Tcl_GetInt(interp,argv[4],&start) != TCL_OK || isBad(start)) {
	Tcl_AppendResult(interp,"unexpected integer  : ",argv[4],(char*)NULL);
	return TCL_ERROR;
      }
    
    if(strcmp(argv[2],"begin") == 0) what = UNDO_BEGIN;
    else
    if(strcmp(argv[2],"end") == 0) what = UNDO_END;
    else
    if(strcmp(argv[2],"insert") == 0) what = UNDO_INSERT;
    else
    if(strcmp(argv[2],"delete") == 0) what = UNDO_DELETE;
    else {
      Tcl_AppendResult(interp,"wrong undo add option  : ",argv[2],(char*)NULL);
      return TCL_ERROR;
    }

    rl_add_undo(what,start,end,argv[3]);

    return TCL_OK;
  }
  else
  if(strcmp(argv[1],"modify") == 0) {
    if(argc < 2 || argc > 4) {
      Tcl_AppendResult(interp,"wrong # of args , should be \"",argv[0],
		       " modify ?start? ?end?\"",
		       (char*)NULL);
      return TCL_ERROR;
    }

    if(argc == 3)
      if(Tcl_GetInt(interp,argv[5],&end) != TCL_OK || isBad(end)) {
	Tcl_AppendResult(interp,"unexpected integer  : ",argv[5],(char*)NULL);
	return TCL_ERROR;
      }    
    if(argc >= 2)
      if(Tcl_GetInt(interp,argv[4],&start) != TCL_OK || isBad(start)) {
	Tcl_AppendResult(interp,"unexpected integer  : ",argv[4],(char*)NULL);
	return TCL_ERROR;
      }
    
    Tcl_SetResult(interp,(rl_modifying(start,end))?"1":"0",TCL_STATIC);
    return TCL_OK;
  }
  else {
    Tcl_AppendResult(interp,"not valid option : ",argv[1],(char*)NULL);
    return TCL_ERROR;
  }
     
  return TCL_OK; 
}
