
proc mkedges {} {
    global coledit cx cy p1 p2 edge1 edge2 edge3 cwid clen

    set edge1 [$coledit create line 0 $clen $cx($p1) $cy($p1)]
    set edge2 [$coledit create line $cx($p1) $cy($p1) $cx($p2) $cy($p2)] 
    set edge3 [$coledit create line $cx($p2) $cy($p2) $cwid 0]
    $coledit lower $edge1
    $coledit lower $edge2
    $coledit lower $edge3
}

proc mknode {P x y} {
    upvar $P p1
    global coledit cx cy

    set p1 [$coledit create oval [expr $x-2] [expr $y-2] [expr $x+2] [expr $y+2] \
	    -outline black -fill white -tags node]
    set cx($p1) $x
    set cy($p1) $y
}

proc mvnode {node x y} {
    global coledit curr_img p1 p2 edge1 edge2 edge3 cx cy cwid clen
  
    if { $node == $p1 } {
	if { ($x < $cx($p2)) && ($y > $cy($p2)) } {
	    $coledit move $node [expr $x-$cx($p1)] [expr $y-$cy($p1)]
	    set cx($p1) $x
	    set cy($p1) $y
	    $coledit coords $edge1 0 $clen $cx($p1) $cy($p1)
	    $coledit coords $edge2 $cx($p1) $cy($p1) $cx($p2) $cy($p2) 
	   
	} 
    } else {
	if { ($x> $cx($p1)) && ($y <$cy($p1)) } {
	    $coledit move $node  [expr $x-$cx($p2)] [expr $y-$cy($p2)]
	    set cx($p2) $x
	    set cy($p2) $y
	    $coledit coords $edge2 $cx($p1) $cy($p1) $cx($p2) $cy($p2) 
	    $coledit coords $edge3 $cx($p2) $cy($p2) $cwid 0
	}
    }
    if { [info exists curr_img] } {
	$curr_img cmap_stretch [expr $cx($p1)/double($cwid)] \
		[expr ($clen-$cy($p1))/double($clen)] \
		[expr $cx($p2)/double($cwid)] \
		[expr ($clen-$cy($p2))/double($clen)] 
    }
}





