
# from Brent Welsh's book (draft)--Dialog chapter
# modifications made by Kelley Robinson (8/9/95)
# (slight change in interface, bug removed, more
# consistent in directory listing)
# modifications made by Pierre Bossart (10/30/95)
# added filter 
#
#
# to run call fileselect
#
# fileselect returns the selected pathname, or {}
# parameter "default" is the starting file for selection; if 
# none, it starts with home directory.


proc fileselect {{why "File Selection"} {window_name fileselect} \
	{default {}} } {
    global fileselect
    
    catch {destroy .fileselect}
    set t [toplevel .fileselect -bd 4 ]
    
    # rearrangement of interface--start
    wm title .fileselect $window_name

    set f [frame $t.frame]
    pack $f -side top -fill x
    set f1 [frame $f.top]
    pack $f1 -side top -fill x
    set f2 [frame $f.bottom]
    pack $f2 -side top -fill x
    message $f1.msg -aspect 1000  -text $why -padx 0	
    pack $f1.msg -side left
    
    # Create a read-only entry for the durrent directory
    set fileselect(dirEnt) [entry $f2.dir -width 40 \
	    -relief sunken -state disabled -justify left]
    pack $f2.dir -side top -fill x
    
    
    # Create the OK and Cancel buttons
    # The OK button has a rim to indicate it is the default
    frame $f1.ok -bd 2 -relief sunken
    button $f1.ok.b -text OK \
	    -command fileselectOK
    button $f1.cancel -text Cancel \
	    -command fileselectCancel
    pack $f1.cancel $f1.ok \
	    -side right -padx 2
    pack $f1.ok.b
    # rearrangement of interface--end
    
    
    
    # Create an entry for the pathname
    # The value is kept in fileselect(path)
    frame $t.top
    label $t.top.l -text "File:" -padx 0
    set e [entry $t.top.path -relief sunken \
	    -textvariable fileselect(path)]
    pack $t.top -side top -fill x
    pack $t.top.l -side left
    pack $t.top.path -side right -fill x -expand true
    set fileselect(pathEnt) $e
   
    # Set up bindings to invoke OK and Cancel
    bind $e <Return> fileselectOK
    bind $e <Control-c> fileselectCancel
    bind $e <space> fileselectComplete
    focus $e
    
    # Create an entry for the pathname filter
    # The value is kept in fileselect(filter)
    frame $t.bot
    label $t.bot.l -text "Filter:" -padx 0
    set f [entry $t.bot.path -relief sunken \
	    -textvariable fileselect(filter)]
    pack $t.bot -side top -fill x
    pack $t.bot.l -side left
    pack $t.bot.path -side right -fill x -expand true
    set fileselect(filterEnt) $f
    
    # Set up bindings to invoke OK and Cancel
    bind $f <Return> fileselectOK
    bind $f <Control-c> fileselectCancel
    bind $f <space> fileselectComplete
   

    # Create a listbox to hold the directory contents
    listbox $t.list -yscrollcommand [list $t.scroll set]
    scrollbar $t.scroll -command [list $t.list yview]
    
    # A single click copies the name into the entry
    # A double-click selects the name
    bind $t.list <Button-1> {fileselectClick %y}
    bind $t.list <Double-Button-1> {
	fileselectClick %y ; fileselectOK
    }
    
    # Warp focus to listbox so the user can use arrow keys
    bind $e <Tab> "focus $t.list ; $t.list select set 0"
    bind $t.list <Return> fileselectTake
    bind $t.list <space> {fileselectTake ; break}
    bind $t.list <Tab> "focus $e"
    
    
    # Pack the list, scrollbar, and button box
    # in a horizontal stack below the upper widgets
    pack $t.list -side left -fill both -expand true
    pack $t.scroll -side left -fill y
    
    # Initialize variables and list the directory
    if {[string length $default] == 0} {
	set fileselect(path) {}
	set dir [pwd]
    } else {
	set fileselect(path) [file tail $default]
	set dir [file dirname $default]
    }
    set fileselect(dir) {}
    set fileselect(done) 0
    
    # Wait for the listbox to be visible so
    # we can provide feedback during the listing 
    tkwait visibility .fileselect.list
    fileselectList $dir {} $fileselect(filter)
    
    tkwait variable fileselect(done)
    destroy .fileselect
    return $fileselect(path)
}

proc fileselectList { dir {files {}} {filter {}} } {
    global fileselect
    
    # Update the directory, being careful
    # to view the tail end
    set e $fileselect(dirEnt)
    $e config -state normal
    $e delete 0 end
    $e insert 0 $dir
    $e config -state disabled
    $e xview moveto 1
    
    set fileselect(dir) $dir
    .fileselect.list delete 0 end
    .fileselect.list insert 0 Listing...
    update idletasks
    .fileselect.list delete 0

    set dirs {}
    set others {}
    set parent 0
    foreach f [lsort [glob -nocomplain $fileselect(dir)/*]] {
	if [file isdirectory $f] {
	    lappend dirs [file tail $f]
	}
    }
    
    if {[string length $files] == 0} {
	# List the directory and add an
	# entry for the parent directory
	if { [string length $filter] == 0} {
	    set files [glob -nocomplain $fileselect(dir)/*]
	} else {
	    set files [glob -nocomplain $fileselect(dir)/$filter]
	}
	.fileselect.list insert end ../
	set parent 1
    }
    if { $parent != 1 } {
	.fileselect.list insert end ../
    }
    
    foreach f [lsort $files] {
	if ![file isdirectory $f] {
	    lappend others [file tail $f]
	}
    }
    foreach f [concat $dirs $others] {
	.fileselect.list insert end $f
    }
}
proc fileselectOK {} {
    global fileselect
    
    # Handle the parent directory specially
    if {[regexp {\.\./?} $fileselect(path)]} {
	set fileselect(path) {}
	fileselectList [file dirname $fileselect(dir)] {} $fileselect(filter)
	return
    }
    # my additions--end
    if {! [string compare $fileselect(dir) /]} {
	set fileselect(dir) {}
    }
    set slash_index [string last / $fileselect(path)]
    if {$slash_index == -1} {
	set path $fileselect(dir)/$fileselect(path)
    } else {
	set path_len [string length $fileselect(path)]
	set end_path [expr $path_len - 2]
	set end_string [string range $fileselect(path) 0 $end_path]
	set path $fileselect(dir)/$end_string
    }
    # my additions--end
    if [file isdirectory $path] {
	set fileselect(path) {}
	fileselectList $path {} $fileselect(filter)
	return
    }
    if [file exists $path] {
	set fileselect(path) $path
	set fileselect(done) 1
	return
    }
    # Neither a file or a directory.
    # See if glob will find something
    if [catch {glob $path} files] {
	# No, perhaps the user typed a new
	# absolute pathname
	if [catch {glob $fileselect(path)} path] {
	    # Nothing good - attempt completion
	    fileselectComplete
	    return
	} else {
	    # OK - try again
	    set fileselect(dir) [file dirname $fileselect(path)]
	    set fileselect(path) [file tail $fileselect(path)]
	    fileselectOK
	    return
	}
    } else {
	# Ok - current directory is ok,
	# either select the file or list them.
	if {[llength [split $files]] == 1} {
	    set fileselect(path) $files
	    fileselectOK
	} else {
	    set fileselect(dir) [file dirname [lindex $files 0]]
	    fileselectList $fileselect(dir) $files $fileselect(filter)
	}
    }
}
proc fileselectCancel {} {
    global fileselect

    set fileselect(done) 1
    set fileselect(path) {}
}

proc fileselectClick { y } {
    # Take the item the user clicked on
    global fileselect
    set l .fileselect.list
    set fileselect(path) [$l get [$l nearest $y]]
    focus $fileselect(pathEnt)
}
proc fileselectTake {} {
    # Take the currently selected list item and
    # change focus back to the entry
    global fileselect
    set l .fileselect.list
    set fileselect(path) [$l get [$l curselection]]
    focus $fileselect(pathEnt)
}

proc fileselectComplete {} {
    global fileselect

    # Do file name completion
    # Nuke the space that triggered this call
    set fileselect(path) [string trim $fileselect(path) \t\ ]
    
    # Figure out what directory we are looking at
    # dir is the directory
    # tail is the partial name
    if {[string match /* $fileselect(path)]} {
	set dir [file dirname $fileselect(path)]
	set tail [file tail $fileselect(path)]
    } elseif [string match ~* $fileselect(path)] {
	if [catch {file dirname $fileselect(path)} dir] {
	    return	;# Bad user
	}
	set tail [file tail $fileselect(path)]
    } else {
	set path $fileselect(dir)/$fileselect(path)
	set dir [file dirname $path]
	set tail [file tail $path]
    }
    # See what files are there
    set files [glob -nocomplain $dir/$tail*]
    if {[llength [split $files]] == 1} {
	# Matched a single file
	set fileselect(dir) $dir
	set fileselect(path) [file tail $files]
    } else {
	if {[llength [split $files]] > 1} {
	    # Find the longest common prefix
	    set l [expr [string length $tail]-1]
	    set miss 0
	    # Remember that files has absolute paths
	    set file1 [file tail [lindex $files 0]]
	    while {!$miss} {
		incr l
		if {$l == [string length $file1]} {
		    # file1 is a prefix of all others
		    break
		}
		set new [string range $file1 0 $l]
		foreach f $files {
		    if ![string match $new* [file tail $f]] {
			set miss 1
			incr l -1
			break
		    }
		}
	    }
	    set fileselect(path) [string range $file1 0 $l]
	}
	fileselectList $dir $files $fileselect(filter)
    }
}













