

proc mkONode { x y } {
    global ONodeX ONodeY index init_index curr_img
  
    if { $index == $init_index } {
	set ONodeX($index) $x
	set ONodeY($index) $y
	$curr_img overlay  line $ONodeX($index) $ONodeY($index) $x $y
	update idletasks
	set index [expr $index+1]
	set ONodeX($index) $x
	set ONodeY($index) $y
	
    } else {
	set ONodeX($index) $x
	set ONodeY($index) $y
	$curr_img overlay  line $ONodeX($index) $ONodeY($index) $x $y
	update idletasks
	set index [expr $index+1]
	set ONodeX($index) $x
	set ONodeY($index) $y
	
    }
}
proc rmONode {x y} {
    global ONodeX ONodeY index init_index curr_img
  
    if { $index>$init_index } {
	set oldindex [expr $index-1]
	$curr_img overlay  line $ONodeX($oldindex) $ONodeY($oldindex) $ONodeX($index) $ONodeY($index)
	update idletasks
	set savex $ONodeX($oldindex)
	set savey $ONodeY($oldindex)
	set ONodeX($oldindex) $ONodeX($index)
	set ONodeY($oldindex) $ONodeY($index)
	set index $oldindex
	if { $index>$init_index } {
	    set oldindex [expr $index-1]
	    $curr_img overlay  line $ONodeX($oldindex) $ONodeY($oldindex) $savex $savey
	    $curr_img overlay  line $ONodeX($oldindex) $ONodeY($oldindex) $ONodeX($index) $ONodeY($index)
	    update idletasks
	}
    }
}

proc create_poly { } {
    global index init_index curr_img win_array olist gc 

    if { ![info exists curr_img] } {
	return
    }
    set olist {}
    set can $win_array($curr_img).c
    $curr_img overlay setgc "xor"

    bind $can <Button-1> {
	set can $win_array($curr_img).c
	set newx [expr int([$can canvasx %x])]
	set newy [expr int([$can canvasy %y])]
	mkONode $newx $newy
    }
    bind $can <Button-2> {
	set can $win_array($curr_img).c
	set newx [expr int([$can canvasx %x])]
	set newy [expr int([$can canvasy %y])]
	rmONode $newx $newy
    }
    
    bind $can <Motion> {
	set can $win_array($curr_img).c
	set newx [expr int([$can canvasx %x])]
	set newy [expr int([$can canvasy %y])]
	if { $index > $init_index } {
	    set oldindex [expr $index-1]
	    $curr_img overlay  line $ONodeX($oldindex) $ONodeY($oldindex)  $ONodeX($index) $ONodeY($index) $newx $newy
	    update idletasks
	    set ONodeX($index) $newx
	    set ONodeY($index) $newy
	}
    }
    bind $can <Button-3> {
	if { $index > $init_index } {
	    set oldindex [expr $index-1]
	    $curr_img overlay  line $ONodeX($oldindex) $ONodeY($oldindex)  $ONodeX($index) $ONodeY($index)
	    update idletasks
	    set index [expr $index-1]
	    $curr_img overlay  line $ONodeX($init_index) $ONodeY($init_index) $ONodeX($index) $ONodeY($index)
	    update idletasks
	}
	for { set i $init_index} {$i<$index} {incr i} {
	    $curr_img overlay  line $ONodeX($i) $ONodeY($i) $ONodeX([expr $i+1]) $ONodeY([expr $i+1])
	}
	$curr_img overlay  line $ONodeX($init_index) $ONodeY($init_index) $ONodeX($index) $ONodeY($index)
	update idletasks
	grab release $can
	grab .
	undo_poly_binds
	for { set i $init_index} {$i<=$index} {incr i} {
	    lappend olist $ONodeX($i) $ONodeY($i)
	}
	$curr_img overlay setgc $gc
	eval {$curr_img overlay  fill} $olist
	update idletasks
	set init_index 0
	set index 0
    }
}

proc freehand_draw { } {
    global index init_index curr_img win_array olist gc 

    if { ![info exists curr_img] } {
	return
    }
    set olist {}
    set can $win_array($curr_img).c
    $curr_img overlay setgc "set"

    bind $can <Button-1> {
	set can $win_array($curr_img).c
	set newx [expr int([$can canvasx %x])]
	set newy [expr int([$can canvasy %y])]
	if { $index > $init_index } {
	    set oldindex [expr $index-1]
	    set ONodeX($index) $newx
	    set ONodeY($index) $newy
	    $curr_img overlay  line $ONodeX($oldindex) $ONodeY($oldindex)  $ONodeX($index) $ONodeY($index) 
	    update idletasks
	} else {
	    set ONodeX($index) $newx
	    set ONodeY($index) $newy
	}
	incr index
    }

    bind $can <Button-2> {
	set can $win_array($curr_img).c
	set newx [expr int([$can canvasx %x])]
	set newy [expr int([$can canvasy %y])]
	if { $index > $init_index } {
	    set index [expr $index-1]
	    if { $index > $init_index } {
		$curr_img overlay setgc "clear"
		set oldindex [expr $index-1]
		$curr_img overlay  line $ONodeX($oldindex) $ONodeY($oldindex)  $ONodeX($index) $ONodeY($index) 
	    }
	}
    }
    
    bind $can <B1-Motion> {
	set can $win_array($curr_img).c
	set newx [expr int([$can canvasx %x])]
	set newy [expr int([$can canvasy %y])]
	if { $index > $init_index } {
	    set oldindex [expr $index-1]
	    set ONodeX($index) $newx
	    set ONodeY($index) $newy
	    $curr_img overlay  line $ONodeX($oldindex) $ONodeY($oldindex)  $ONodeX($index) $ONodeY($index)
	    update idletasks
	    incr index
	}
    }

    bind $can <Button-3> {
	set index [expr $index -1]
	$curr_img overlay setgc "clear"
	for { set i $init_index} {$i<$index} {incr i} {
	    $curr_img overlay  line $ONodeX($i) $ONodeY($i) $ONodeX([expr $i+1]) $ONodeY([expr $i+1])
	}
	update idletasks
	undo_poly_binds
	for { set i $init_index} {$i<=$index} {incr i} {
	    lappend olist $ONodeX($i) $ONodeY($i)
	}
	$curr_img overlay setgc $gc
	eval {$curr_img overlay  fill} $olist
	update idletasks
	set init_index 0
	set index 0
    }
}
  
proc undo_poly_binds {} {
    global curr_img win_array

    if { ![info exists curr_img]} {
	return    
    }

    set can $win_array($curr_img).c  
    bind $can <Button-1> {}
    bind $can <B1-Motion> {}
    bind $can <Motion> {}
    bind $can <B2-Motion> {}
    bind $can <Button-3> {}
}

proc set_gc {} {
    global gc curr_img

    if { [info exists curr_img] } {
	$curr_img overlay setgc $gc
    }
}
proc ovl_enable {} {
    global curr_img index init_index

    if { [info exists curr_img] } {
	$curr_img overlay enable
	set index 0
	set init_index 0
    }
}
proc ovl_disable {} {
    global curr_img index init_index

    if { [info exists curr_img] } {
	$curr_img overlay disable
	set index 0
	set init_index 0
    }
}

proc ovl_putmask {} {
    global curr_img mask_img

    if { [info exists curr_img] } {
	if { [info exists mask_img] } {
	    if { $mask_img != $curr_img } {
		$curr_img overlay putmask $mask_img
		set index 0
		set init_index 0
	    }
	}
    }
}

proc ovl_getmask {} {
    global curr_img mask_img

    if { [info exists curr_img] } {
	if { [info exists mask_img] } {
	    if { $mask_img != $curr_img } {
		$mask_img overlay getmask $curr_img
	    }
	}
    }
}

proc ovl_setmask {{img {}}} {
    global curr_img mask_img

    if { $img=={} } {
	if { [info exists curr_img] } {
	    set mask_img $curr_img
	}
    } else {
	set mask_img $img
    }
}

proc ovl_createmask {} {
    global curr_img mask_img nb_slices_array seq_array curr_slice_array filename_array
    
    if { [info exists curr_img] } {
	set g [image create pict]
	set nb_slices_array($g) $nb_slices_array($curr_img)
	set seq_array($g) $seq_array($curr_img)
	set curr_slice_array($g) $curr_slice_array($curr_img)
	if { $seq_array($g) == 1} {
	    set filename_array($g) "mask_"
	} else {
	    set filename_array($g) "mask"
	}
	set mask_img $g
    }
}

proc ovl_dispmask {} {
    global mask_img

    if { [info exists mask_img] } {
	disp mask_img
    }
}

proc ovl_savemask {} {
    global mask_img

    if { [info exists mask_img] } {
	wrfile $mask_img
    }
}

proc ovl_erosion {} {
    global curr_img ovl_seg_level
    
    if { [info exists curr_img] } {
	$curr_img overlay erosion 3 3
    }
}

proc ovl_dilation {} {
    global curr_img 
    
    if { [info exists curr_img] } {
	$curr_img overlay dilation 3 3
    }
}

proc ovl_close_holes {} {
    global curr_img 
    
    if { [info exists curr_img] } {
	$curr_img overlay close_holes
    }
}

proc ovl_ct_segment {} {
    global curr_img
    
    if { [info exists curr_img] } {
	$curr_img overlay ct_segment
    }
}

proc ovl_segment_interact {} {
    global curr_img ovl_seg_level
    
    if { [info exists curr_img] } {
	$curr_img overlay segment $ovl_seg_level
    }
}

proc ovl_seed_fill {} {
    global curr_img win_array gc

    if { ![info exists curr_img]} {
	return
    }
    $curr_img overlay setgc $gc
    set can $win_array($curr_img).c
  
    bind $can <Button-1> {
	set can $win_array($curr_img).c
	set newx [expr int([$can canvasx %x])]
	set newy [expr int([$can canvasy %y])]
	$curr_img overlay seed_fill $newx $newy
	undo_poly_binds
    }
} 

proc paint_overlay {} {
    global curr_img win_array bsize btype
    if { [info exists curr_img] } {
	set can $win_array($curr_img).c
	bind $can <Button-1> {
	    set can $win_array($curr_img).c
	    set newx [expr int([$can canvasx %x])]
	    set newy [expr int([$can canvasy %y])]
	    $curr_img overlay $btype [expr $newx-$bsize/2]  [expr $newy-$bsize/2] $bsize $bsize
	}
	bind $can <B1-Motion> {
	    set can $win_array($curr_img).c
	    set newx [expr int([$can canvasx %x])]
	    set newy [expr int([$can canvasy %y])]
	    $curr_img overlay $btype [expr $newx-$bsize/2]  [expr $newy-$bsize/2] $bsize $bsize
	}
    
	bind $can <Button-3> {
	    undo_poly_binds
	}
    }
}

proc make_overlay {} {
    global curr_img def_font gc bsize btype has_nde_segment ovl_seg_level
	
    .overlay configure -state disabled
    set ovl [toplevel .ovl]
   
    wm geometry $ovl +580+30
    wm title $ovl "Overlays"

    set fim [frame .ovl.f0]
    button $fim.e -text "Enable" -command "ovl_enable" -font $def_font
    button $fim.d -text "Disable" -command "ovl_disable" -font $def_font
    button $fim.s -text "Set Mask" -command "ovl_setmask" -font $def_font
    button $fim.p -text "Put Mask" -command "ovl_putmask" -font $def_font
    button $fim.g -text "Get Mask" -command "ovl_getmask" -font $def_font
    button $fim.c -text "Create Mask" -command "ovl_createmask" -font $def_font
    button $fim.di -text "Disp Mask" -command "ovl_dispmask" -font $def_font
    button $fim.sa -text "Save Mask" -command "ovl_savemask" -font $def_font
    pack $fim.e $fim.d $fim.s $fim.p $fim.g $fim.c $fim.di $fim.sa -side top -expand true -fill both -in $fim
   

    set gc "or"
    set fgc [frame $ovl.f1]
    label $fgc.text -text "GC" -font $def_font
    radiobutton $fgc.or -text or -variable gc -value or -command set_gc -font $def_font
    radiobutton $fgc.xor -text xor -variable gc -value xor -command set_gc -font $def_font
    radiobutton $fgc.and -text and -variable gc -value and -command set_gc -font $def_font
    radiobutton $fgc.copy -text copy -variable gc -value copy -command set_gc -font $def_font
    radiobutton $fgc.set -text set -variable gc -value set -command set_gc -font $def_font
    radiobutton $fgc.clear -text clear -variable gc -value clear -command set_gc -font $def_font
    pack $fgc.text $fgc.or $fgc.xor $fgc.and $fgc.copy $fgc.set $fgc.clear -side top  -anchor w -in $fgc
    pack $fgc -side right -anchor ne -in $ovl
     
    set bsize 8
    set btype ellipse
    set fdraw [frame .ovl.f2]
    button $fdraw.p -text "Polygon" -command "create_poly" -font $def_font
    button $fdraw.f -text "Draw/Fill" -command "freehand_draw" -font $def_font
    button $fdraw.pa -text "Paint" -command "paint_overlay" -font $def_font
    scale $fdraw.brush -from 1 -to 20 -orient horizontal \
	    -variable bsize -label "brush sz" -length 3c  -font $def_font
    radiobutton $fdraw.circle -text circle -variable btype -value ellipse \
	    -font $def_font
    radiobutton $fdraw.rect   -text square -variable btype -value rectangle \
	    -font $def_font
    button $fdraw.u -text "Undo Binds" -command "undo_poly_binds" -font $def_font
    pack  $fdraw.p $fdraw.f $fdraw.pa $fdraw.brush $fdraw.circle $fdraw.rect $fdraw.u -side top -anchor w -expand true -fill x -in $fdraw
     
    pack $fim $fdraw -side left -expand true -fill both -in $ovl
    
    if { $has_nde_segment == 1 } {
	set ovl_seg_level 1
	set fsegment [frame .ovl.f3]
	button $fsegment.sct -text "CT Segment" -command "ovl_ct_segment" \
		-font $def_font
	button $fsegment.s -text "Interact \n Segment" \
		-command "ovl_segment_interact"  -font $def_font
	set fsegbutton [frame $fsegment.f1]
	radiobutton $fsegbutton.seg -text segment -variable ovl_seg_level -value 1 \
	    -font $def_font
	radiobutton $fsegbutton.smoseg -text "smooth and segment" -variable ovl_seg_level -value 2 \
	    -font $def_font
	button $fsegment.e -text "Erosion" -command "ovl_erosion" -font $def_font
	button $fsegment.d -text "Dilation" -command "ovl_dilation" -font $def_font
	button $fsegment.c -text "Close Holes" -command "ovl_close_holes" -font $def_font
	button $fsegment.sf -text "Seeded Fill" -command "ovl_seed_fill" -font $def_font
	pack $fsegbutton.seg  $fsegbutton.smoseg  -side top -anchor w -expand true -fill none -in $fsegbutton
	pack $fsegment.e $fsegment.d $fsegment.c $fsegment.sf $fsegment.sct $fsegment.s $fsegbutton -side top -anchor w -expand true -fill x -in $fsegment
	pack $fsegment -side left -in $ovl
    }
    bind $ovl <Destroy> {
	#puts "leaving overlays"
	.overlay configure -state normal
	bind .ovl <Destroy> {}
    }
}
   
   

set index 0
set init_index 0
set ONodeX(0) 0
set ONodeY(0) 0






